/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Collections;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.SectionDescriptor;
import org.apache.poi.hwpf.model.SectionTable;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.util.LittleEndian;

public final class OldSectionTable
extends SectionTable {
    public OldSectionTable(byte[] documentStream, int offset, int size, int fcMin, TextPieceTable tpt) {
        this(documentStream, offset, size);
    }

    public OldSectionTable(byte[] documentStream, int offset, int size) {
        PlexOfCps sedPlex = new PlexOfCps(documentStream, offset, size, 12);
        int length = sedPlex.length();
        int x = 0;
        while (x < length) {
            SEPX sepx;
            GenericPropertyNode node = sedPlex.getProperty(x);
            SectionDescriptor sed = new SectionDescriptor(node.getBytes(), 0);
            int fileOffset = sed.getFc();
            int startAt = node.getStart();
            int endAt = node.getEnd();
            if (fileOffset == -1) {
                sepx = new SEPX(sed, startAt, endAt, new byte[0]);
            } else {
                short sepxSize = LittleEndian.getShort((byte[])documentStream, (int)fileOffset);
                byte[] buf = new byte[sepxSize + 2];
                System.arraycopy(documentStream, fileOffset += 2, buf, 0, buf.length);
                sepx = new SEPX(sed, startAt, endAt, buf);
            }
            this._sections.add(sepx);
            ++x;
        }
        Collections.sort(this._sections, PropertyNode.StartComparator.instance);
    }
}

