/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hslf.record.DocumentAtom;
import org.apache.poi.hslf.record.Environment;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.PPDrawingGroup;
import org.apache.poi.hslf.record.PositionDependentRecordContainer;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.util.POILogger;

public final class Document
extends PositionDependentRecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1000L;
    private DocumentAtom documentAtom;
    private Environment environment;
    private PPDrawingGroup ppDrawing;
    private SlideListWithText[] slwts;
    private ExObjList exObjList;

    public DocumentAtom getDocumentAtom() {
        return this.documentAtom;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PPDrawingGroup getPPDrawingGroup() {
        return this.ppDrawing;
    }

    public ExObjList getExObjList() {
        return this.exObjList;
    }

    public SlideListWithText[] getSlideListWithTexts() {
        return this.slwts;
    }

    public SlideListWithText getMasterSlideListWithText() {
        int i = 0;
        while (i < this.slwts.length) {
            if (this.slwts[i].getInstance() == 1) {
                return this.slwts[i];
            }
            ++i;
        }
        return null;
    }

    public SlideListWithText getSlideSlideListWithText() {
        int i = 0;
        while (i < this.slwts.length) {
            if (this.slwts[i].getInstance() == 0) {
                return this.slwts[i];
            }
            ++i;
        }
        return null;
    }

    public SlideListWithText getNotesSlideListWithText() {
        int i = 0;
        while (i < this.slwts.length) {
            if (this.slwts[i].getInstance() == 2) {
                return this.slwts[i];
            }
            ++i;
        }
        return null;
    }

    protected Document(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        if (!(this._children[0] instanceof DocumentAtom)) {
            throw new IllegalStateException("The first child of a Document must be a DocumentAtom");
        }
        this.documentAtom = (DocumentAtom)this._children[0];
        int slwtcount = 0;
        int i = 1;
        while (i < this._children.length) {
            if (this._children[i] instanceof SlideListWithText) {
                ++slwtcount;
            }
            if (this._children[i] instanceof Environment) {
                this.environment = (Environment)this._children[i];
            }
            if (this._children[i] instanceof PPDrawingGroup) {
                this.ppDrawing = (PPDrawingGroup)this._children[i];
            }
            if (this._children[i] instanceof ExObjList) {
                this.exObjList = (ExObjList)this._children[i];
            }
            ++i;
        }
        if (slwtcount == 0) {
            this.logger.log(POILogger.WARN, (Object)"No SlideListWithText's found - there should normally be at least one!");
        }
        if (slwtcount > 3) {
            this.logger.log(POILogger.WARN, (Object)("Found " + slwtcount + " SlideListWithTexts - normally there should only be three!"));
        }
        this.slwts = new SlideListWithText[slwtcount];
        slwtcount = 0;
        i = 1;
        while (i < this._children.length) {
            if (this._children[i] instanceof SlideListWithText) {
                this.slwts[slwtcount] = (SlideListWithText)this._children[i];
                ++slwtcount;
            }
            ++i;
        }
    }

    public void addSlideListWithText(SlideListWithText slwt) {
        Record endDoc = this._children[this._children.length - 1];
        if (endDoc.getRecordType() != (long)RecordTypes.EndDocument.typeID) {
            throw new IllegalStateException("The last child record of a Document should be EndDocument, but it was " + endDoc);
        }
        this.addChildBefore(slwt, endDoc);
        int newSize = this.slwts.length + 1;
        SlideListWithText[] nl = new SlideListWithText[newSize];
        System.arraycopy(this.slwts, 0, nl, 0, this.slwts.length);
        nl[nl.length - 1] = slwt;
        this.slwts = nl;
    }

    public void removeSlideListWithText(SlideListWithText slwt) {
        ArrayList<SlideListWithText> lst = new ArrayList<SlideListWithText>();
        int i = 0;
        while (i < this.slwts.length) {
            SlideListWithText s = this.slwts[i];
            if (s != slwt) {
                lst.add(s);
            } else {
                this.removeChild(slwt);
            }
            ++i;
        }
        this.slwts = lst.toArray(new SlideListWithText[lst.size()]);
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }
}

