/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.StringChunk;

public final class RecipientChunks
implements ChunkGroup {
    public static final String PREFIX = "__recip_version1.0_#";
    public static final int RECIPIENT_NAME = 12289;
    public static final int DELIVERY_TYPE = 12290;
    public static final int RECIPIENT_EMAIL_ADDRESS = 12291;
    public static final int RECIPIENT_SEARCH = 12299;
    public static final int RECIPIENT_SMTP_ADDRESS = 14846;
    public static final int RECIPIENT_DISPLAY_NAME = 24566;
    public int recipientNumber = -1;
    public ByteChunk recipientSearchChunk;
    public StringChunk recipientNameChunk;
    public StringChunk recipientEmailChunk;
    public StringChunk recipientSMTPChunk;
    public StringChunk deliveryTypeChunk;
    public StringChunk recipientDisplayNameChunk;
    private List allChunks = new ArrayList();

    public RecipientChunks(String name) {
        int splitAt = name.lastIndexOf(35);
        if (splitAt > -1) {
            String number = name.substring(splitAt + 1);
            try {
                this.recipientNumber = Integer.parseInt(number, 16);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid recipient number in name " + name);
            }
        }
    }

    public String getRecipientName() {
        if (this.recipientNameChunk != null) {
            return this.recipientNameChunk.getValue();
        }
        if (this.recipientDisplayNameChunk != null) {
            return this.recipientDisplayNameChunk.getValue();
        }
        return null;
    }

    public String getRecipientEmailAddress() {
        String search;
        String name;
        if (this.recipientSMTPChunk != null) {
            return this.recipientSMTPChunk.getValue();
        }
        if (this.recipientEmailChunk != null) {
            String email = this.recipientEmailChunk.getValue();
            int cne = email.indexOf("/CN=");
            if (cne == -1) {
                return email;
            }
            return email.substring(cne + 4);
        }
        if (this.recipientNameChunk != null && (name = this.recipientNameChunk.getValue()).indexOf(64) > -1) {
            if (name.startsWith("'") && name.endsWith("'")) {
                return name.substring(1, name.length() - 1);
            }
            return name;
        }
        if (this.recipientSearchChunk != null && (search = this.recipientSearchChunk.getAs7bitString()).indexOf("SMTP:") != -1) {
            return search.substring(search.indexOf("SMTP:") + 5);
        }
        return null;
    }

    public Chunk[] getAll() {
        return this.allChunks.toArray(new Chunk[this.allChunks.size()]);
    }

    public Chunk[] getChunks() {
        return this.getAll();
    }

    public void record(Chunk chunk) {
        switch (chunk.getChunkId()) {
            case 12299: {
                this.recipientSearchChunk = (ByteChunk)chunk;
                break;
            }
            case 12289: {
                this.recipientDisplayNameChunk = (StringChunk)chunk;
                break;
            }
            case 24566: {
                this.recipientNameChunk = (StringChunk)chunk;
                break;
            }
            case 12291: {
                this.recipientEmailChunk = (StringChunk)chunk;
                break;
            }
            case 14846: {
                this.recipientSMTPChunk = (StringChunk)chunk;
                break;
            }
            case 12290: {
                this.deliveryTypeChunk = (StringChunk)chunk;
            }
        }
        this.allChunks.add(chunk);
    }

    public static class RecipientChunksSorter
    implements Comparator {
        public int compare(Object ia, Object ib) {
            RecipientChunks a = (RecipientChunks)ia;
            RecipientChunks b = (RecipientChunks)ib;
            if (a.recipientNumber < b.recipientNumber) {
                return -1;
            }
            if (a.recipientNumber > b.recipientNumber) {
                return 1;
            }
            return 0;
        }
    }
}

