/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import java.util.LinkedList;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;

public final class TextStyleListing {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShow ss = new HSLFSlideShow(args[0]);
        Record[] records = ss.getRecords();
        int i = 0;
        while (i < records.length) {
            if (records[i].getRecordType() == 1000L) {
                Record docRecord = records[i];
                Record[] docChildren = docRecord.getChildRecords();
                int j = 0;
                while (j < docChildren.length) {
                    if (docChildren[j] instanceof SlideListWithText) {
                        Record[] slwtChildren = docChildren[j].getChildRecords();
                        int lastTextLen = -1;
                        int k = 0;
                        while (k < slwtChildren.length) {
                            if (slwtChildren[k] instanceof TextCharsAtom) {
                                lastTextLen = ((TextCharsAtom)slwtChildren[k]).getText().length();
                            }
                            if (slwtChildren[k] instanceof TextBytesAtom) {
                                lastTextLen = ((TextBytesAtom)slwtChildren[k]).getText().length();
                            }
                            if (slwtChildren[k] instanceof StyleTextPropAtom) {
                                StyleTextPropAtom stpa = (StyleTextPropAtom)slwtChildren[k];
                                stpa.setParentTextSize(lastTextLen);
                                TextStyleListing.showStyleTextPropAtom(stpa);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void showStyleTextPropAtom(StyleTextPropAtom stpa) {
        System.out.println("\nFound a StyleTextPropAtom");
        LinkedList paragraphStyles = stpa.getParagraphStyles();
        System.out.println("Contains " + paragraphStyles.size() + " paragraph styles:");
        int i = 0;
        while (i < paragraphStyles.size()) {
            TextPropCollection tpc = (TextPropCollection)paragraphStyles.get(i);
            System.out.println(" In paragraph styling " + i + ":");
            System.out.println("  Characters covered is " + tpc.getCharactersCovered());
            TextStyleListing.showTextProps(tpc);
            ++i;
        }
        LinkedList charStyles = stpa.getCharacterStyles();
        System.out.println("Contains " + charStyles.size() + " character styles:");
        int i2 = 0;
        while (i2 < charStyles.size()) {
            TextPropCollection tpc = (TextPropCollection)charStyles.get(i2);
            System.out.println("  In character styling " + i2 + ":");
            System.out.println("    Characters covered is " + tpc.getCharactersCovered());
            TextStyleListing.showTextProps(tpc);
            ++i2;
        }
    }

    public static void showTextProps(TextPropCollection tpc) {
        LinkedList textProps = tpc.getTextPropList();
        System.out.println("    Contains " + textProps.size() + " TextProps");
        int i = 0;
        while (i < textProps.size()) {
            TextProp tp = (TextProp)textProps.get(i);
            System.out.println("      " + i + " - " + tp.getName());
            System.out.println("          = " + tp.getValue());
            System.out.println("          @ " + tp.getMask());
            if (tp instanceof BitMaskTextProp) {
                BitMaskTextProp bmtp = (BitMaskTextProp)tp;
                String[] subPropNames = bmtp.getSubPropNames();
                boolean[] subPropMatches = bmtp.getSubPropMatches();
                int j = 0;
                while (j < subPropNames.length) {
                    System.out.println("            -> " + j + " - " + subPropNames[j]);
                    System.out.println("               " + j + " = " + subPropMatches[j]);
                    ++j;
                }
            }
            ++i;
        }
    }
}

