/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.hwpf.model.CharIndexTranslator;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.SectionDescriptor;
import org.apache.poi.hwpf.model.SectionTable;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.util.LittleEndian;

public final class OldSectionTable
extends SectionTable {
    public OldSectionTable(byte[] documentStream, int offset, int size, int fcMin, TextPieceTable tpt) {
        PlexOfCps sedPlex = new PlexOfCps(documentStream, offset, size, 12);
        CharIsBytes charConv = new CharIsBytes(tpt);
        int length = sedPlex.length();
        int x = 0;
        while (x < length) {
            GenericPropertyNode node = sedPlex.getProperty(x);
            SectionDescriptor sed = new SectionDescriptor(node.getBytes(), 0);
            int fileOffset = sed.getFc();
            int startAt = node.getStart();
            int endAt = node.getEnd();
            if (fileOffset == -1) {
                this._sections.add(new SEPX(sed, startAt, endAt, charConv, new byte[0]));
            } else {
                short sepxSize = LittleEndian.getShort((byte[])documentStream, (int)fileOffset);
                byte[] buf = new byte[sepxSize + 2];
                System.arraycopy(documentStream, fileOffset += 2, buf, 0, buf.length);
                this._sections.add(new SEPX(sed, startAt, endAt, charConv, buf));
            }
            ++x;
        }
    }

    private static class CharIsBytes
    implements CharIndexTranslator {
        private TextPieceTable tpt;

        private CharIsBytes(TextPieceTable tpt) {
            this.tpt = tpt;
        }

        public int getCharIndex(int bytePos, int startCP) {
            return bytePos;
        }

        public int getCharIndex(int bytePos) {
            return bytePos;
        }

        public boolean isIndexInTable(int bytePos) {
            return this.tpt.isIndexInTable(bytePos);
        }

        public int lookIndexBackward(int bytePos) {
            return this.tpt.lookIndexBackward(bytePos);
        }

        public int lookIndexForward(int bytePos) {
            return this.tpt.lookIndexForward(bytePos);
        }
    }
}

