/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.poi.hwpf.model.ListData;
import org.apache.poi.hwpf.model.ListFormatOverride;
import org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import org.apache.poi.hwpf.model.ListLevel;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class ListTables {
    private static final int LIST_DATA_SIZE = 28;
    private static final int LIST_FORMAT_OVERRIDE_SIZE = 16;
    private static POILogger log;
    ListMap _listMap = new ListMap();
    ArrayList _overrideList;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.model.ListTables");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = POILogFactory.getLogger((Class)clazz);
    }

    public ListTables() {
        this._overrideList = new ArrayList();
    }

    /*
     * Unable to fully structure code
     */
    public ListTables(byte[] tableStream, int lstOffset, int lfoOffset) {
        super();
        this._overrideList = new ArrayList<E>();
        length = LittleEndian.getShort((byte[])tableStream, (int)lstOffset);
        levelOffset = (lstOffset += 2) + length * 28;
        x = 0;
        while (x < length) {
            lst = new ListData(tableStream, lstOffset);
            this._listMap.put(new Integer(lst.getLsid()), lst);
            lstOffset += 28;
            num = lst.numLevels();
            y = 0;
            while (y < num) {
                lvl = new ListLevel(tableStream, levelOffset);
                lst.setLevel(y, lvl);
                levelOffset += lvl.getSizeInBytes();
                ++y;
            }
            ++x;
        }
        length = LittleEndian.getInt((byte[])tableStream, (int)lfoOffset);
        lfolvlOffset = (lfoOffset += 4) + 16 * length;
        x = 0;
        while (x < length) {
            lfo = new ListFormatOverride(tableStream, lfoOffset);
            lfoOffset += 16;
            num = lfo.numOverrides();
            y = 0;
            ** GOTO lbl38
            {
                ++lfolvlOffset;
                do {
                    if (tableStream[lfolvlOffset] == -1) continue block3;
                    lfolvl = new ListFormatOverrideLevel(tableStream, lfolvlOffset);
                    lfo.setOverride(y, lfolvl);
                    lfolvlOffset += lfolvl.getSizeInBytes();
                    ++y;
lbl38:
                    // 2 sources

                } while (y < num);
            }
            this._overrideList.add(lfo);
            ++x;
        }
    }

    public int addList(ListData lst, ListFormatOverride override) {
        int lsid = lst.getLsid();
        while (this._listMap.get(new Integer(lsid)) != null) {
            lsid = lst.resetListID();
            override.setLsid(lsid);
        }
        this._listMap.put(new Integer(lsid), lst);
        this._overrideList.add(override);
        return lsid;
    }

    public void writeListDataTo(HWPFOutputStream tableStream) throws IOException {
        int listSize = this._listMap.size();
        ByteArrayOutputStream levelBuf = new ByteArrayOutputStream();
        byte[] shortHolder = new byte[2];
        LittleEndian.putShort((byte[])shortHolder, (short)((short)listSize));
        tableStream.write(shortHolder);
        Iterator iterator = this._listMap.sortedKeys().iterator();
        while (iterator.hasNext()) {
            Integer x = (Integer)iterator.next();
            ListData lst = (ListData)this._listMap.get(x);
            tableStream.write(lst.toByteArray());
            ListLevel[] lvls = lst.getLevels();
            int y = 0;
            while (y < lvls.length) {
                levelBuf.write(lvls[y].toByteArray());
                ++y;
            }
        }
        tableStream.write(levelBuf.toByteArray());
    }

    public void writeListOverridesTo(HWPFOutputStream tableStream) throws IOException {
        ByteArrayOutputStream levelBuf = new ByteArrayOutputStream();
        int size = this._overrideList.size();
        byte[] intHolder = new byte[4];
        LittleEndian.putInt((byte[])intHolder, (int)size);
        tableStream.write(intHolder);
        int x = 0;
        while (x < size) {
            ListFormatOverride lfo = (ListFormatOverride)this._overrideList.get(x);
            tableStream.write(lfo.toByteArray());
            ListFormatOverrideLevel[] lfolvls = lfo.getLevelOverrides();
            int y = 0;
            while (y < lfolvls.length) {
                levelBuf.write(lfolvls[y].toByteArray());
                ++y;
            }
            ++x;
        }
        tableStream.write(levelBuf.toByteArray());
    }

    public ListFormatOverride getOverride(int lfoIndex) {
        return (ListFormatOverride)this._overrideList.get(lfoIndex - 1);
    }

    public int getOverrideIndexFromListID(int lstid) {
        int returnVal = -1;
        int size = this._overrideList.size();
        int x = 0;
        while (x < size) {
            ListFormatOverride next = (ListFormatOverride)this._overrideList.get(x);
            if (next.getLsid() == lstid) {
                returnVal = x + 1;
                break;
            }
            ++x;
        }
        if (returnVal == -1) {
            throw new NoSuchElementException("No list found with the specified ID");
        }
        return returnVal;
    }

    public ListLevel getLevel(int listID, int level) {
        ListData lst = (ListData)this._listMap.get(new Integer(listID));
        if (level < lst.numLevels()) {
            ListLevel lvl = lst.getLevels()[level];
            return lvl;
        }
        log.log(POILogger.WARN, (Object)("Requested level " + level + " which was greater than the maximum defined (" + lst.numLevels() + ")"));
        return null;
    }

    public ListData getListData(int listID) {
        return (ListData)this._listMap.get(new Integer(listID));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ListTables tables = (ListTables)obj;
        if (this._listMap.size() == tables._listMap.size()) {
            Iterator it = this._listMap.keySet().iterator();
            while (it.hasNext()) {
                ListData lst2;
                Integer key = (Integer)it.next();
                ListData lst1 = (ListData)this._listMap.get(key);
                if (lst1.equals(lst2 = (ListData)tables._listMap.get(key))) continue;
                return false;
            }
            int size = this._overrideList.size();
            if (size == tables._overrideList.size()) {
                int x = 0;
                while (x < size) {
                    if (!this._overrideList.get(x).equals(tables._overrideList.get(x))) {
                        return false;
                    }
                    ++x;
                }
                return true;
            }
        }
        return false;
    }

    private static class ListMap
    implements Map {
        private ArrayList keyList = new ArrayList();
        private HashMap parent = new HashMap();

        private ListMap() {
        }

        public void clear() {
            this.keyList.clear();
            this.parent.clear();
        }

        public boolean containsKey(Object key) {
            return this.parent.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.parent.containsValue(value);
        }

        public Object get(Object key) {
            return (ListData)this.parent.get(key);
        }

        public boolean isEmpty() {
            return this.parent.isEmpty();
        }

        public Object put(Object key, Object value) {
            this.keyList.add(key);
            return (ListData)this.parent.put(key, value);
        }

        public void putAll(Map map) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Object remove(Object key) {
            this.keyList.remove(key);
            return (ListData)this.parent.remove(key);
        }

        public int size() {
            return this.parent.size();
        }

        public Set entrySet() {
            throw new IllegalStateException("Use sortedKeys() + get() instead");
        }

        public List sortedKeys() {
            return Collections.unmodifiableList(this.keyList);
        }

        public Set keySet() {
            throw new IllegalStateException("Use sortedKeys() instead");
        }

        public Collection values() {
            ArrayList values = new ArrayList();
            Iterator iterator = this.keyList.iterator();
            while (iterator.hasNext()) {
                Integer key = (Integer)iterator.next();
                values.add(this.parent.get(key));
            }
            return values;
        }
    }
}

