/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwpf.model.BytePropertyNode;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.CharIndexTranslator;
import org.apache.poi.hwpf.model.FormattedDiskPage;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.util.LittleEndian;

public final class CHPFormattedDiskPage
extends FormattedDiskPage {
    private static final int FC_SIZE = 4;
    private ArrayList _chpxList = new ArrayList();
    private ArrayList _overFlow;

    public CHPFormattedDiskPage() {
    }

    public CHPFormattedDiskPage(byte[] documentStream, int offset, int fcMin, TextPieceTable tpt) {
        super(documentStream, offset);
        int x = 0;
        while (x < this._crun) {
            int startAt = this.getStart(x);
            int endAt = this.getEnd(x);
            if (!tpt.isIndexInTable(startAt) && !tpt.isIndexInTable(endAt)) {
                this._chpxList.add(null);
            } else {
                this._chpxList.add(new CHPX(startAt, endAt, (CharIndexTranslator)tpt, this.getGrpprl(x)));
            }
            ++x;
        }
    }

    public CHPX getCHPX(int index) {
        return (CHPX)this._chpxList.get(index);
    }

    public void fill(List filler) {
        this._chpxList.addAll(filler);
    }

    public ArrayList getOverflow() {
        return this._overFlow;
    }

    protected byte[] getGrpprl(int index) {
        int chpxOffset = 2 * LittleEndian.getUnsignedByte((byte[])this._fkp, (int)(this._offset + ((this._crun + 1) * 4 + index)));
        if (chpxOffset == 0) {
            return new byte[0];
        }
        int size = LittleEndian.getUnsignedByte((byte[])this._fkp, (int)(this._offset + chpxOffset));
        byte[] chpx = new byte[size];
        System.arraycopy(this._fkp, this._offset + ++chpxOffset, chpx, 0, size);
        return chpx;
    }

    protected byte[] toByteArray(int fcMin) {
        byte[] buf = new byte[512];
        int size = this._chpxList.size();
        int grpprlOffset = 511;
        int offsetOffset = 0;
        int fcOffset = 0;
        int totalSize = 6;
        int index = 0;
        while (index < size) {
            int grpprlLength = ((CHPX)this._chpxList.get(index)).getGrpprl().length;
            if ((totalSize += 6 + grpprlLength) > 511 + index % 2) {
                totalSize -= 6 + grpprlLength;
                break;
            }
            if ((1 + grpprlLength) % 2 > 0) {
                ++totalSize;
            }
            ++index;
        }
        if (index != size) {
            this._overFlow = new ArrayList();
            this._overFlow.addAll(this._chpxList.subList(index, size));
        }
        buf[511] = (byte)index;
        offsetOffset = 4 * index + 4;
        BytePropertyNode chpx = null;
        int x = 0;
        while (x < index) {
            chpx = (CHPX)this._chpxList.get(x);
            byte[] grpprl = ((CHPX)chpx).getGrpprl();
            LittleEndian.putInt((byte[])buf, (int)fcOffset, (int)(chpx.getStartBytes() + fcMin));
            grpprlOffset -= 1 + grpprl.length;
            grpprlOffset -= grpprlOffset % 2;
            buf[offsetOffset] = (byte)(grpprlOffset / 2);
            buf[grpprlOffset] = (byte)grpprl.length;
            System.arraycopy(grpprl, 0, buf, grpprlOffset + 1, grpprl.length);
            ++offsetOffset;
            fcOffset += 4;
            ++x;
        }
        LittleEndian.putInt((byte[])buf, (int)fcOffset, (int)(chpx.getEndBytes() + fcMin));
        return buf;
    }
}

