/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.NotesAtom;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.SheetContainer;

public final class Notes
extends SheetContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1008L;
    private NotesAtom notesAtom;
    private PPDrawing ppDrawing;
    private ColorSchemeAtom _colorScheme;

    public NotesAtom getNotesAtom() {
        return this.notesAtom;
    }

    public PPDrawing getPPDrawing() {
        return this.ppDrawing;
    }

    protected Notes(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        int i = 0;
        while (i < this._children.length) {
            if (this._children[i] instanceof NotesAtom) {
                this.notesAtom = (NotesAtom)this._children[i];
            }
            if (this._children[i] instanceof PPDrawing) {
                this.ppDrawing = (PPDrawing)this._children[i];
            }
            if (this.ppDrawing != null && this._children[i] instanceof ColorSchemeAtom) {
                this._colorScheme = (ColorSchemeAtom)this._children[i];
            }
            ++i;
        }
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }

    public ColorSchemeAtom getColorScheme() {
        return this._colorScheme;
    }
}

