/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherComplexProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.Picture;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.record.ExControl;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.OEShapeAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public final class ActiveXShape
extends Picture {
    public static final int DEFAULT_ACTIVEX_THUMBNAIL = -1;

    public ActiveXShape(int movieIdx, int pictureIdx) {
        super(pictureIdx, null);
        this.setActiveXIndex(movieIdx);
    }

    protected ActiveXShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    protected EscherContainerRecord createSpContainer(int idx, boolean isChild) {
        this._escherContainer = super.createSpContainer(idx, isChild);
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        spRecord.setFlags(2576);
        this.setShapeType(201);
        this.setEscherProperty((short)267, idx);
        this.setEscherProperty((short)448, 0x8000001);
        this.setEscherProperty((short)511, 524296);
        this.setEscherProperty((short)513, 0x8000002);
        this.setEscherProperty((short)127, -1);
        EscherClientDataRecord cldata = new EscherClientDataRecord();
        cldata.setOptions((short)15);
        this._escherContainer.addChildRecord((EscherRecord)cldata);
        OEShapeAtom oe = new OEShapeAtom();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            oe.writeOut(out);
        }
        catch (Exception e) {
            throw new HSLFException(e);
        }
        cldata.setRemainingData(out.toByteArray());
        return this._escherContainer;
    }

    public void setActiveXIndex(int idx) {
        EscherContainerRecord spContainer = this.getSpContainer();
        Iterator it = spContainer.getChildIterator();
        while (it.hasNext()) {
            EscherRecord obj = (EscherRecord)it.next();
            if (obj.getRecordId() != -4079) continue;
            EscherClientDataRecord clientRecord = (EscherClientDataRecord)obj;
            byte[] recdata = clientRecord.getRemainingData();
            LittleEndian.putInt((byte[])recdata, (int)8, (int)idx);
        }
    }

    public int getControlIndex() {
        int idx = -1;
        OEShapeAtom oe = (OEShapeAtom)this.getClientDataRecord(RecordTypes.OEShapeAtom.typeID);
        if (oe != null) {
            idx = oe.getOptions();
        }
        return idx;
    }

    public void setProperty(String key, String value) {
    }

    public ExControl getExControl() {
        int idx = this.getControlIndex();
        ExControl ctrl = null;
        Document doc = this.getSheet().getSlideShow().getDocumentRecord();
        ExObjList lst = (ExObjList)doc.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst != null) {
            Record[] ch = lst.getChildRecords();
            int i = 0;
            while (i < ch.length) {
                ExControl c;
                if (ch[i] instanceof ExControl && (c = (ExControl)ch[i]).getExOleObjAtom().getObjID() == idx) {
                    ctrl = c;
                    break;
                }
                ++i;
            }
        }
        return ctrl;
    }

    protected void afterInsert(Sheet sheet) {
        ExControl ctrl = this.getExControl();
        ctrl.getExControlAtom().setSlideId(sheet._getSheetNumber());
        try {
            String name = String.valueOf(ctrl.getProgId()) + "-" + this.getControlIndex();
            byte[] data = (String.valueOf(name) + '\u0000').getBytes("UTF-16LE");
            EscherComplexProperty prop = new EscherComplexProperty(896, false, data);
            EscherOptRecord opt = (EscherOptRecord)ActiveXShape.getEscherChild(this._escherContainer, -4085);
            opt.addEscherProperty((EscherProperty)prop);
        }
        catch (UnsupportedEncodingException e) {
            throw new HSLFException(e);
        }
    }
}

