/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpbf.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class HPBFDumper {
    private POIFSFileSystem fs;

    public HPBFDumper(POIFSFileSystem fs) {
        this.fs = fs;
    }

    public HPBFDumper(InputStream inp) throws IOException {
        this(new POIFSFileSystem(inp));
    }

    private static byte[] getData(DirectoryNode dir, String name) throws IOException {
        DocumentEntry docProps = (DocumentEntry)dir.getEntry(name);
        byte[] d = new byte[docProps.getSize()];
        dir.createDocumentInputStream(name).read(d);
        return d;
    }

    private String dumpBytes(byte[] data, int offset, int len) {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < len) {
            String bs;
            int j = i + offset;
            int b = data[j];
            if (b < 0) {
                b += 256;
            }
            if ((bs = Integer.toHexString(b)).length() == 1) {
                ret.append('0');
            }
            ret.append(bs);
            ret.append(' ');
            ++i;
        }
        return ret.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  HPBFDumper <filename>");
            System.exit(1);
        }
        HPBFDumper dump = new HPBFDumper(new FileInputStream(args[0]));
        System.out.println("Dumping " + args[0]);
        dump.dumpContents();
        dump.dumpEnvelope();
        dump.dumpEscher();
        dump.dump001CompObj(dump.fs.getRoot());
        dump.dumpQuill();
    }

    public void dumpEscher() throws IOException {
        DirectoryNode escherDir = (DirectoryNode)this.fs.getRoot().getEntry("Escher");
        this.dumpEscherStm(escherDir);
        this.dumpEscherDelayStm(escherDir);
    }

    private void dumpEscherStream(byte[] data) {
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        int left = data.length;
        while (left > 0) {
            EscherRecord er = erf.createRecord(data, 0);
            er.fillFields(data, 0, (EscherRecordFactory)erf);
            left -= er.getRecordSize();
            System.out.println(er.toString());
        }
    }

    protected void dumpEscherStm(DirectoryNode escherDir) throws IOException {
        byte[] data = HPBFDumper.getData(escherDir, "EscherStm");
        System.out.println("");
        System.out.println("EscherStm - " + data.length + " bytes long:");
        if (data.length > 0) {
            this.dumpEscherStream(data);
        }
    }

    protected void dumpEscherDelayStm(DirectoryNode escherDir) throws IOException {
        byte[] data = HPBFDumper.getData(escherDir, "EscherDelayStm");
        System.out.println("");
        System.out.println("EscherDelayStm - " + data.length + " bytes long:");
        if (data.length > 0) {
            this.dumpEscherStream(data);
        }
    }

    public void dumpEnvelope() throws IOException {
        byte[] data = HPBFDumper.getData(this.fs.getRoot(), "Envelope");
        System.out.println("");
        System.out.println("Envelope - " + data.length + " bytes long:");
    }

    public void dumpContents() throws IOException {
        byte[] data = HPBFDumper.getData(this.fs.getRoot(), "Contents");
        System.out.println("");
        System.out.println("Contents - " + data.length + " bytes long:");
    }

    public void dumpCONTENTSraw(DirectoryNode dir) throws IOException {
        byte[] data = HPBFDumper.getData(dir, "CONTENTS");
        System.out.println("");
        System.out.println("CONTENTS - " + data.length + " bytes long:");
        System.out.println(String.valueOf(new String(data, 0, 8)) + this.dumpBytes(data, 8, 24));
        int pos = 32;
        boolean sixNotEight = true;
        while (pos < 512) {
            if (sixNotEight) {
                System.out.println(this.dumpBytes(data, pos, 2));
                pos += 2;
            }
            String text = new String(data, pos, 4);
            int blen = 8;
            if (sixNotEight) {
                blen = 6;
            }
            System.out.println(String.valueOf(text) + " " + this.dumpBytes(data, pos + 4, blen));
            pos += 4 + blen;
            boolean bl = sixNotEight = !sixNotEight;
        }
        int textStop = -1;
        int i = 512;
        while (i < data.length - 2 && textStop == -1) {
            if (data[i] == 0 && data[i + 1] == 0 && data[i + 2] == 0) {
                textStop = i;
            }
            ++i;
        }
        if (textStop > 0) {
            int len = (textStop - 512) / 2;
            System.out.println("");
            System.out.println(StringUtil.getFromUnicodeLE((byte[])data, (int)512, (int)len));
        }
    }

    public void dumpCONTENTSguessed(DirectoryNode dir) throws IOException {
        byte[] data = HPBFDumper.getData(dir, "CONTENTS");
        System.out.println("");
        System.out.println("CONTENTS - " + data.length + " bytes long:");
        String[] startType = new String[20];
        String[] endType = new String[20];
        int[] optA = new int[20];
        int[] optB = new int[20];
        int[] optC = new int[20];
        int[] from = new int[20];
        int[] len = new int[20];
        int i = 0;
        while (i < 20) {
            int offset = 32 + i * 24;
            if (data[offset] == 24 && data[offset + 1] == 0) {
                startType[i] = new String(data, offset + 2, 4);
                optA[i] = LittleEndian.getUShort((byte[])data, (int)(offset + 6));
                optB[i] = LittleEndian.getUShort((byte[])data, (int)(offset + 8));
                optC[i] = LittleEndian.getUShort((byte[])data, (int)(offset + 10));
                endType[i] = new String(data, offset + 12, 4);
                from[i] = (int)LittleEndian.getUInt((byte[])data, (int)(offset + 16));
                len[i] = (int)LittleEndian.getUInt((byte[])data, (int)(offset + 20));
            }
            ++i;
        }
        String text = StringUtil.getFromUnicodeLE((byte[])data, (int)from[0], (int)(len[0] / 2));
        int i2 = 0;
        while (i2 < 20) {
            String num = Integer.toString(i2);
            if (i2 < 10) {
                num = "0" + i2;
            }
            System.out.print(String.valueOf(num) + " ");
            if (startType[i2] == null) {
                System.out.println("(not present)");
            } else {
                System.out.println("\t" + startType[i2] + " " + optA[i2] + " " + optB[i2] + " " + optC[i2]);
                System.out.println("\t" + endType[i2] + " " + "from: " + Integer.toHexString(from[i2]) + " (" + from[i2] + ")" + ", len: " + Integer.toHexString(len[i2]) + " (" + len[i2] + ")");
            }
            ++i2;
        }
        System.out.println("");
        System.out.println("TEXT:");
        System.out.println(text);
        System.out.println("");
        i2 = 0;
        while (i2 < 20) {
            if (startType[i2] != null) {
                int start = from[i2];
                System.out.println(String.valueOf(startType[i2]) + " -> " + endType[i2] + " @ " + Integer.toHexString(start) + " (" + start + ")");
                System.out.println("\t" + this.dumpBytes(data, start, 4));
                System.out.println("\t" + this.dumpBytes(data, start + 4, 4));
                System.out.println("\t" + this.dumpBytes(data, start + 8, 4));
                System.out.println("\t(etc)");
            }
            ++i2;
        }
    }

    protected void dump001CompObj(DirectoryNode dir) {
    }

    public void dumpQuill() throws IOException {
        DirectoryNode quillDir = (DirectoryNode)this.fs.getRoot().getEntry("Quill");
        DirectoryNode quillSubDir = (DirectoryNode)quillDir.getEntry("QuillSub");
        this.dump001CompObj(quillSubDir);
        this.dumpCONTENTSraw(quillSubDir);
        this.dumpCONTENTSguessed(quillSubDir);
    }
}

