/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.xwpf.usermodel;

import java.lang.reflect.Constructor;

import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLFactory;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/**
 * @author Yegor Kozlov
 */
public final class XWPFFactory extends POIXMLFactory  {

    private static POILogger logger = POILogFactory.getLogger(XWPFFactory.class);

    private XWPFFactory(){

    }

    private static final XWPFFactory inst = new XWPFFactory();

    public static XWPFFactory getInstance(){
        return inst;
    }

    public POIXMLDocumentPart createDocumentPart(PackageRelationship rel, PackagePart part){
        POIXMLRelation descriptor = XWPFRelation.getInstance(rel.getRelationshipType());
        if(descriptor == null || descriptor.getRelationClass() == null){
            logger.log(POILogger.DEBUG, "using default POIXMLDocumentPart for " + rel.getRelationshipType());
            return new POIXMLDocumentPart(part, rel);
        }

        try {
            Class cls = descriptor.getRelationClass();
            Constructor constructor = cls.getDeclaredConstructor(new Class[]{ PackagePart.class, PackageRelationship.class });
            return (POIXMLDocumentPart) constructor.newInstance(new Object[]{ part, rel });
        } catch (Exception e){
            throw new POIXMLException(e);
        }
    }

    public POIXMLDocumentPart newDocumentPart(POIXMLRelation descriptor){
        try {
            Class cls = descriptor.getRelationClass();
            Constructor constructor = cls.getDeclaredConstructor(null);
            return (POIXMLDocumentPart) constructor.newInstance(null);
        } catch (Exception e){
            throw new POIXMLException(e);
        }
    }

}
