/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public abstract class XWPFHeaderFooter
extends POIXMLDocumentPart
implements IBody {
    protected CTHdrFtr headerFooter;
    protected List paragraphs;
    protected List tables;
    protected List pictures;
    protected XWPFDocument document;
    protected List bodyElements;

    protected XWPFHeaderFooter(CTHdrFtr hdrFtr) {
        this.headerFooter = hdrFtr;
        this.readHdrFtr();
    }

    protected XWPFHeaderFooter() {
        this(CTHdrFtr.Factory.newInstance());
    }

    public XWPFHeaderFooter(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.document = (XWPFDocument)this.getParent();
        this.onDocumentRead();
    }

    public CTHdrFtr _getHdrFtr() {
        return this.headerFooter;
    }

    public List getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public List getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    public List getTables() throws ArrayIndexOutOfBoundsException {
        return Collections.unmodifiableList(this.tables);
    }

    public String getText() {
        StringBuffer t = new StringBuffer();
        int i = 0;
        while (i < this.paragraphs.size()) {
            String text;
            if (!((XWPFParagraph)this.paragraphs.get(i)).isEmpty() && (text = ((XWPFParagraph)this.paragraphs.get(i)).getText()) != null && text.length() > 0) {
                t.append(text);
                t.append('\n');
            }
            ++i;
        }
        List tables = this.getTables();
        int i2 = 0;
        while (i2 < tables.size()) {
            String text = ((XWPFTable)tables.get(i2)).getText();
            if (text != null && text.length() > 0) {
                t.append(text);
                t.append('\n');
            }
            ++i2;
        }
        return t.toString();
    }

    public void setHeaderFooter(CTHdrFtr headerFooter) {
        this.headerFooter = headerFooter;
        this.readHdrFtr();
    }

    public XWPFTable getTable(CTTbl ctTable) {
        Iterator iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            XWPFTable table = (XWPFTable)iterator.next();
            if (table == null) {
                return null;
            }
            if (!table.getCTTbl().equals(ctTable)) continue;
            return table;
        }
        return null;
    }

    public XWPFParagraph getParagraph(CTP p) {
        Iterator iterator = this.paragraphs.iterator();
        while (iterator.hasNext()) {
            XWPFParagraph paragraph = (XWPFParagraph)iterator.next();
            if (!paragraph.getCTP().equals(p)) continue;
            return paragraph;
        }
        return null;
    }

    public XWPFParagraph getParagraphArray(int pos) {
        return (XWPFParagraph)this.paragraphs.get(pos);
    }

    public List getListParagraph() {
        return this.paragraphs;
    }

    public List getAllPictures() {
        if (this.pictures == null) {
            this.pictures = new ArrayList();
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                POIXMLDocumentPart poixmlDocumentPart = (POIXMLDocumentPart)iterator.next();
                if (!(poixmlDocumentPart instanceof XWPFPictureData)) continue;
                this.pictures.add((XWPFPictureData)poixmlDocumentPart);
            }
        }
        return this.pictures;
    }

    public List getAllPackagePictures() {
        ArrayList pkgpictures = new ArrayList();
        pkgpictures.addAll(this.getAllPictures());
        Iterator iterator = this.getRelations().iterator();
        while (iterator.hasNext()) {
            POIXMLDocumentPart poixmlDocumentPart = (POIXMLDocumentPart)iterator.next();
            if (!(poixmlDocumentPart instanceof XWPFHeaderFooter)) continue;
            pkgpictures.addAll(((XWPFHeaderFooter)poixmlDocumentPart).getAllPictures());
        }
        return pkgpictures;
    }

    public int addPicture(InputStream is, int format) throws IOException {
        int imageNumber = this.getNextPicNameNumber(format);
        XWPFPictureData img = (XWPFPictureData)this.createRelationship(XWPFPictureData.RELATIONS[format], XWPFFactory.getInstance(), imageNumber, true);
        OutputStream out = img.getPackagePart().getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)out);
        out.close();
        this.pictures.add(img);
        return this.getAllPictures().size() - 1;
    }

    public int addPicture(byte[] pictureData, int format) {
        int imageNumber = this.getNextPicNameNumber(format);
        XWPFPictureData img = (XWPFPictureData)this.createRelationship(XWPFPictureData.RELATIONS[format], XWPFFactory.getInstance(), imageNumber, false);
        try {
            OutputStream out = img.getPackagePart().getOutputStream();
            out.write(pictureData);
            out.close();
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
        this.pictures.add(img);
        return this.getAllPictures().size() - 1;
    }

    public int getNextPicNameNumber(int format) {
        int img = this.getAllPackagePictures().size() + 1;
        String proposal = XWPFPictureData.RELATIONS[format].getFileName(img);
        try {
            PackagePartName createPartName = PackagingURIHelper.createPartName(proposal);
            while (this.getPackagePart().getPackage().getPart(createPartName) != null) {
                proposal = XWPFPictureData.RELATIONS[format].getFileName(++img);
                createPartName = PackagingURIHelper.createPartName(proposal);
            }
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        return img;
    }

    public XWPFPictureData getPictureDataByID(String blipID) {
        Iterator iterator = this.getRelations().iterator();
        while (iterator.hasNext()) {
            POIXMLDocumentPart part = (POIXMLDocumentPart)iterator.next();
            if (part.getPackageRelationship() == null || part.getPackageRelationship().getId() == null || !part.getPackageRelationship().getId().equals(blipID)) continue;
            return (XWPFPictureData)part;
        }
        return null;
    }

    public PackageRelationship addPictureReference(byte[] pictureData, int format) {
        int imageNumber = this.getNextPicNameNumber(format);
        XWPFPictureData img = (XWPFPictureData)this.createRelationship(XWPFPictureData.RELATIONS[format], XWPFFactory.getInstance(), imageNumber, false);
        PackageRelationship rel = null;
        try {
            OutputStream out = img.getPackagePart().getOutputStream();
            out.write(pictureData);
            out.close();
            rel = img.getPackageRelationship();
            this.pictures.add(img);
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
        return rel;
    }

    public PackageRelationship addPictureReference(InputStream is, int format) {
        PackageRelationship rel = null;
        try {
            int imageNumber = this.getNextPicNameNumber(format);
            XWPFPictureData img = (XWPFPictureData)this.createRelationship(XWPFPictureData.RELATIONS[format], XWPFFactory.getInstance(), imageNumber, false);
            OutputStream out = img.getPackagePart().getOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)out);
            out.close();
            rel = img.getPackageRelationship();
            this.pictures.add(img);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rel;
    }

    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (this.isCursorInHdrF(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p, this);
            XmlObject o = null;
            while (!(o instanceof CTP) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTP) || (CTP)o == p) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
                this.paragraphs.add(pos, newP);
            }
            int i = 0;
            cursor.toCursor(p.newCursor());
            while (cursor.toPrevSibling()) {
                o = cursor.getObject();
                if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                ++i;
            }
            this.bodyElements.add(i, newP);
            cursor.toCursor(p.newCursor());
            cursor.toEndToken();
            return newP;
        }
        return null;
    }

    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInHdrF(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, this);
            cursor.removeXmlContents();
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            cursor = t.newCursor();
            while (cursor.toPrevSibling()) {
                o = cursor.getObject();
                if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                ++i;
            }
            this.bodyElements.add(i, newT);
            cursor = t.newCursor();
            cursor.toEndToken();
            return newT;
        }
        return null;
    }

    private boolean isCursorInHdrF(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        return verify.getObject() == this.headerFooter;
    }

    public POIXMLDocumentPart getOwner() {
        return this;
    }

    public XWPFTable getTableArray(int pos) {
        if (pos > 0 && pos < this.tables.size()) {
            return (XWPFTable)this.tables.get(pos);
        }
        return null;
    }

    public void insertTable(int pos, XWPFTable table) {
        this.bodyElements.add(pos, table);
        int i = 0;
        while (i < this.headerFooter.getTblArray().length) {
            CTTbl tbl = this.headerFooter.getTblArray(i);
            if (tbl == table.getCTTbl()) break;
            ++i;
        }
        this.tables.add(i, table);
    }

    public void readHdrFtr() {
        this.bodyElements = new ArrayList();
        this.paragraphs = new ArrayList();
        this.tables = new ArrayList();
        XmlCursor cursor = this.headerFooter.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o = cursor.getObject();
            if (o instanceof CTP) {
                XWPFParagraph p = new XWPFParagraph((CTP)o, this);
                this.paragraphs.add(p);
                this.bodyElements.add(p);
            }
            if (!(o instanceof CTTbl)) continue;
            XWPFTable t = new XWPFTable((CTTbl)o, this);
            this.tables.add(t);
            this.bodyElements.add(t);
        }
        this.getAllPictures();
    }

    public XWPFTableCell getTableCell(CTTc cell) {
        XmlCursor cursor = cell.newCursor();
        cursor.toParent();
        XmlObject o = cursor.getObject();
        if (!(o instanceof CTRow)) {
            return null;
        }
        CTRow row = (CTRow)o;
        cursor.toParent();
        o = cursor.getObject();
        if (!(o instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tableRow = table.getRow(row);
        if (row == null) {
            // empty if block
        }
        return tableRow.getTableCell(cell);
    }
}

