/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.model;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.poi.xwpf.model.XWPFParagraphDecorator;
import org.apache.poi.xwpf.usermodel.XWPFComment;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;

public class XWPFCommentsDecorator
extends XWPFParagraphDecorator {
    private StringBuffer commentText = new StringBuffer();

    public XWPFCommentsDecorator(XWPFParagraphDecorator nextDecorator) {
        this(nextDecorator.paragraph, nextDecorator);
    }

    public XWPFCommentsDecorator(XWPFParagraph paragraph, XWPFParagraphDecorator nextDecorator) {
        super(paragraph, nextDecorator);
        Iterator<CTMarkupRange> iterator = Arrays.asList(paragraph.getCTP().getCommentRangeStartArray()).iterator();
        while (iterator.hasNext()) {
            CTMarkupRange anchor = iterator.next();
            XWPFComment comment = paragraph.getDocument().getCommentByID(anchor.getId().toString());
            if (comment == null) continue;
            this.commentText.append("\tComment by " + comment.getAuthor() + ": " + comment.getText());
        }
    }

    public String getCommentText() {
        return this.commentText.toString();
    }

    public String getText() {
        return String.valueOf(super.getText()) + this.commentText;
    }
}

