/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellType;

public final class XSSFCell
implements Cell {
    private static final String FALSE_AS_STRING = "0";
    private static final String TRUE_AS_STRING = "1";
    private final CTCell _cell;
    private final XSSFRow _row;
    private int _cellNum;
    private SharedStringsTable _sharedStringSource;
    private StylesTable _stylesSource;

    protected XSSFCell(XSSFRow row, CTCell cell) {
        this._cell = cell;
        this._row = row;
        if (cell.getR() != null) {
            this._cellNum = new CellReference(cell.getR()).getCol();
        }
        this._sharedStringSource = ((XSSFWorkbook)row.getSheet().getWorkbook()).getSharedStringSource();
        this._stylesSource = ((XSSFWorkbook)row.getSheet().getWorkbook()).getStylesSource();
    }

    protected SharedStringsTable getSharedStringSource() {
        return this._sharedStringSource;
    }

    protected StylesTable getStylesSource() {
        return this._stylesSource;
    }

    public Sheet getSheet() {
        return this.getRow().getSheet();
    }

    public Row getRow() {
        return this._row;
    }

    public boolean getBooleanCellValue() {
        int cellType = this.getCellType();
        switch (cellType) {
            case 3: {
                return false;
            }
            case 4: {
                return this._cell.isSetV() && TRUE_AS_STRING.equals(this._cell.getV());
            }
            case 2: {
                return this._cell.isSetV() && TRUE_AS_STRING.equals(this._cell.getV());
            }
        }
        throw XSSFCell.typeMismatch(4, cellType, false);
    }

    public void setCellValue(boolean value) {
        this._cell.setT(STCellType.B);
        this._cell.setV(value ? TRUE_AS_STRING : FALSE_AS_STRING);
    }

    public double getNumericCellValue() {
        int cellType = this.getCellType();
        switch (cellType) {
            case 3: {
                return 0.0;
            }
            case 0: 
            case 2: {
                if (this._cell.isSetV()) {
                    try {
                        return Double.parseDouble(this._cell.getV());
                    }
                    catch (NumberFormatException e) {
                        throw XSSFCell.typeMismatch(0, 1, false);
                    }
                }
                return 0.0;
            }
        }
        throw XSSFCell.typeMismatch(0, cellType, false);
    }

    public void setCellValue(double value) {
        if (Double.isInfinite(value)) {
            this._cell.setT(STCellType.E);
            this._cell.setV(FormulaError.DIV0.getString());
        } else if (Double.isNaN(value)) {
            this._cell.setT(STCellType.E);
            this._cell.setV(FormulaError.NUM.getString());
        } else {
            this._cell.setT(STCellType.N);
            this._cell.setV(String.valueOf(value));
        }
    }

    public String getStringCellValue() {
        XSSFRichTextString str = (XSSFRichTextString)this.getRichStringCellValue();
        return str == null ? null : str.getString();
    }

    public RichTextString getRichStringCellValue() {
        XSSFRichTextString rt;
        int cellType = this.getCellType();
        switch (cellType) {
            case 3: {
                rt = new XSSFRichTextString("");
                break;
            }
            case 1: {
                if (this._cell.getT() == STCellType.INLINE_STR) {
                    if (this._cell.isSetIs()) {
                        rt = new XSSFRichTextString(this._cell.getIs());
                        break;
                    }
                    if (this._cell.isSetV()) {
                        rt = new XSSFRichTextString(this._cell.getV());
                        break;
                    }
                    rt = new XSSFRichTextString("");
                    break;
                }
                if (this._cell.getT() == STCellType.STR) {
                    rt = new XSSFRichTextString(this._cell.isSetV() ? this._cell.getV() : "");
                    break;
                }
                if (this._cell.isSetV()) {
                    int idx = Integer.parseInt(this._cell.getV());
                    rt = new XSSFRichTextString(this._sharedStringSource.getEntryAt(idx));
                    break;
                }
                rt = new XSSFRichTextString("");
                break;
            }
            case 2: {
                XSSFCell.checkFormulaCachedValueType(1, this.getBaseCellType(false));
                rt = new XSSFRichTextString(this._cell.isSetV() ? this._cell.getV() : "");
                break;
            }
            default: {
                throw XSSFCell.typeMismatch(1, cellType, false);
            }
        }
        rt.setStylesTableReference(this._stylesSource);
        return rt;
    }

    private static void checkFormulaCachedValueType(int expectedTypeCode, int cachedValueType) {
        if (cachedValueType != expectedTypeCode) {
            throw XSSFCell.typeMismatch(expectedTypeCode, cachedValueType, true);
        }
    }

    public void setCellValue(String str) {
        this.setCellValue(str == null ? null : new XSSFRichTextString(str));
    }

    public void setCellValue(RichTextString str) {
        if (str == null || str.getString() == null) {
            this.setBlank();
            return;
        }
        int cellType = this.getCellType();
        switch (cellType) {
            case 2: {
                this._cell.setV(str.getString());
                this._cell.setT(STCellType.STR);
                break;
            }
            default: {
                if (this._cell.getT() == STCellType.INLINE_STR) {
                    this._cell.setV(str.getString());
                    break;
                }
                this._cell.setT(STCellType.S);
                XSSFRichTextString rt = (XSSFRichTextString)str;
                rt.setStylesTableReference(this._stylesSource);
                int sRef = this._sharedStringSource.addEntry(rt.getCTRst());
                this._cell.setV(Integer.toString(sRef));
            }
        }
    }

    public String getCellFormula() {
        int cellType = this.getCellType();
        if (cellType != 2) {
            throw XSSFCell.typeMismatch(2, cellType, false);
        }
        CTCellFormula f = this._cell.getF();
        if (this.isPartOfArrayFormulaGroup() && f == null) {
            XSSFCell cell = ((XSSFSheet)this.getSheet()).getFirstCellInArrayFormula(this);
            return cell.getCellFormula();
        }
        if (f.getT() == STCellFormulaType.SHARED) {
            return this.convertSharedFormula((int)f.getSi());
        }
        return f.getStringValue();
    }

    private String convertSharedFormula(int si) {
        XSSFSheet sheet = (XSSFSheet)this.getSheet();
        CTCellFormula f = sheet.getSharedFormula(si);
        if (f == null) {
            throw new IllegalStateException("Master cell of a shared formula with sid=" + si + " was not found");
        }
        String sharedFormula = f.getStringValue();
        String sharedFormulaRange = f.getRef();
        CellRangeAddress ref = CellRangeAddress.valueOf((String)sharedFormulaRange);
        int sheetIndex = sheet.getWorkbook().getSheetIndex((Sheet)sheet);
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create((XSSFWorkbook)sheet.getWorkbook());
        Ptg[] ptgs = FormulaParser.parse((String)sharedFormula, (FormulaParsingWorkbook)fpb, (int)0, (int)sheetIndex);
        Ptg[] fmla = SharedFormulaRecord.convertSharedFormulas((Ptg[])ptgs, (int)(this.getRowIndex() - ref.getFirstRow()), (int)(this.getColumnIndex() - ref.getFirstColumn()));
        return FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])fmla);
    }

    public void setCellFormula(String formula) {
        if (this.isPartOfArrayFormulaGroup()) {
            this.notifyArrayFormulaChanging();
        }
        this.setFormula(formula, 0);
    }

    void setCellArrayFormula(String formula, CellRangeAddress range) {
        this.setFormula(formula, 2);
        CTCellFormula cellFormula = this._cell.getF();
        cellFormula.setT(STCellFormulaType.ARRAY);
        cellFormula.setRef(range.formatAsString());
    }

    private void setFormula(String formula, int formulaType) {
        XSSFWorkbook wb = (XSSFWorkbook)this._row.getSheet().getWorkbook();
        if (formula == null) {
            wb.onDeleteFormula(this);
            if (this._cell.isSetF()) {
                this._cell.unsetF();
            }
            return;
        }
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        FormulaParser.parse((String)formula, (FormulaParsingWorkbook)fpb, (int)formulaType, (int)wb.getSheetIndex(this.getSheet()));
        CTCellFormula f = CTCellFormula.Factory.newInstance();
        f.setStringValue(formula);
        this._cell.setF(f);
        if (this._cell.isSetV()) {
            this._cell.unsetV();
        }
    }

    public int getColumnIndex() {
        return this._cellNum;
    }

    public int getRowIndex() {
        return this._row.getRowNum();
    }

    public String getReference() {
        return this._cell.getR();
    }

    public CellStyle getCellStyle() {
        XSSFCellStyle style = null;
        if (this._stylesSource.getNumCellStyles() > 0) {
            long idx = this._cell.isSetS() ? this._cell.getS() : 0L;
            style = this._stylesSource.getStyleAt((int)idx);
        }
        return style;
    }

    public void setCellStyle(CellStyle style) {
        if (style == null) {
            if (this._cell.isSetS()) {
                this._cell.unsetS();
            }
        } else {
            XSSFCellStyle xStyle = (XSSFCellStyle)style;
            xStyle.verifyBelongsToStylesSource(this._stylesSource);
            long idx = this._stylesSource.putStyle(xStyle);
            this._cell.setS(idx);
        }
    }

    public int getCellType() {
        if (this._cell.getF() != null || ((XSSFSheet)this.getSheet()).isCellInArrayFormulaContext(this)) {
            return 2;
        }
        return this.getBaseCellType(true);
    }

    public int getCachedFormulaResultType() {
        if (this._cell.getF() == null) {
            throw new IllegalStateException("Only formula cells have cached results");
        }
        return this.getBaseCellType(false);
    }

    private int getBaseCellType(boolean blankCells) {
        switch (this._cell.getT().intValue()) {
            case 1: {
                return 4;
            }
            case 2: {
                if (!this._cell.isSetV() && blankCells) {
                    return 3;
                }
                return 0;
            }
            case 3: {
                return 5;
            }
            case 4: 
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalStateException("Illegal cell type: " + this._cell.getT());
    }

    public Date getDateCellValue() {
        int cellType = this.getCellType();
        if (cellType == 3) {
            return null;
        }
        double value = this.getNumericCellValue();
        boolean date1904 = ((XSSFWorkbook)this.getSheet().getWorkbook()).isDate1904();
        return DateUtil.getJavaDate((double)value, (boolean)date1904);
    }

    public void setCellValue(Date value) {
        boolean date1904 = ((XSSFWorkbook)this.getSheet().getWorkbook()).isDate1904();
        this.setCellValue(DateUtil.getExcelDate((Date)value, (boolean)date1904));
    }

    public void setCellValue(Calendar value) {
        boolean date1904 = ((XSSFWorkbook)this.getSheet().getWorkbook()).isDate1904();
        this.setCellValue(DateUtil.getExcelDate((Calendar)value, (boolean)date1904));
    }

    public String getErrorCellString() {
        int cellType = this.getBaseCellType(true);
        if (cellType != 5) {
            throw XSSFCell.typeMismatch(5, cellType, false);
        }
        return this._cell.getV();
    }

    public byte getErrorCellValue() {
        String code = this.getErrorCellString();
        if (code == null) {
            return 0;
        }
        return FormulaError.forString((String)code).getCode();
    }

    public void setCellErrorValue(byte errorCode) {
        FormulaError error = FormulaError.forInt((byte)errorCode);
        this.setCellErrorValue(error);
    }

    public void setCellErrorValue(FormulaError error) {
        this._cell.setT(STCellType.E);
        this._cell.setV(error.getString());
    }

    public void setAsActiveCell() {
        ((XSSFSheet)this.getSheet()).setActiveCell(this._cell.getR());
    }

    private void setBlank() {
        CTCell blank = CTCell.Factory.newInstance();
        blank.setR(this._cell.getR());
        if (this._cell.isSetS()) {
            blank.setS(this._cell.getS());
        }
        this._cell.set((XmlObject)blank);
    }

    protected void setCellNum(int num) {
        XSSFCell.checkBounds(num);
        this._cellNum = num;
        String ref = new CellReference(this.getRowIndex(), this.getColumnIndex()).formatAsString();
        this._cell.setR(ref);
    }

    public void setCellType(int cellType) {
        int prevType = this.getCellType();
        if (this.isPartOfArrayFormulaGroup()) {
            this.notifyArrayFormulaChanging();
        }
        if (prevType == 2 && cellType != 2) {
            ((XSSFWorkbook)this.getSheet().getWorkbook()).onDeleteFormula(this);
        }
        switch (cellType) {
            case 3: {
                this.setBlank();
                break;
            }
            case 4: {
                String newVal = this.convertCellValueToBoolean() ? TRUE_AS_STRING : FALSE_AS_STRING;
                this._cell.setT(STCellType.B);
                this._cell.setV(newVal);
                break;
            }
            case 0: {
                this._cell.setT(STCellType.N);
                break;
            }
            case 5: {
                this._cell.setT(STCellType.E);
                break;
            }
            case 1: {
                if (prevType != 1) {
                    String str = this.convertCellValueToString();
                    XSSFRichTextString rt = new XSSFRichTextString(str);
                    rt.setStylesTableReference(this._stylesSource);
                    int sRef = this._sharedStringSource.addEntry(rt.getCTRst());
                    this._cell.setV(Integer.toString(sRef));
                }
                this._cell.setT(STCellType.S);
                break;
            }
            case 2: {
                if (this._cell.isSetF()) break;
                CTCellFormula f = CTCellFormula.Factory.newInstance();
                f.setStringValue(FALSE_AS_STRING);
                this._cell.setF(f);
                if (!this._cell.isSetT()) break;
                this._cell.unsetT();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal cell type: " + cellType);
            }
        }
        if (cellType != 2 && this._cell.isSetF()) {
            this._cell.unsetF();
        }
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText((int)this.getErrorCellValue());
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)this)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
                    return sdf.format(this.getDateCellValue());
                }
                return String.valueOf(this.getNumericCellValue());
            }
            case 1: {
                return this.getRichStringCellValue().toString();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    public String getRawValue() {
        return this._cell.getV();
    }

    private static String getCellTypeName(int cellTypeCode) {
        switch (cellTypeCode) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + cellTypeCode + ")#";
    }

    private static RuntimeException typeMismatch(int expectedTypeCode, int actualTypeCode, boolean isFormulaCell) {
        String msg = "Cannot get a " + XSSFCell.getCellTypeName(expectedTypeCode) + " value from a " + XSSFCell.getCellTypeName(actualTypeCode) + " " + (isFormulaCell ? "formula " : "") + "cell";
        return new IllegalStateException(msg);
    }

    private static void checkBounds(int cellIndex) {
        SpreadsheetVersion v = SpreadsheetVersion.EXCEL2007;
        int maxcol = SpreadsheetVersion.EXCEL2007.getLastColumnIndex();
        if (cellIndex < 0 || cellIndex > maxcol) {
            throw new IllegalArgumentException("Invalid column index (" + cellIndex + ").  Allowable column range for " + "EXCEL2007" + " is (0.." + maxcol + ") or ('A'..'" + v.getLastColumnName() + "')");
        }
    }

    public Comment getCellComment() {
        return this.getSheet().getCellComment(this._row.getRowNum(), this.getColumnIndex());
    }

    public void setCellComment(Comment comment) {
        if (comment == null) {
            this.removeCellComment();
            return;
        }
        comment.setRow(this.getRowIndex());
        comment.setColumn(this.getColumnIndex());
    }

    public void removeCellComment() {
        XSSFComment comment = (XSSFComment)this.getCellComment();
        if (comment != null) {
            String ref = this._cell.getR();
            XSSFSheet sh = (XSSFSheet)this.getSheet();
            sh.getCommentsTable(false).removeComment(ref);
            sh.getVMLDrawing(false).removeCommentShape(this.getRowIndex(), this.getColumnIndex());
        }
    }

    public Hyperlink getHyperlink() {
        return ((XSSFSheet)this.getSheet()).getHyperlink(this._row.getRowNum(), this._cellNum);
    }

    public void setHyperlink(Hyperlink hyperlink) {
        XSSFHyperlink link = (XSSFHyperlink)hyperlink;
        link.setCellReference(new CellReference(this._row.getRowNum(), this._cellNum).formatAsString());
        ((XSSFSheet)this.getSheet()).setCellHyperlink(link);
    }

    public CTCell getCTCell() {
        return this._cell;
    }

    private boolean convertCellValueToBoolean() {
        int cellType = this.getCellType();
        if (cellType == 2) {
            cellType = this.getBaseCellType(false);
        }
        switch (cellType) {
            case 4: {
                return TRUE_AS_STRING.equals(this._cell.getV());
            }
            case 1: {
                int sstIndex = Integer.parseInt(this._cell.getV());
                XSSFRichTextString rt = new XSSFRichTextString(this._sharedStringSource.getEntryAt(sstIndex));
                String text = rt.getString();
                return new Boolean(text);
            }
            case 0: {
                return Double.parseDouble(this._cell.getV()) != 0.0;
            }
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected cell type (" + cellType + ")");
    }

    private String convertCellValueToString() {
        int cellType = this.getCellType();
        switch (cellType) {
            case 3: {
                return "";
            }
            case 4: {
                return TRUE_AS_STRING.equals(this._cell.getV()) ? "TRUE" : "FALSE";
            }
            case 1: {
                int sstIndex = Integer.parseInt(this._cell.getV());
                XSSFRichTextString rt = new XSSFRichTextString(this._sharedStringSource.getEntryAt(sstIndex));
                return rt.getString();
            }
            case 0: 
            case 5: {
                return this._cell.getV();
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell type (" + cellType + ")");
            }
        }
        cellType = this.getBaseCellType(false);
        String textValue = this._cell.getV();
        switch (cellType) {
            case 4: {
                if (TRUE_AS_STRING.equals(textValue)) {
                    return "TRUE";
                }
                if (FALSE_AS_STRING.equals(textValue)) {
                    return "FALSE";
                }
                throw new IllegalStateException("Unexpected boolean cached formula value '" + textValue + "'.");
            }
            case 0: 
            case 1: 
            case 5: {
                return textValue;
            }
        }
        throw new IllegalStateException("Unexpected formula result type (" + cellType + ")");
    }

    public CellRangeAddress getArrayFormulaRange() {
        XSSFCell cell = ((XSSFSheet)this.getSheet()).getFirstCellInArrayFormula(this);
        if (cell == null) {
            throw new IllegalStateException("Cell " + this._cell.getR() + " is not part of an array formula.");
        }
        String formulaRef = cell._cell.getF().getRef();
        return CellRangeAddress.valueOf((String)formulaRef);
    }

    public boolean isPartOfArrayFormulaGroup() {
        return ((XSSFSheet)this.getSheet()).isCellInArrayFormulaContext(this);
    }

    void notifyArrayFormulaChanging(String msg) {
        if (this.isPartOfArrayFormulaGroup()) {
            CellRangeAddress cra = this.getArrayFormulaRange();
            if (cra.getNumberOfCells() > 1) {
                throw new IllegalStateException(msg);
            }
            this.getRow().getSheet().removeArrayFormula((Cell)this);
        }
    }

    void notifyArrayFormulaChanging() {
        CellReference ref = new CellReference((Cell)this);
        String msg = "Cell " + ref.formatAsString() + " is part of a multi-cell array formula. " + "You cannot change part of an array.";
        this.notifyArrayFormulaChanging(msg);
    }
}

