/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.poi.openxml4j.util.ZipEntrySource;

public class ZipInputStreamZipEntrySource
implements ZipEntrySource {
    private ArrayList zipEntries = new ArrayList();

    public ZipInputStreamZipEntrySource(ZipInputStream inp) throws IOException {
        boolean going = true;
        while (going) {
            ZipEntry zipEntry = inp.getNextEntry();
            if (zipEntry == null) {
                going = false;
                continue;
            }
            FakeZipEntry entry = new FakeZipEntry(zipEntry, inp);
            inp.closeEntry();
            this.zipEntries.add(entry);
        }
        inp.close();
    }

    public Enumeration getEntries() {
        return new EntryEnumerator();
    }

    public InputStream getInputStream(ZipEntry zipEntry) {
        FakeZipEntry entry = (FakeZipEntry)zipEntry;
        return entry.getInputStream();
    }

    public void close() {
        this.zipEntries = null;
    }

    private class EntryEnumerator
    implements Enumeration {
        private Iterator iterator;

        private EntryEnumerator() {
            this.iterator = ZipInputStreamZipEntrySource.this.zipEntries.iterator();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return (ZipEntry)this.iterator.next();
        }
    }

    public static class FakeZipEntry
    extends ZipEntry {
        private byte[] data;

        public FakeZipEntry(ZipEntry entry, ZipInputStream inp) throws IOException {
            super(entry.getName());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = inp.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
            this.data = baos.toByteArray();
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data);
        }
    }
}

