/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hwpf.model.FSPA;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;

public final class FSPATable {
    private final List _shapes = new ArrayList();
    private final Map _shapeIndexesByPropertyStart = new HashMap();
    private final List _text;

    public FSPATable(byte[] tableStream, int fcPlcspa, int lcbPlcspa, List tpt) {
        this._text = tpt;
        if (fcPlcspa == 0) {
            return;
        }
        PlexOfCps plex = new PlexOfCps(tableStream, fcPlcspa, lcbPlcspa, 26);
        int i = 0;
        while (i < plex.length()) {
            GenericPropertyNode property = plex.getProperty(i);
            FSPA fspa = new FSPA(property.getBytes(), 0);
            this._shapes.add(fspa);
            this._shapeIndexesByPropertyStart.put(new Integer(property.getStart()), new Integer(i));
            ++i;
        }
    }

    public FSPA getFspaFromCp(int cp) {
        Integer idx = (Integer)this._shapeIndexesByPropertyStart.get(new Integer(cp));
        if (idx == null) {
            return null;
        }
        return (FSPA)this._shapes.get(idx);
    }

    public FSPA[] getShapes() {
        FSPA[] result = new FSPA[this._shapes.size()];
        this._shapes.toArray(result);
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[FPSA PLC size=").append(this._shapes.size()).append("]\n");
        Iterator it = this._shapeIndexesByPropertyStart.keySet().iterator();
        while (it.hasNext()) {
            Integer i = (Integer)it.next();
            FSPA fspa = (FSPA)this._shapes.get((Integer)this._shapeIndexesByPropertyStart.get(i));
            buf.append("  [FC: ").append(i.toString()).append("] ");
            buf.append(fspa.toString());
            buf.append("\n");
        }
        buf.append("[/FSPA PLC]");
        return buf.toString();
    }
}

