/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.POIDocument;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.NameIdChunks;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.hsmf.parsers.POIFSChunkParser;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MAPIMessage
extends POIDocument {
    private Chunks mainChunks;
    private NameIdChunks nameIdChunks;
    private RecipientChunks[] recipientChunks;
    private AttachmentChunks[] attachmentChunks;
    private boolean returnNullOnMissingChunk = false;

    public MAPIMessage() {
        super(new POIFSFileSystem());
    }

    public MAPIMessage(String filename) throws IOException {
        this(new FileInputStream(new File(filename)));
    }

    public MAPIMessage(InputStream in) throws IOException {
        this(new POIFSFileSystem(in));
    }

    public MAPIMessage(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot(), fs);
    }

    public MAPIMessage(DirectoryNode poifsDir, POIFSFileSystem fs) throws IOException {
        super(poifsDir, fs);
        ChunkGroup[] chunkGroups = POIFSChunkParser.parse(poifsDir);
        ArrayList<AttachmentChunks> attachments = new ArrayList<AttachmentChunks>();
        ArrayList<RecipientChunks> recipients = new ArrayList<RecipientChunks>();
        int i = 0;
        while (i < chunkGroups.length) {
            ChunkGroup group = chunkGroups[i];
            if (group instanceof Chunks) {
                this.mainChunks = (Chunks)group;
            } else if (group instanceof NameIdChunks) {
                this.nameIdChunks = (NameIdChunks)group;
            } else if (group instanceof RecipientChunks) {
                recipients.add((RecipientChunks)group);
            }
            if (group instanceof AttachmentChunks) {
                attachments.add((AttachmentChunks)group);
            }
            ++i;
        }
        this.attachmentChunks = attachments.toArray(new AttachmentChunks[attachments.size()]);
        this.recipientChunks = recipients.toArray(new RecipientChunks[recipients.size()]);
        Arrays.sort(this.attachmentChunks, new AttachmentChunks.AttachmentChunksSorter());
        Arrays.sort(this.recipientChunks, new RecipientChunks.RecipientChunksSorter());
    }

    public String getStringFromChunk(StringChunk chunk) throws ChunkNotFoundException {
        if (chunk == null) {
            if (this.returnNullOnMissingChunk) {
                return null;
            }
            throw new ChunkNotFoundException();
        }
        return chunk.getValue();
    }

    public String getTextBody() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.textBodyChunk);
    }

    public String getSubject() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.subjectChunk);
    }

    public String getDisplayFrom() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayFromChunk);
    }

    public String getDisplayTo() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayToChunk);
    }

    public String getDisplayCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayCCChunk);
    }

    public String getDisplayBCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayBCCChunk);
    }

    public String getRecipientEmailAddress() throws ChunkNotFoundException {
        return this.toSemicolonList(this.getRecipientEmailAddressList());
    }

    public String[] getRecipientEmailAddressList() throws ChunkNotFoundException {
        if (this.recipientChunks == null || this.recipientChunks.length == 0) {
            throw new ChunkNotFoundException("No recipients section present");
        }
        String[] emails = new String[this.recipientChunks.length];
        int i = 0;
        while (i < emails.length) {
            RecipientChunks rc = this.recipientChunks[i];
            String email = rc.getRecipientEmailAddress();
            if (email != null) {
                emails[i] = email;
            } else if (this.returnNullOnMissingChunk) {
                emails[i] = null;
            } else {
                throw new ChunkNotFoundException("No email address holding chunks found for the " + (i + 1) + "th recipient");
            }
            ++i;
        }
        return emails;
    }

    public String getRecipientNames() throws ChunkNotFoundException {
        return this.toSemicolonList(this.getRecipientNamesList());
    }

    public String[] getRecipientNamesList() throws ChunkNotFoundException {
        if (this.recipientChunks == null || this.recipientChunks.length == 0) {
            throw new ChunkNotFoundException("No recipients section present");
        }
        String[] names = new String[this.recipientChunks.length];
        int i = 0;
        while (i < names.length) {
            RecipientChunks rc = this.recipientChunks[i];
            String name = rc.getRecipientName();
            if (name == null) {
                throw new ChunkNotFoundException("No display name holding chunks found for the " + (i + 1) + "th recipient");
            }
            names[i] = name;
            ++i;
        }
        return names;
    }

    public void guess7BitEncoding() {
        try {
            String[] headers = this.getHeaders();
            if (headers == null || headers.length == 0) {
                return;
            }
            Pattern p = Pattern.compile("Content-Type:.*?charset=[\"']?(.*?)[\"']?");
            int i = 0;
            while (i < headers.length) {
                Matcher m;
                String header = headers[i];
                if (header.startsWith("Content-Type") && (m = p.matcher(header)).matches()) {
                    Chunk c;
                    String charset = m.group(1);
                    int j = 0;
                    while (j < this.mainChunks.getAll().length) {
                        c = this.mainChunks.getAll()[j];
                        if (c instanceof StringChunk) {
                            ((StringChunk)c).set7BitEncoding(charset);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < this.nameIdChunks.getAll().length) {
                        c = this.nameIdChunks.getAll()[j];
                        if (c instanceof StringChunk) {
                            ((StringChunk)c).set7BitEncoding(charset);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < this.recipientChunks.length) {
                        RecipientChunks rc = this.recipientChunks[j];
                        int k = 0;
                        while (k < rc.getAll().length) {
                            Chunk c2 = rc.getAll()[k];
                            if (c2 instanceof StringChunk) {
                                ((StringChunk)c2).set7BitEncoding(charset);
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
    }

    public String[] getHeaders() throws ChunkNotFoundException {
        String headers = this.getStringFromChunk(this.mainChunks.messageHeaders);
        if (headers == null) {
            return null;
        }
        return headers.split("\\r?\\n");
    }

    public String getConversationTopic() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.conversationTopic);
    }

    public String getMessageClass() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.messageClass);
    }

    public Calendar getMessageDate() throws ChunkNotFoundException {
        if (this.mainChunks.submissionChunk != null) {
            return this.mainChunks.submissionChunk.getAcceptedAtTime();
        }
        if (this.returnNullOnMissingChunk) {
            return null;
        }
        throw new ChunkNotFoundException();
    }

    public Chunks getMainChunks() {
        return this.mainChunks;
    }

    public RecipientChunks[] getRecipientDetailsChunks() {
        return this.recipientChunks;
    }

    public NameIdChunks getNameIdChunks() {
        return this.nameIdChunks;
    }

    public AttachmentChunks[] getAttachmentFiles() {
        return this.attachmentChunks;
    }

    public void write(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Writing isn't yet supported for HSMF, sorry");
    }

    public boolean isReturnNullOnMissingChunk() {
        return this.returnNullOnMissingChunk;
    }

    public void setReturnNullOnMissingChunk(boolean returnNullOnMissingChunk) {
        this.returnNullOnMissingChunk = returnNullOnMissingChunk;
    }

    private String toSemicolonList(String[] l) {
        StringBuffer list = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < l.length) {
            String s = l[i];
            if (s != null) {
                if (first) {
                    first = false;
                } else {
                    list.append("; ");
                }
                list.append(s);
            }
            ++i;
        }
        return list.toString();
    }
}

