/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.ss.usermodel;

/**
 * The enumeration value indicating the style of fill pattern being used for a cell format.
 *
 */
public class FillPatternType {

    /**  No background */
     public static final FillPatternType NO_FILL = new FillPatternType();

    /**  Solidly filled */
     public static final FillPatternType SOLID_FOREGROUND = new FillPatternType();

    /**  Small fine dots */
     public static final FillPatternType FINE_DOTS = new FillPatternType();

    /**  Wide dots */
     public static final FillPatternType ALT_BARS = new FillPatternType();

    /**  Sparse dots */
     public static final FillPatternType SPARSE_DOTS = new FillPatternType();

    /**  Thick horizontal bands */
     public static final FillPatternType THICK_HORZ_BANDS = new FillPatternType();

    /**  Thick vertical bands */
     public static final FillPatternType THICK_VERT_BANDS = new FillPatternType();

    /**  Thick backward facing diagonals */
     public static final FillPatternType THICK_BACKWARD_DIAG = new FillPatternType();

    /**  Thick forward facing diagonals */
     public static final FillPatternType THICK_FORWARD_DIAG = new FillPatternType();

    /**  Large spots */
     public static final FillPatternType BIG_SPOTS = new FillPatternType();

    /**  Brick-like layout */
     public static final FillPatternType BRICKS = new FillPatternType();

    /**  Thin horizontal bands */
     public static final FillPatternType THIN_HORZ_BANDS = new FillPatternType();

    /**  Thin vertical bands */
     public static final FillPatternType THIN_VERT_BANDS = new FillPatternType();

    /**  Thin backward diagonal */
     public static final FillPatternType THIN_BACKWARD_DIAG = new FillPatternType();

    /**  Thin forward diagonal */
     public static final FillPatternType THIN_FORWARD_DIAG = new FillPatternType();

    /**  Squares */
     public static final FillPatternType SQUARES = new FillPatternType();

    /**  Diamonds */
     public static final FillPatternType DIAMONDS = new FillPatternType();

    /**  Less Dots */
     public static final FillPatternType LESS_DOTS = new FillPatternType();

    /**  Least Dots */
     public static final FillPatternType LEAST_DOTS = new FillPatternType();

}
