/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.ss.usermodel;

/**
 * The enumeration value indicating the line style of a border in a cell,
 * i.e., whether it is borded dash dot, dash dot dot, dashed, dotted, double, hair, medium,
 * medium dash dot, medium dash dot dot, medium dashed, none, slant dash dot, thick or thin.
 */
 public class BorderStyle {

    /**
     * No border
     */

    public static final BorderStyle NONE = new BorderStyle();

    /**
     * Thin border
     */

    public static final BorderStyle THIN = new BorderStyle();

    /**
     * Medium border
     */

    public static final BorderStyle MEDIUM = new BorderStyle();

    /**
     * dash border
     */

    public static final BorderStyle DASHED = new BorderStyle();

    /**
     * dot border
     */

    public static final BorderStyle HAIR = new BorderStyle();

    /**
     * Thick border
     */

    public static final BorderStyle THICK = new BorderStyle();

    /**
     * double-line border
     */

    public static final BorderStyle DOUBLE = new BorderStyle();

    /**
     * hair-line border
     */

    public static final BorderStyle DOTTED = new BorderStyle();

    /**
     * Medium dashed border
     */

    public static final BorderStyle MEDIUM_DASHED = new BorderStyle();

    /**
     * dash-dot border
     */

    public static final BorderStyle DASH_DOT = new BorderStyle();

    /**
     * medium dash-dot border
     */

    public static final BorderStyle MEDIUM_DASH_DOT = new BorderStyle();

    /**
     * dash-dot-dot border
     */

    public static final BorderStyle DASH_DOT_DOT = new BorderStyle();

    /**
     * medium dash-dot-dot border
     */

    public static final BorderStyle MEDIUM_DASH_DOT_DOTC = new BorderStyle();

    /**
     * slanted dash-dot border
     */

    public static final BorderStyle SLANTED_DASH_DOT = new BorderStyle();

}
