// Yagshi's old pocket computer emulator core
#include <stdlib.h>
#include "esrh.h"
#include "pokemun.h"
#include <stdio.h>
// global variables
TPocketComHw    *gHw=NULL;     // hardware struct
static TPoemsEvent     *gEvent=NULL;
TCpuState    gCpuState;  // global variable which holds CPU status and etc.
TCpuFunction gCpuFunction;


// PC-1245,50,51,55,60,61,62 keymap
const int kKeyMap125x[kNumKeyMapRow][kNumKeyMapColumn]={
  {'-',EKeyboardCl,'*','/',EKeyboardDownArrow,'E','D','C' },
  {'+','9','3','6',EKeyboardShift,'W','S','X'},
  {'.','8','2','5',EKeyboardDef,'Q','A','Z'},
  {EKeyboardNone,'7','1','4',EKeyboardUpArrow,'R','F','V'},
  {EKeyboardNone,EKeyboardNone,'=','P',EKeyboardLeftArrow,'T','G','B'},
  {EKeyboardNone,EKeyboardNone,EKeyboardNone,'O',EKeyboardRightArrow,
   'Y','H','N'},
  {EKeyboardNone,EKeyboardNone,EKeyboardNone,EKeyboardNone,EKeyboardNone,
   'U','J','M'},
  {EKeyboardNone,EKeyboardNone,EKeyboardNone,EKeyboardNone,EKeyboardNone,
   'I','K',' '},
  {EKeyboardNone,EKeyboardNone,EKeyboardNone,EKeyboardNone,EKeyboardNone,
   EKeyboardNone,'L',EKeyboardEnter},
  {EKeyboardNone,EKeyboardNone,EKeyboardNone,EKeyboardNone,EKeyboardNone,
   EKeyboardNone,EKeyboardNone,'0'}
};

// turn off all dots and symbold
void InitializeLcd( void ){
  int x,y;
  switch( gHw->iModel ){
  case EModelPC1245:
    for( x=0; x<16*5; x++ ){
      for( y=0; y<7; y++ ){
	pel_DrawDot( x,y,0 );
      }
    }
    break;
  case EModelPC1250:
  case EModelPC1251:
  case EModelPC1255:
    for( x=0; x<24*5; x++ ){
      for( y=0; y<7; y++ ){
	pel_DrawDot( x,y,0 );
      }
    }
    break;
  case EModelPC1260:
  case EModelPC1261:
  case EModelPC1262:
    for( x=0; x<24*5; x++ ){
      for( y=0; y<15; y++ ){
	pel_DrawDot( x,y,0 );
      }
    }
    break;
  case EModelPC1450:
    break;
  case EModelPC1350:
    for( x=0; x<24*6; x++ ){
      for( y=0; y<32; y++ ){
	pel_DrawDot( x,y,0 );
      }
    }
    break;
  }
}


// full reset
void pe_InitializeAll(void){
  int i;
  if( gHw ){
    if( gHw->iExtRam ){
      pel_Free(gHw->iExtRam);
    }
    pel_Free( gHw );
  }
  if( (gHw = (TPocketComHw*)pel_Malloc(sizeof(TPocketComHw)))==NULL ){
    exit(-1);
  }
  gHw->iModel=EModelPC1245;
  if( ( gHw->iExtRam = (unsigned char*)pel_Malloc(65536) )==NULL ){
    pel_Alert("Cannot assign enough memory for ext_ram(64KB)");
    exit(-1);
  }
  gHw->iKeyMap = kKeyMap125x;
  for( i=0; i<256; i++ ){
    gHw->iKeyboard[i] = 0;
  }
  if( gEvent ){
    pel_Free( gEvent );
  }
  if( (gEvent = (TPoemsEvent*)pel_Malloc( sizeof(TPoemsEvent) ))==NULL ){
    pe_Panic();
  }    
  esrhInitialize();
  esrhAssignExtRam( gHw->iExtRam );
  esrhAssignFuncReadExternalRam( pe_ReadExternalRam );
  esrhAssignFuncReadExternalRamPc( pe_ReadExternalRamPc );
  esrhAssignFuncWriteExternalRam( pe_WriteExternalRam );
  esrhAssignFuncReadPortA( pe_ReadPortA );
  esrhAssignFuncReadPortB( pe_ReadPortB );
  esrhAssignFuncReadPortTest( pe_ReadPortTest );
  esrhAssignFuncWritePortA( pe_WritePortA );
  esrhAssignFuncWritePortB( pe_WritePortB );
  esrhAssignFuncWritePortC( pe_WritePortC );
  gHw->iPowerSwitch = EPowerSwitchRun;
  gHw->iPortA = 0;
  gHw->iPortB = 0;
  gHw->iPortC = 0;
  gHw->iPortT = 0;
  gHw->iTickUsec = 0;
}

// find row and column value for each key.
// return:  0 for success, other(-1) for fail.
static
int SearchKeyMap( int aKeySymIn, int *aKeyMapRowOut, int *aKeyMapColOut ){
  int r,c;
  for( r=0; r<kNumKeyMapRow; r++ ){
    for( c=0; c<kNumKeyMapColumn; c++ ){
      if( gHw->iKeyMap[r][c]==aKeySymIn ){
	*aKeyMapRowOut = r;
	*aKeyMapColOut = c;
	return 0;
      }
    }
  }
  return -1;
}

void pe_Panic(){
  pel_Alert("POEMS Panic!");
  exit( -1 );
}
    
int pe_MainCallBack( void ){
  int keyMapRow, keyMapCol;
  long curTickUsec;
  static long lastTickUsec;

  if( gHw->iPortC & 0x0c ){  // Powoff or HLT
    pel_SleepUsec(10000);
  }
  //////////////////////////////////////////
  //// clock devider (500Hz, 2Hz timer) ////
  curTickUsec = pel_GetTickCountUsec();
  gHw->iTickUsec += curTickUsec - lastTickUsec;
  lastTickUsec = curTickUsec;

  if( gHw->iTickUsec >= 500000 ){
    gHw->iTickUsec   -= 500000;
    gHw->iTickUsec   =  0;
    if( gHw->iPortC & 4 ){
      gHw->iPortC &= ~4;
    }
    gHw->iPortT |= 1;
  }
  //  if( gHw->iTickUsec>5000 ){
  if( gHw->iTickUsec>8000 ){
    gHw->iPortT &= 0xfe;
  }  
  gHw->iPortT = (gHw->iPortT&~2) |
    ((gHw->iTickUsec/1000)&2) ;

  //////////////////////////////////////////
  ////          event handling          ////
  pel_GetNextEvent( gEvent );
  switch( gEvent->iType ){
  case EKeyPressEvent:
    gHw->iKeyboard[ gEvent->iArg1.iKeyCode ] = 1;
    if( gEvent->iArg1.iKeyCode == EKeyboardBrk ){
      gHw->iPortC &= ~8;
    }
    gHw->iPortC &= ~0x04;
    break;
  case EKeyReleaseEvent:
    gHw->iKeyboard[ gEvent->iArg1.iKeyCode ] = 0;
    break;
  case EResetEvent:
    esrhReset();
    return 0;
  case ESwitchChangeEvent:
    if( gHw->iPowerSwitch == EPowerSwitchOff &&
	gEvent->iArg1.iPowerSwitchState != EPowerSwitchOff ){
      gHw->iPortT |=  8;  // kon
      gHw->iPortC &= ~8;  // power on
    }
    gHw->iPowerSwitch = gEvent->iArg1.iPowerSwitchState;
    gHw->iPortC &= ~0x04;
    if( gHw->iPowerSwitch == EPowerSwitchReserve &&
	gHw->iModel == EModelPC1245 ){
      pel_Alert( "PC-1245 doesn't have reserve mode." );
    }
    break;
  case EModelChangeEvent:
    gHw->iModel = gEvent->iArg1.iModel;
    InitializeLcd();
    break;
  default:
    break;
  }
  if( !(gHw->iPortC & 0x0c) ){
    esrhRun();
  }
  return 0;
}

// I/O port emulation /////////////////////////////////////
// $B$I$&$bF~=PNO%]!<%H$O(B '1' $B$r(B out $B$9$k$H=PNO%T%s$K@_Dj$5$l!"(B
// '0' $B$r(B out $B$7$?$b$N$,F~NO$K$J$k$C$]$$!#=PNO$K@_Dj$5$l$?(B
// $B%T%s$OFI$_=P$9$H(B '0' $B$K$J$k$C$]$$!#(B
unsigned char pe_ReadPortA(void){
  int rowAssertion, colAssertion, lastRowAssertion, lastColAssertion;
  int i,j,ib,jb;
  rowAssertion = ( (gHw->iPortB & 0x07)|( gHw->iPortA)<<3 );
  colAssertion = ( gHw->iPortA);
  lastRowAssertion = -1;
  lastColAssertion = -1;
  // Key matrix scan
  while((rowAssertion!=lastRowAssertion)||(colAssertion!=lastColAssertion)){
    lastRowAssertion = rowAssertion;
    lastColAssertion = colAssertion;
    for( i=0,ib=1; i<10; i++, ib*=2 ){
      if( rowAssertion&ib ){
	for( j=0,jb=1; j<8; j++,jb*=2 ){
	  if( (gHw->iKeyMap)[i][j]<=0 ) continue;
	  if( gHw->iKeyboard[ (gHw->iKeyMap)[i][j] ] ){
	    colAssertion |= jb;
	  }
	}
      }
    }
    for( j=0,jb=1; j<8; j++,jb*=2 ){
      if( colAssertion&jb ){
	for( i=0,ib=1; i<10; i++, ib*=2 ){
	  if( (gHw->iKeyMap)[i][j]<=0 ) continue;
	  if( gHw->iKeyboard[ (gHw->iKeyMap)[i][j] ] ){
	    rowAssertion |= ib;
	  }
	}
      }
    }
  }
  //printf( "portA > %02x  (A:%02x B:%02x) col:%02x",colAssertion & ~gHw->iPortA, gHw->iPortA,gHw->iPortB,colAssertion);

  return colAssertion & ~gHw->iPortA;
}
unsigned char pe_ReadPortB(void){
  unsigned char retVal = 0;
  if( gHw->iPortB & 8 ){
    if( gHw->iPowerSwitch == EPowerSwitchReserve ) retVal |= 1;
    if( gHw->iPowerSwitch == EPowerSwitchPro )     retVal |= 2;
    if( gHw->iPowerSwitch == EPowerSwitchOff )     retVal |= 4;
  }
  if( gHw->iPortB & 2 ){
    if( gHw->iPowerSwitch == EPowerSwitchPro )     retVal |= 8;
  }
  if( gHw->iPortB & 1 ){
    if( gHw->iPowerSwitch == EPowerSwitchReserve ) retVal |= 8;
  }
  if( gHw->iPortB & 4 ){
    if( gHw->iPowerSwitch == EPowerSwitchOff )     retVal |= 8;
  }
  return retVal & ~gHw->iPortB;
}
unsigned char pe_ReadPortTest(void){
  unsigned char retVal;
  retVal = gHw->iPortT;
  // KON = 1 $B$K$J$k>r7o(B:
  //   $BEE8;(B on $B$+$D(B BRK $B%-!<(B
  //   $BEE8;(B off->on (->$B%$%Y%s%H=hM}$G<BAu(B)
  if( gHw->iPowerSwitch!=EPowerSwitchOff ){
    if( gHw->iKeyboard[EKeyboardBrk] ){
      retVal |= 8;
    }else{
      gHw->iPortT &= ~8;  // $BEE8;(Bon$B$+$D(B BRK $B2!$7$F$J$+$C$?$i(B kon $B2<$2$k(B
    }
  }
  //printf( "portT > %02x  ",retVal);
  return retVal;
}
void pe_WritePortA(unsigned char aData){
  gHw->iPortA = aData;
  //printf( "portA < %02x  ",aData );
}
void pe_WritePortB(unsigned char aData){
  gHw->iPortB = aData;
  //printf( "portB < %02x  ",aData );
}
void pe_WritePortC( unsigned char aData ){
  gHw->iPortC = aData;
  if( aData & 0x02 ){
    gHw->iTickUsec = 0;
  }
  if( aData &0x04 ){
    // HLT $B$G$O%+%&%s%?$OJQ$o$i$J$$(B
  }
  if( aData &0x08 ){
    gHw->iTickUsec = 0;
  }
  if( gHw->iModel <= EModelPC1255 ){
    pel_DrawSymbol( ESymbolBUSY, !(aData&1) || pe_ReadExternalRam(0xf83d)&1 );
  }
  //printf( "portC < %02x  ",aData );
}




#ifdef __cplusplus
inline
#endif
unsigned char pe_ReadExternalRamPc( unsigned short aAddr ){
  return gHw->iExtRam[aAddr];
}
#ifdef __cplusplus
inline
#endif
unsigned char pe_ReadExternalRam( unsigned short aAddr ){
  if( aAddr<0x2000 ) return aAddr>>8;
  return gHw->iExtRam[aAddr];
}

void pe_WriteExternalRam( unsigned short aAddr, unsigned char aData ){
  int  x,y;
  // memory mapping image
  switch( gHw->iModel ){
  case EModelPC1245:
  case EModelPC1250:
  case EModelPC1251:
    if( aAddr>=0xb000 && aAddr<0xb800 ) aAddr+=0x800;
  case EModelPC1255:
    if( aAddr>=0x8000 && aAddr<0xa000 ) aAddr+=0x2000;
    if( aAddr>=0xd000 && aAddr<0xd800 ) aAddr-=0x1000;
    if( aAddr>=0xf900 ) aAddr&=0xf8ff;
  }

  switch( gHw->iModel ){
  case EModelPC1245:
  case EModelPC1250:
    if( aAddr<0xc000 ) break;
  case EModelPC1251:
    if( aAddr<0xb800 ) break;
  case EModelPC1255:
    if( aAddr<0xa000 ) break;
    if( aAddr<0xc000 ){  // MAIN RAM 1
      gHw->iExtRam[aAddr] = aData;
      gHw->iExtRam[aAddr-0x2000] = aData;
      break;
    }
    if( aAddr<0xc800 ){  // MAIN RAM 2
      gHw->iExtRam[aAddr] = aData;
      gHw->iExtRam[aAddr+0x1000] = aData;
      break;
    }
    //    if( aAddr>=0xf800 && aAddr<0xf880 ){  // VRAM
    if( aAddr>=0xf800 && aAddr<0xf900 ){  // VRAM
      gHw->iExtRam[aAddr]=aData;
      gHw->iExtRam[aAddr+0x100]=aData;
      gHw->iExtRam[aAddr+0x200]=aData;
      gHw->iExtRam[aAddr+0x300]=aData;
      gHw->iExtRam[aAddr+0x400]=aData;
      gHw->iExtRam[aAddr+0x500]=aData;
      gHw->iExtRam[aAddr+0x600]=aData;
      gHw->iExtRam[aAddr+0x700]=aData;
      if( aAddr<0xf83c || (aAddr>=0xf840 && aAddr<0xf87c ) ){  // $B<g2hLL(B
	x= (aAddr<0xf83c) ? (aAddr-0xf800) : (12*5+(0xf87b-aAddr));
	pel_DrawDot( x, 0, aData & 0x01 );
	pel_DrawDot( x, 1, aData & 0x02 );
	pel_DrawDot( x, 2, aData & 0x04 );
	pel_DrawDot( x, 3, aData & 0x08 );
	pel_DrawDot( x, 4, aData & 0x10 );
	pel_DrawDot( x, 5, aData & 0x20 );
	pel_DrawDot( x, 6, aData & 0x40 );
      }
      if( aAddr==0xf83c ){
	pel_DrawSymbol( ESymbolDEF, aData & 0x01 );
	pel_DrawSymbol( ESymbolP  , aData & 0x02 );
	pel_DrawSymbol( ESymbolG  , aData & 0x04 );
	pel_DrawSymbol( ESymbolDE , aData & 0x08 );
      }
      if( aAddr==0xf83d ){
	pel_DrawSymbol( ESymbolBUSY,  aData & 0x01 );
	pel_DrawSymbol( ESymbolSHIFT, aData & 0x02 );
	pel_DrawSymbol( ESymbolRAD,   aData & 0x04 );
	if( gHw->iModel != EModelPC1245 )
	  pel_DrawSymbol( ESymbolE,     aData & 0x08 );
      }
      break;
    }
    break;
  case EModelPC1260:
    if( aAddr>=0x4000 && aAddr<0x5800 ) break;
  case EModelPC1261:
  case EModelPC1262:
    if( aAddr>=0x6800 ) break;
    if( aAddr< 0x2000 ) break;
    gHw->iExtRam[aAddr] = aData;
    if( aAddr< 0x4000 ){    ///////// VRAM
      y=0;
      aAddr &= 0x28ff;
      gHw->iExtRam[aAddr] = aData;
      if( aAddr==0x203d ){  //////// SYMBOL 1
	pel_DrawSymbol( ESymbolBUSY,  aData & 0x01 );
	pel_DrawSymbol( ESymbolPRINT, aData & 0x02 );
	pel_DrawSymbol( ESymbolKANA,  aData & 0x08 );
	pel_DrawSymbol( ESymbolSMALL, aData & 0x10 );
	pel_DrawSymbol( ESymbolSHIFT, aData & 0x20 );
	pel_DrawSymbol( ESymbolDEF,   aData & 0x40 );
	break;
      }
      if( aAddr==0x207c ){  //////// SYMBOL 2
	pel_DrawSymbol( ESymbolDEGREE,aData & 0x01 );
	pel_DrawSymbol( ESymbolRADIAN,aData & 0x02 );
	pel_DrawSymbol( ESymbolERROR, aData & 0x20 );
	pel_DrawSymbol( ESymbol207C_40, aData & 0x40 );
	break;
      }
      if( aAddr>0x203b && aAddr<0x2040 ) break;
      if( aAddr>0x283b && aAddr<0x2840 ) break;
      if( aAddr>0x207b && aAddr<0x2800 ) break;
      x = (aAddr & 0xff);
      if( x>=0x40 ) x-=0x40;
      if( aAddr&0x800 ){
	x+=12*5;
      }
      if( aAddr&0x40 ){
	y=8;
      }
      if( x>=0 && x<24*5 ){
	pel_DrawDot( x, y+0, aData & 0x01 );
	pel_DrawDot( x, y+1, aData & 0x02 );
	pel_DrawDot( x, y+2, aData & 0x04 );
	pel_DrawDot( x, y+3, aData & 0x08 );
	pel_DrawDot( x, y+4, aData & 0x10 );
	pel_DrawDot( x, y+5, aData & 0x20 );
	pel_DrawDot( x, y+6, aData & 0x40 );
      }
    }
    break;
default:
    if( aAddr<0x2000 ) return;  // $BFbIt(B ROM $B$X$N=q$-9~$_(B
    gHw->iExtRam[aAddr]=aData;
  }
}
    
