#ifndef __ESRH_H
#define __ESRH_H

#ifdef __cplusplus
extern "C"{
#endif

#define   kRamI  0
#define   kRamJ  1
#define   kRamA  2
#define   kRamB  3
#define   kRamXl 4
#define   kRamXh 5
#define   kRamYl 6
#define   kRamYh 7
#define   kRamK  8
#define   kRamL  9
#define   kRamM  10
#define   kRamN  11
#define   kRamPortA 0x5c
#define   kRamPortB 0x5d
#define   kRamPortF 0x5e
#define   kRamPortC 0x5f

typedef struct __cpustate{
  unsigned char  iCurrentInstruction;

  int            iZFlag,iCFlag;
  unsigned char  iP,iQ,iR;
  unsigned short iPc;
  unsigned short iDp;
  unsigned char  iInnerRam[128];
  unsigned char  iCaseNum;
  unsigned char *iExtRam;
  unsigned char iDataBus;
}TCpuState;
  
typedef struct __cpufunction{
  // I/O functions
  unsigned char (*iFuncReadPortA)(void);
  unsigned char (*iFuncReadPortB)(void);
  unsigned char (*iFuncReadXin)(void);
  unsigned char (*iFuncReadTest)(void);
  unsigned char (*iFuncReadExternalRam)(unsigned short aAddress);
  unsigned char (*iFuncReadExternalRamPc)(unsigned short aAddress);
  void (*iFuncWritePortA)(unsigned char aData);
  void (*iFuncWritePortB)(unsigned char aData);
  void (*iFuncWritePortC)(unsigned char aData);
  void (*iFuncWritePortF)(unsigned char aData);
  void (*iFuncWriteExternalRam)(unsigned short aAddress, unsigned char aData);
}TCpuFunction;


void esrhInitialize( void );
void esrhReset( void );
void esrhRun( void );
void esrhAssignExtRam( unsigned char *aRamTopAddress );
void esrhAssignFuncWritePortA( void (*aFunc)(unsigned char aData) );
void esrhAssignFuncWritePortB( void (*aFunc)(unsigned char aData) );
void esrhAssignFuncWritePortC( void (*aFunc)(unsigned char aData) );
void esrhAssignFuncWritePortF( void (*aFunc)(unsigned char aData) );
void esrhAssignFuncReadPortA( unsigned char (*aFunc)(void) );
void esrhAssignFuncReadPortB( unsigned char (*aFunc)(void) );
void esrhAssignFuncReadPortXin( unsigned char (*aFunc)(void) );
void esrhAssignFuncReadPortTest( unsigned char (*aFunc)(void) );

void esrhAssignFuncWriteExternalRam( void (*aFunc)(unsigned short aAddress,
						   unsigned char aData) );
void esrhAssignFuncReadExternalRam( unsigned char (*aFunc)(unsigned  short aAddress) );
void esrhAssignFuncReadExternalRamPc( unsigned char (*aFunc)(unsigned  short aAddress) );
#ifdef __cplusplus
}
#endif

#endif
