<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
plugins/Forum/Model/Star.php
*/
abstract class Plugg_Forum_Model_Base_Star extends Sabai_Model_Entity
{
    public function __construct(Sabai_Model $model)
    {
        parent::__construct('Star', $model);
        $this->_vars = array('star_id' => 0, 'star_created' => 0, 'star_updated' => 0, 'star_topic_id' => 0, 'star_comment_id' => 0, 'star_user_id' => 0);
    }

    public function __clone()
    {
        $this->_vars = array_merge($this->_vars, array('star_id' => 0, 'star_created' => 0, 'star_updated' => 0));
    }

    public function __toString()
    {
        return 'Star #' . $this->_get('id', null, null);
    }

    public function assignUser($user, $markDirty = true)
    {
        $this->_set('user_id', $user->id, $markDirty);
        return $this;
    }

    protected function _fetchUser($withData = false)
    {
        if (!isset($this->_objects['User'])) {
            $this->_objects['User'] = $this->_model->User_Identity($this->_vars['star_user_id'], $withData);
        }

        return $this->_objects['User'];
    }

    public function isOwnedBy($user)
    {
        return $this->user_id && $this->user_id == $user->id;
    }

    public function assignTopic(Plugg_Forum_Model_Topic $entity)
    {
        $this->_assignEntity($entity, 'topic_id');
        return $this;
    }

    public function unassignTopic()
    {
        $this->_unassignEntity('Topic', 'topic_id');
        return $this;
    }

    protected function _fetchTopic()
    {
        return $this->_fetchEntity('Topic', 'topic_id');
    }

    public function assignComment(Plugg_Forum_Model_Comment $entity)
    {
        $this->_assignEntity($entity, 'comment_id');
        return $this;
    }

    public function unassignComment()
    {
        $this->_unassignEntity('Comment', 'comment_id');
        return $this;
    }

    protected function _fetchComment()
    {
        return $this->_fetchEntity('Comment', 'comment_id');
    }

    protected function _get($name, $sort, $order, $limit = 0, $offset = 0)
    {
        switch ($name) {
        case 'id':
            return $this->_vars['star_id'];
        case 'created':
            return $this->_vars['star_created'];
        case 'updated':
            return $this->_vars['star_updated'];
        case 'topic_id':
            return $this->_vars['star_topic_id'];
        case 'comment_id':
            return $this->_vars['star_comment_id'];
        case 'user_id':
            return $this->_vars['star_user_id'];
        case 'Topic':
            return $this->_fetchTopic();
        case 'Comment':
            return $this->_fetchComment();
        case 'User':
            return $this->_fetchUser();
        case 'UserWithData':
            return $this->_fetchUser(true);
default:
return isset($this->_objects[$name]) ? $this->_objects[$name] : null;
        }
    }

    protected function _set($name, $value, $markDirty)
    {
        switch ($name) {
        case 'id':
            $this->_setVar('star_id', $value, $markDirty);
            break;
        case 'topic_id':
            $this->_setVar('star_topic_id', $value, $markDirty);
            break;
        case 'comment_id':
            $this->_setVar('star_comment_id', $value, $markDirty);
            break;
        case 'user_id':
            $this->_setVar('star_user_id', $value, $markDirty);
            break;
        case 'Topic':
            $entity = is_array($value) ? $value[0] : $value;
            $this->assignTopic($entity);
            break;
        case 'Comment':
            $entity = is_array($value) ? $value[0] : $value;
            $this->assignComment($entity);
            break;
        }
    }

    protected function _initVar($name, $value)
    {
        switch ($name) {
        default:
            $this->_vars[$name] = $value;
            break;
        }
    }
}

abstract class Plugg_Forum_Model_Base_StarRepository extends Sabai_Model_EntityRepository
{
    public function __construct(Sabai_Model $model)
    {
        parent::__construct('Star', $model);
    }

    public function fetchByUser($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('star_user_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByUser($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('User', $id, $perpage, $sort, $order);
    }

    public function countByUser($id)
    {
        return $this->_countByForeign('star_user_id', $id);
    }

    public function fetchByUserAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('star_user_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByUserAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('User', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByUserAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('star_user_id', $id, $criteria);
    }

    public function fetchByTopic($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('star_topic_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByTopic($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('Topic', $id, $perpage, $sort, $order);
    }

    public function countByTopic($id)
    {
        return $this->_countByForeign('star_topic_id', $id);
    }

    public function fetchByTopicAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('star_topic_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByTopicAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('Topic', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByTopicAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('star_topic_id', $id, $criteria);
    }

    public function fetchByComment($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('star_comment_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByComment($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('Comment', $id, $perpage, $sort, $order);
    }

    public function countByComment($id)
    {
        return $this->_countByForeign('star_comment_id', $id);
    }

    public function fetchByCommentAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('star_comment_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByCommentAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('Comment', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByCommentAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('star_comment_id', $id, $criteria);
    }

    protected function _getCollectionByRowset(Sabai_DB_Rowset $rs)
    {
        return new Plugg_Forum_Model_Base_StarsByRowset($rs, $this->_model->create('Star'), $this->_model);
    }

    public function createCollection(array $entities = array())
    {
        return new Plugg_Forum_Model_Base_Stars($this->_model, $entities);
    }
}

class Plugg_Forum_Model_Base_StarsByRowset extends Sabai_Model_EntityCollection_Rowset
{
    public function __construct(Sabai_DB_Rowset $rs, Plugg_Forum_Model_Star $emptyEntity, Sabai_Model $model)
    {
        parent::__construct('Stars', $rs, $emptyEntity, $model);
    }

    protected function _loadRow(Sabai_Model_Entity $entity, array $row)
    {
        $entity->initVars($row);
    }
}

class Plugg_Forum_Model_Base_Stars extends Sabai_Model_EntityCollection_Array
{
    public function __construct(Sabai_Model $model, array $entities = array())
    {
        parent::__construct($model, 'Stars', $entities);
    }
}