<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
pluginsy/Forum/Model/CommentGateway.php
*/
abstract class Plugg_Forum_Model_Base_CommentGateway extends Sabai_Model_TreeGateway
{
    public function getName()
    {
        return 'comment';
    }

    public function getFields()
    {
        return array('comment_id' => Sabai_Model::KEY_TYPE_INT, 'comment_created' => Sabai_Model::KEY_TYPE_INT, 'comment_updated' => Sabai_Model::KEY_TYPE_INT, 'comment_title' => Sabai_Model::KEY_TYPE_VARCHAR, 'comment_body' => Sabai_Model::KEY_TYPE_TEXT, 'comment_body_html' => Sabai_Model::KEY_TYPE_TEXT, 'comment_body_filter_id' => Sabai_Model::KEY_TYPE_INT, 'comment_ip' => Sabai_Model::KEY_TYPE_CHAR, 'comment_host' => Sabai_Model::KEY_TYPE_VARCHAR, 'comment_parent_id' => Sabai_Model::KEY_TYPE_INT, 'comment_topic_id' => Sabai_Model::KEY_TYPE_INT, 'comment_parent' => Sabai_Model::KEY_TYPE_INT, 'comment_user_id' => Sabai_Model::KEY_TYPE_INT, 'comment_star_count' => Sabai_Model::KEY_TYPE_INT, 'comment_star_last' => Sabai_Model::KEY_TYPE_INT, 'comment_star_lasttime' => Sabai_Model::KEY_TYPE_INT, 'comment_attachment_count' => Sabai_Model::KEY_TYPE_INT, 'comment_attachment_last' => Sabai_Model::KEY_TYPE_INT, 'comment_attachment_lasttime' => Sabai_Model::KEY_TYPE_INT);
    }
    public function getSortFields()
    {
        return array('comment_id' => Sabai_Model::KEY_TYPE_INT, 'comment_created' => Sabai_Model::KEY_TYPE_INT, 'comment_updated' => Sabai_Model::KEY_TYPE_INT, 'comment_title' => Sabai_Model::KEY_TYPE_VARCHAR, 'comment_body' => Sabai_Model::KEY_TYPE_TEXT, 'comment_body_html' => Sabai_Model::KEY_TYPE_TEXT, 'comment_body_filter_id' => Sabai_Model::KEY_TYPE_INT, 'comment_ip' => Sabai_Model::KEY_TYPE_CHAR, 'comment_host' => Sabai_Model::KEY_TYPE_VARCHAR, 'comment_parent_id' => Sabai_Model::KEY_TYPE_INT, 'comment_topic_id' => Sabai_Model::KEY_TYPE_INT, 'comment_parent' => Sabai_Model::KEY_TYPE_INT, 'comment_user_id' => Sabai_Model::KEY_TYPE_INT, 'comment_star_count' => Sabai_Model::KEY_TYPE_INT, 'comment_star_last' => Sabai_Model::KEY_TYPE_INT, 'comment_star_lasttime' => Sabai_Model::KEY_TYPE_INT, 'comment_attachment_count' => Sabai_Model::KEY_TYPE_INT, 'comment_attachment_last' => Sabai_Model::KEY_TYPE_INT, 'comment_attachment_lasttime' => Sabai_Model::KEY_TYPE_INT, 'comment_tree_left' => Sabai_Model::KEY_TYPE_INT, 'comment_tree_right' => Sabai_Model::KEY_TYPE_INT);
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT t.%s, t1.tree_left AS comment_tree_left, t1.tree_right AS comment_tree_right FROM %scomment t INNER JOIN %2$scomment_tree t1 ON t1.tree_id = t.comment_id WHERE comment_id = %d',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $id
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT t.%s, t1.tree_left AS comment_tree_left, t1.tree_right AS comment_tree_right FROM %scomment t INNER JOIN %2$scomment_tree t1 ON t1.tree_id = t.comment_id WHERE comment_id IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(',', array_map('intval', $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT t.%1$s, t1.tree_left AS comment_tree_left, t1.tree_right AS comment_tree_right FROM %2$scomment t INNER JOIN %2$scomment_tree t1 ON t1.tree_id = t.comment_id WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery($values)
    {
        $values['comment_created'] = time();
        $values['comment_updated'] = 0;
        $values['comment_star_lasttime'] = $values['comment_created'];
        $values['comment_attachment_lasttime'] = $values['comment_created'];
        return sprintf("INSERT INTO %scomment(comment_created, comment_updated, comment_title, comment_body, comment_body_html, comment_body_filter_id, comment_ip, comment_host, comment_parent_id, comment_topic_id, comment_parent, comment_user_id, comment_star_count, comment_star_last, comment_star_lasttime, comment_attachment_count, comment_attachment_last, comment_attachment_lasttime) VALUES(%d, %d, %s, %s, %s, %d, %s, %s, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d)", $this->_db->getResourcePrefix(), $values['comment_created'], $values['comment_updated'], $this->_db->escapeString($values['comment_title']), $this->_db->escapeString($values['comment_body']), $this->_db->escapeString($values['comment_body_html']), $values['comment_body_filter_id'], $this->_db->escapeString($values['comment_ip']), $this->_db->escapeString($values['comment_host']), $values['comment_parent_id'], $values['comment_topic_id'], $values['comment_parent'], $values['comment_user_id'], $values['comment_star_count'], $values['comment_star_last'], $values['comment_star_lasttime'], $values['comment_attachment_count'], $values['comment_attachment_last'], $values['comment_attachment_lasttime']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['comment_updated'];
        $values['comment_updated'] = time();
        return sprintf("UPDATE %scomment SET comment_updated = %d, comment_title = %s, comment_body = %s, comment_body_html = %s, comment_body_filter_id = %d, comment_ip = %s, comment_host = %s, comment_parent_id = %d, comment_topic_id = %d, comment_parent = %d, comment_user_id = %d WHERE comment_id = %d AND comment_updated = %d", $this->_db->getResourcePrefix(), $values['comment_updated'], $this->_db->escapeString($values['comment_title']), $this->_db->escapeString($values['comment_body']), $this->_db->escapeString($values['comment_body_html']), $values['comment_body_filter_id'], $this->_db->escapeString($values['comment_ip']), $this->_db->escapeString($values['comment_host']), $values['comment_parent_id'], $values['comment_topic_id'], $values['comment_parent'], $values['comment_user_id'], $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$scomment WHERE comment_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['comment_updated'] = 'comment_updated=' . time();
        return sprintf('UPDATE %scomment SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(',', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE FROM %1$scomment WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$scomment WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    public function selectByIdFromMainTable($id, array $fields = array())
    {
        $fields = empty($fields) ? '*' : implode(',', $fields);
        $sql = sprintf('SELECT %s FROM %scomment WHERE comment_id = %d', $fields, $this->_db->getResourcePrefix(), $id);
        return $this->_db->query($sql);
    }

    protected function _getSelectDescendantsQuery($id, $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t3.', $fields);
        return sprintf('SELECT t3.%3$s, t1.tree_left AS comment_tree_left, t1.tree_right AS comment_tree_right FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right INNER JOIN %1$scomment t3 ON t1.tree_id = t3.comment_id WHERE t2.tree_id = %2$d AND t1.tree_id <> %2$d', $this->_db->getResourcePrefix(), $id, $fields);
    }

    protected function _getSelectDescendantsAsTreeQuery($id, $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t3.', $fields);
        return sprintf('SELECT t3.%3$s, t1.tree_left AS comment_tree_left, t1.tree_right AS comment_tree_right, levels.level FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right INNER JOIN %1$scomment t3 ON t1.tree_id = t3.comment_id INNER JOIN (SELECT t4.tree_id, COUNT(*) AS level FROM %1$scomment_tree t4 INNER JOIN %1$scomment_tree t5 ON t4.tree_left BETWEEN t5.tree_left AND t5.tree_right GROUP BY t4.tree_id) AS levels ON t3.comment_id = levels.tree_id WHERE t2.tree_id = %2$d AND t1.tree_id <> %2$d GROUP BY comment_id', $this->_db->getResourcePrefix(), $id, $fields);
    }

    protected function _getCountDescendantsQuery($id)
    {
        return sprintf('SELECT COUNT(*) FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right WHERE t2.tree_id = %2$d AND t1.tree_id <> %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getCountDescendantsByIdsQuery($ids)
    {
        return sprintf('SELECT t2.tree_id, COUNT(*) - 1 FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right WHERE t2.tree_id IN(%2$s) GROUP BY t2.tree_id', $this->_db->getResourcePrefix(), implode(',', $ids));
    }

    protected function _getSelectParentsQuery($id, $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t3.', $fields);
        return sprintf('SELECT t3.%3$s, t2.tree_left AS comment_tree_left, t2.tree_right AS comment_tree_right FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right INNER JOIN %1$scomment t3 ON t2.tree_id = t3.comment_id WHERE t1.tree_id = %2$d AND t2.tree_id <> %2$d', $this->_db->getResourcePrefix(), $id, $fields);
    }

    protected function _getCountParentsQuery($id)
    {
        return sprintf('SELECT COUNT(*) FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right WHERE t1.tree_id = %2$d AND t2.tree_id <> %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getCountParentsByIdsQuery($ids)
    {
        return sprintf('SELECT t1.tree_id, COUNT(*) - 1 FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right WHERE t1.tree_id IN(%2$s) GROUP BY t1.tree_id', $this->_db->getResourcePrefix(), implode(',', $ids));
    }

    protected function _afterInsertTrigger1($id, $new)
    {
        if (!empty($new['comment_parent'])) {
            $sql = sprintf('SELECT tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $new['comment_parent']);
            if ($rs = $this->_db->query($sql)) {
                $value_right = $rs->fetchSingle();
                $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left + 2 WHERE tree_left > %d', $this->_db->getResourcePrefix(), $value_right));
                $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right + 2 WHERE tree_right >= %d', $this->_db->getResourcePrefix(), $value_right));
                $this->_db->exec(sprintf('INSERT INTO %scomment_tree(tree_id, tree_left, tree_right) VALUES (%d, %d, %d)', $this->_db->getResourcePrefix(), $new['comment_id'], $value_right, $value_right + 1));
            }
        } else {
            $sql = sprintf('SELECT MAX(tree_right) FROM %scomment_tree', $this->_db->getResourcePrefix());
            if ($rs = $this->_db->query($sql)) {
                $value_right = $rs->fetchSingle();
                $this->_db->exec(sprintf('INSERT INTO %scomment_tree(tree_id, tree_left, tree_right) VALUES (%d, %d, %d)', $this->_db->getResourcePrefix(), $new['comment_id'], $value_right + 1, $value_right + 2));
            }
        }
    }

    protected function _beforeDeleteTrigger1($id, $old)
    {
        $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
        if (!$rs = $this->_db->query($sql)) {
            return false;
        }
        list($value_left, $value_right) = $rs->fetchRow();
        if ($value_right - $value_left > 1) {
            // Cannot remove entity with child entities
            return false;
        }
        return true;
    }

    protected function _afterDeleteTrigger1($id, $old)
    {
        $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
        if ($rs = $this->_db->query($sql)) {
            list($value_left, $value_right) = $rs->fetchRow();
            $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left - 2 WHERE tree_left > %d', $this->_db->getResourcePrefix(), $value_left));
            $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right - 2 WHERE tree_right > %d', $this->_db->getResourcePrefix(), $value_right));
            $this->_db->exec(sprintf('DELETE FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']));
        }
    }

    protected function _beforeUpdateTrigger1($id, $new, $old)
    {
        if (!empty($new['comment_parent'])) {
            if ($new['comment_parent'] == $new['comment_id']) {
                // Cannot assign itself as the parent entity
                return false;
            }
            $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
            if (!$rs = $this->_db->query($sql)) {
                return false;
            }
            list($old_left, $old_right) = $rs->fetchRow();
            $sql = sprintf('SELECT tree_left FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $new['comment_parent']);
            if (!$rs = $this->_db->query($sql)) {
                return false;
            }
            $new_parent_left = $rs->fetchSingle();
            if ($new_parent_left > $old_left && $new_parent_left < $old_right) {
                // Cannot assign descendant as the parent entity
                return false;
            }
        }
        return true;
    }

    protected function _afterUpdateTrigger1($id, $new, $old)
    {
        if (!empty($new['comment_parent'])) {
            if (empty($old['comment_parent']) || $new['comment_parent'] != $old['comment_parent']) {
                $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
                if ($rs = $this->_db->query($sql)) {
                    list($value_left, $value_right) = $rs->fetchRow();
                    $sql = sprintf('SELECT MAX(tree_right) + 1 FROM %scomment_tree', $this->_db->getResourcePrefix());
                    if ($rs = $this->_db->query($sql)) {
                        $temp_left = $rs->fetchSingle();
                        $value_between = $value_right - $value_left + 1;
                        $this->_db->exec(sprintf('UPDATE %4$scomment_tree SET tree_left = tree_left + %1$d - %2$d, tree_right = tree_right + %1$d - %2$d WHERE tree_left BETWEEN %2$d AND %3$d', $temp_left, $value_left, $value_right, $this->_db->getResourcePrefix()));
                        $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left - %d WHERE tree_left > %d AND tree_right < %d', $this->_db->getResourcePrefix(), $value_between, $value_right, $temp_left));
                        $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right - %d WHERE tree_right > %d AND tree_right < %d', $this->_db->getResourcePrefix(), $value_between, $value_right, $temp_left));
                        $sql = sprintf('SELECT tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $new['comment_parent']);
                        if ($rs = $this->_db->query($sql)) {
                            $new_parent_right = $rs->fetchSingle();
                            $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left + %d WHERE tree_left > %d AND tree_left < %d', $this->_db->getResourcePrefix(), $value_between, $new_parent_right, $temp_left));
                            $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right + %d WHERE tree_right >= %d AND tree_left < %d', $this->_db->getResourcePrefix(), $value_between, $new_parent_right, $temp_left));
                            $value_diff = $new_parent_right - $temp_left;
                            $this->_db->exec(sprintf('UPDATE %3$scomment_tree SET tree_left = tree_left + %1$d, tree_right = tree_right + %1$d WHERE tree_left >= %2$d', $value_diff, $temp_left, $this->_db->getResourcePrefix()));
                        }
                    }
                }
            }
        } else {
            if (!empty($old['comment_parent'])) {
                $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
                if ($rs = $this->_db->query($sql)) {
                    list($value_left, $value_right) = $rs->fetchRow();
                    $sql = sprintf('SELECT MAX(tree_right) + 1 FROM %scomment_tree', $this->_db->getResourcePrefix());
                    if ($rs = $this->_db->query($sql)) {
                        $temp_left = $rs->fetchSingle();
                        $value_diff = $temp_left - $value_left;
                        $this->_db->exec(sprintf('UPDATE %4$scomment_tree SET tree_left = tree_left + %1$d, tree_right = tree_right + %1$d WHERE tree_left BETWEEN %2$d AND %3$d', $value_diff, $value_left, $value_right, $this->_db->getResourcePrefix()));
                        $value_between = $value_right - $value_left + 1;
                        $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left - %d WHERE tree_left > %d', $this->_db->getResourcePrefix(), $value_between, $value_right));
                        $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right - %d WHERE tree_right > %d', $this->_db->getResourcePrefix(), $value_between, $value_right));
                    }
                }
            }
        }
    }

    protected function _afterInsertTrigger2($id, $new)
    {
        if (!empty($new['comment_topic_id'])) {
            $this->_db->exec(sprintf('UPDATE %stopic SET topic_comment_count = topic_comment_count + 1, topic_comment_last = %d, topic_comment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $id, $new['comment_created'], $new['comment_topic_id']));
        }
    }

    protected function _afterDeleteTrigger2($id, $old)
    {
        if (!empty($old['comment_topic_id'])) {
            $sql = sprintf('SELECT comment_id, comment_created FROM %scomment WHERE comment_topic_id = %d ORDER BY comment_created DESC', $this->_db->getResourcePrefix(), $old['comment_topic_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_comment_count = topic_comment_count - 1, topic_comment_last = %d, topic_comment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $row['comment_id'], $row['comment_created'], $old['comment_topic_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_comment_count = topic_comment_count - 1, topic_comment_last = 0, topic_comment_lasttime = topic_created WHERE topic_id = %d', $this->_db->getResourcePrefix(), $old['comment_topic_id']));
            }
        }
    }

    protected function _afterUpdateTrigger2($id, $new, $old)
    {
        if (empty($old['comment_topic_id']) && !empty($new['comment_topic_id'])) {
            $this->_db->exec(sprintf('UPDATE %stopic SET topic_comment_count = topic_comment_count + 1, topic_comment_last = %d, topic_comment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $id, $new['comment_created'], $new['comment_topic_id']));
        } elseif (!empty($old['comment_topic_id']) && empty($new['comment_topic_id'])) {
            $sql = sprintf('SELECT comment_id, comment_created FROM %scomment WHERE comment_topic_id = %d ORDER BY comment_created DESC', $this->_db->getResourcePrefix(), $old['comment_topic_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_comment_count = topic_comment_count - 1, topic_comment_last = %d, topic_comment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $row['comment_id'], $row['comment_created'], $old['comment_topic_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_comment_count = topic_comment_count - 1, topic_comment_last = 0, topic_comment_lasttime = topic_created WHERE topic_id = %d', $this->_db->getResourcePrefix(), $old['comment_topic_id']));
            }
        } elseif ($old['comment_topic_id'] != $new['comment_topic_id']) {
            $sql = sprintf('SELECT comment_id, comment_created FROM %scomment WHERE comment_topic_id = %d ORDER BY comment_created DESC', $this->_db->getResourcePrefix(), $old['comment_topic_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_comment_count = topic_comment_count - 1, topic_comment_last = %d, topic_comment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $row['comment_id'], $row['comment_created'], $old['comment_topic_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_comment_count = topic_comment_count - 1, topic_comment_last = 0, topic_comment_lasttime = topic_created WHERE topic_id = %d', $this->_db->getResourcePrefix(), $old['comment_topic_id']));
            }
            $this->_db->exec(sprintf('UPDATE %stopic SET topic_comment_count = topic_comment_count + 1, topic_comment_last = %d, topic_comment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $id, $new['comment_created'], $new['comment_topic_id']));
        }
    }

    protected function _beforeDeleteTrigger2($id, $old)
    {
        return $this->_db->exec(sprintf('DELETE FROM %1$sstar WHERE %1$sstar.star_comment_id = %2$d', $this->_db->getResourcePrefix(), $id), false);
    }

    protected function _beforeDeleteTrigger3($id, $old)
    {
        return $this->_db->exec(sprintf('DELETE FROM %1$sattachment WHERE %1$sattachment.attachment_comment_id = %2$d', $this->_db->getResourcePrefix(), $id), false);
    }

    protected function _afterInsertTrigger($id, $new)
    {
        $this->_afterInsertTrigger1($id, $new);
        $this->_afterInsertTrigger2($id, $new);
    }

    protected function _beforeUpdateTrigger($id, $new, $old)
    {
        if (!$this->_beforeUpdateTrigger1($id, $new, $old)) return false;
        return true;
    }

    protected function _afterUpdateTrigger($id, $new, $old)
    {
        $this->_afterUpdateTrigger1($id, $new, $old);
        $this->_afterUpdateTrigger2($id, $new, $old);
    }

    protected function _beforeDeleteTrigger($id, $old)
    {
        if (!$this->_beforeDeleteTrigger1($id, $old)) return false;
        if (!$this->_beforeDeleteTrigger2($id, $old)) return false;
        if (!$this->_beforeDeleteTrigger3($id, $old)) return false;
        return true;
    }

    protected function _afterDeleteTrigger($id, $old)
    {
        $this->_afterDeleteTrigger1($id, $old);
        $this->_afterDeleteTrigger2($id, $old);
    }
}