<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
pluginsy/Forum/Model/AttachmentGateway.php
*/
abstract class Plugg_Forum_Model_Base_AttachmentGateway extends Sabai_Model_Gateway
{
    public function getName()
    {
        return 'attachment';
    }

    public function getFields()
    {
        return array('attachment_id' => Sabai_Model::KEY_TYPE_INT, 'attachment_created' => Sabai_Model::KEY_TYPE_INT, 'attachment_updated' => Sabai_Model::KEY_TYPE_INT, 'attachment_file_id' => Sabai_Model::KEY_TYPE_INT, 'attachment_topic_id' => Sabai_Model::KEY_TYPE_INT, 'attachment_comment_id' => Sabai_Model::KEY_TYPE_INT);
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sattachment WHERE attachment_id = %d',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $id
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sattachment WHERE attachment_id IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(',', array_map('intval', $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$sattachment WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery($values)
    {
        $values['attachment_created'] = time();
        $values['attachment_updated'] = 0;
        return sprintf("INSERT INTO %sattachment(attachment_created, attachment_updated, attachment_file_id, attachment_topic_id, attachment_comment_id) VALUES(%d, %d, %d, %d, %d)", $this->_db->getResourcePrefix(), $values['attachment_created'], $values['attachment_updated'], $values['attachment_file_id'], $values['attachment_topic_id'], $values['attachment_comment_id']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['attachment_updated'];
        $values['attachment_updated'] = time();
        return sprintf("UPDATE %sattachment SET attachment_updated = %d, attachment_file_id = %d, attachment_topic_id = %d, attachment_comment_id = %d WHERE attachment_id = %d AND attachment_updated = %d", $this->_db->getResourcePrefix(), $values['attachment_updated'], $values['attachment_file_id'], $values['attachment_topic_id'], $values['attachment_comment_id'], $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$sattachment WHERE attachment_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['attachment_updated'] = 'attachment_updated=' . time();
        return sprintf('UPDATE %sattachment SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(',', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE FROM %1$sattachment WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$sattachment WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _afterInsertTrigger1($id, $new)
    {
        if (!empty($new['attachment_topic_id'])) {
            $this->_db->exec(sprintf('UPDATE %stopic SET topic_attachment_count = topic_attachment_count + 1, topic_attachment_last = %d, topic_attachment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $id, $new['attachment_created'], $new['attachment_topic_id']));
        }
        if (!empty($new['attachment_comment_id'])) {
            $this->_db->exec(sprintf('UPDATE %scomment SET comment_attachment_count = comment_attachment_count + 1, comment_attachment_last = %d, comment_attachment_lasttime = %d WHERE comment_id = %d', $this->_db->getResourcePrefix(), $id, $new['attachment_created'], $new['attachment_comment_id']));
        }
    }

    protected function _afterDeleteTrigger1($id, $old)
    {
        if (!empty($old['attachment_topic_id'])) {
            $sql = sprintf('SELECT attachment_id, attachment_created FROM %sattachment WHERE attachment_topic_id = %d ORDER BY attachment_created DESC', $this->_db->getResourcePrefix(), $old['attachment_topic_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_attachment_count = topic_attachment_count - 1, topic_attachment_last = %d, topic_attachment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $row['attachment_id'], $row['attachment_created'], $old['attachment_topic_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_attachment_count = topic_attachment_count - 1, topic_attachment_last = 0, topic_attachment_lasttime = topic_created WHERE topic_id = %d', $this->_db->getResourcePrefix(), $old['attachment_topic_id']));
            }
        }
        if (!empty($old['attachment_comment_id'])) {
            $sql = sprintf('SELECT attachment_id, attachment_created FROM %sattachment WHERE attachment_comment_id = %d ORDER BY attachment_created DESC', $this->_db->getResourcePrefix(), $old['attachment_comment_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %scomment SET comment_attachment_count = comment_attachment_count - 1, comment_attachment_last = %d, comment_attachment_lasttime = %d WHERE comment_id = %d', $this->_db->getResourcePrefix(), $row['attachment_id'], $row['attachment_created'], $old['attachment_comment_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %scomment SET comment_attachment_count = comment_attachment_count - 1, comment_attachment_last = 0, comment_attachment_lasttime = comment_created WHERE comment_id = %d', $this->_db->getResourcePrefix(), $old['attachment_comment_id']));
            }
        }
    }

    protected function _afterUpdateTrigger1($id, $new, $old)
    {
        if (empty($old['attachment_topic_id']) && !empty($new['attachment_topic_id'])) {
            $this->_db->exec(sprintf('UPDATE %stopic SET topic_attachment_count = topic_attachment_count + 1, topic_attachment_last = %d, topic_attachment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $id, $new['attachment_created'], $new['attachment_topic_id']));
        } elseif (!empty($old['attachment_topic_id']) && empty($new['attachment_topic_id'])) {
            $sql = sprintf('SELECT attachment_id, attachment_created FROM %sattachment WHERE attachment_topic_id = %d ORDER BY attachment_created DESC', $this->_db->getResourcePrefix(), $old['attachment_topic_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_attachment_count = topic_attachment_count - 1, topic_attachment_last = %d, topic_attachment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $row['attachment_id'], $row['attachment_created'], $old['attachment_topic_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_attachment_count = topic_attachment_count - 1, topic_attachment_last = 0, topic_attachment_lasttime = topic_created WHERE topic_id = %d', $this->_db->getResourcePrefix(), $old['attachment_topic_id']));
            }
        } elseif ($old['attachment_topic_id'] != $new['attachment_topic_id']) {
            $sql = sprintf('SELECT attachment_id, attachment_created FROM %sattachment WHERE attachment_topic_id = %d ORDER BY attachment_created DESC', $this->_db->getResourcePrefix(), $old['attachment_topic_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_attachment_count = topic_attachment_count - 1, topic_attachment_last = %d, topic_attachment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $row['attachment_id'], $row['attachment_created'], $old['attachment_topic_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %stopic SET topic_attachment_count = topic_attachment_count - 1, topic_attachment_last = 0, topic_attachment_lasttime = topic_created WHERE topic_id = %d', $this->_db->getResourcePrefix(), $old['attachment_topic_id']));
            }
            $this->_db->exec(sprintf('UPDATE %stopic SET topic_attachment_count = topic_attachment_count + 1, topic_attachment_last = %d, topic_attachment_lasttime = %d WHERE topic_id = %d', $this->_db->getResourcePrefix(), $id, $new['attachment_created'], $new['attachment_topic_id']));
        }
        if (empty($old['attachment_comment_id']) && !empty($new['attachment_comment_id'])) {
            $this->_db->exec(sprintf('UPDATE %scomment SET comment_attachment_count = comment_attachment_count + 1, comment_attachment_last = %d, comment_attachment_lasttime = %d WHERE comment_id = %d', $this->_db->getResourcePrefix(), $id, $new['attachment_created'], $new['attachment_comment_id']));
        } elseif (!empty($old['attachment_comment_id']) && empty($new['attachment_comment_id'])) {
            $sql = sprintf('SELECT attachment_id, attachment_created FROM %sattachment WHERE attachment_comment_id = %d ORDER BY attachment_created DESC', $this->_db->getResourcePrefix(), $old['attachment_comment_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %scomment SET comment_attachment_count = comment_attachment_count - 1, comment_attachment_last = %d, comment_attachment_lasttime = %d WHERE comment_id = %d', $this->_db->getResourcePrefix(), $row['attachment_id'], $row['attachment_created'], $old['attachment_comment_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %scomment SET comment_attachment_count = comment_attachment_count - 1, comment_attachment_last = 0, comment_attachment_lasttime = comment_created WHERE comment_id = %d', $this->_db->getResourcePrefix(), $old['attachment_comment_id']));
            }
        } elseif ($old['attachment_comment_id'] != $new['attachment_comment_id']) {
            $sql = sprintf('SELECT attachment_id, attachment_created FROM %sattachment WHERE attachment_comment_id = %d ORDER BY attachment_created DESC', $this->_db->getResourcePrefix(), $old['attachment_comment_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %scomment SET comment_attachment_count = comment_attachment_count - 1, comment_attachment_last = %d, comment_attachment_lasttime = %d WHERE comment_id = %d', $this->_db->getResourcePrefix(), $row['attachment_id'], $row['attachment_created'], $old['attachment_comment_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %scomment SET comment_attachment_count = comment_attachment_count - 1, comment_attachment_last = 0, comment_attachment_lasttime = comment_created WHERE comment_id = %d', $this->_db->getResourcePrefix(), $old['attachment_comment_id']));
            }
            $this->_db->exec(sprintf('UPDATE %scomment SET comment_attachment_count = comment_attachment_count + 1, comment_attachment_last = %d, comment_attachment_lasttime = %d WHERE comment_id = %d', $this->_db->getResourcePrefix(), $id, $new['attachment_created'], $new['attachment_comment_id']));
        }
    }

    protected function _afterInsertTrigger($id, $new)
    {
        $this->_afterInsertTrigger1($id, $new);
    }

    protected function _afterUpdateTrigger($id, $new, $old)
    {
        $this->_afterUpdateTrigger1($id, $new, $old);
    }

    protected function _afterDeleteTrigger($id, $old)
    {
        $this->_afterDeleteTrigger1($id, $old);
    }
}