<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
pluginsy/Xigg/Model/TrackbackGateway.php
*/
abstract class Plugg_Xigg_Model_Base_TrackbackGateway extends Sabai_Model_Gateway
{
    public function getName()
    {
        return 'trackback';
    }

    public function getFields()
    {
        return array('trackback_id' => Sabai_Model::KEY_TYPE_INT, 'trackback_created' => Sabai_Model::KEY_TYPE_INT, 'trackback_updated' => Sabai_Model::KEY_TYPE_INT, 'trackback_title' => Sabai_Model::KEY_TYPE_VARCHAR, 'trackback_excerpt' => Sabai_Model::KEY_TYPE_TEXT, 'trackback_url' => Sabai_Model::KEY_TYPE_VARCHAR, 'trackback_blog_name' => Sabai_Model::KEY_TYPE_VARCHAR, 'trackback_node_id' => Sabai_Model::KEY_TYPE_INT_NULL);
    }

    protected function _getSelectByIdQuery($id, array $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t.', $fields);
        return sprintf('SELECT t.%s FROM %strackback t WHERE trackback_id = %d', $fields, $this->_db->getResourcePrefix(), $id);
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, array $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t.', $fields);
        return sprintf('SELECT t.%1$s FROM %2$strackback t WHERE %3$s', $fields, $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getInsertQuery(array $values)
    {
        $values['trackback_created'] = time();
        $values['trackback_updated'] = 0;
        $values['trackback_node_id'] = !empty($values['trackback_node_id']) ? intval($values['trackback_node_id']) : 'NULL';
        return sprintf("INSERT INTO %strackback(trackback_created, trackback_updated, trackback_title, trackback_excerpt, trackback_url, trackback_blog_name, trackback_node_id) VALUES(%d, %d, %s, %s, %s, %s, %s)", $this->_db->getResourcePrefix(), $values['trackback_created'], $values['trackback_updated'], $this->_db->escapeString($values['trackback_title']), $this->_db->escapeString($values['trackback_excerpt']), $this->_db->escapeString($values['trackback_url']), $this->_db->escapeString($values['trackback_blog_name']), $values['trackback_node_id']);
    }

    protected function _getUpdateQuery($id, array $values)
    {
        $values['trackback_node_id'] = !empty($values['trackback_node_id']) ? intval($values['trackback_node_id']) : 'NULL';
        $last_update = $values['trackback_updated'];
        $values['trackback_updated'] = time();
        return sprintf("UPDATE %strackback SET trackback_updated = %d, trackback_title = %s, trackback_excerpt = %s, trackback_url = %s, trackback_blog_name = %s, trackback_node_id = %s WHERE trackback_id = %d AND trackback_updated = %d", $this->_db->getResourcePrefix(), $values['trackback_updated'], $this->_db->escapeString($values['trackback_title']), $this->_db->escapeString($values['trackback_excerpt']), $this->_db->escapeString($values['trackback_url']), $this->_db->escapeString($values['trackback_blog_name']), $values['trackback_node_id'], $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$strackback WHERE trackback_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, array $sets)
    {
        $sets['trackback_updated'] = 'trackback_updated=' . time();
        return sprintf('UPDATE %strackback SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(',', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE FROM %1$strackback WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$strackback WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _afterInsertTrigger1($id, array $new)
    {
        if (!empty($new['trackback_node_id'])) {
            $this->_db->exec(sprintf('UPDATE %snode SET node_trackback_count = node_trackback_count + 1, node_trackback_last = %d, node_trackback_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $id, $new['trackback_created'], $new['trackback_node_id']));
        }
    }

    protected function _afterDeleteTrigger1($id, array $old)
    {
        if (!empty($old['trackback_node_id'])) {
            $sql = sprintf('SELECT trackback_id, trackback_created FROM %strackback WHERE trackback_node_id = %d ORDER BY trackback_created DESC', $this->_db->getResourcePrefix(), $old['trackback_node_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %snode SET node_trackback_count = node_trackback_count - 1, node_trackback_last = %d, node_trackback_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $row['trackback_id'], $row['trackback_created'], $old['trackback_node_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %snode SET node_trackback_count = node_trackback_count - 1, node_trackback_last = 0, node_trackback_lasttime = node_created WHERE node_id = %d', $this->_db->getResourcePrefix(), $old['trackback_node_id']));
            }
        }
    }

    protected function _afterUpdateTrigger1($id, array $new, array $old)
    {
        if (empty($old['trackback_node_id']) && !empty($new['trackback_node_id'])) {
            $this->_db->exec(sprintf('UPDATE %snode SET node_trackback_count = node_trackback_count + 1, node_trackback_last = %d, node_trackback_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $id, $new['trackback_created'], $new['trackback_node_id']));
        } elseif (!empty($old['trackback_node_id']) && empty($new['trackback_node_id'])) {
            $sql = sprintf('SELECT trackback_id, trackback_created FROM %strackback WHERE trackback_node_id = %d ORDER BY trackback_created DESC', $this->_db->getResourcePrefix(), $old['trackback_node_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %snode SET node_trackback_count = node_trackback_count - 1, node_trackback_last = %d, node_trackback_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $row['trackback_id'], $row['trackback_created'], $old['trackback_node_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %snode SET node_trackback_count = node_trackback_count - 1, node_trackback_last = 0, node_trackback_lasttime = node_created WHERE node_id = %d', $this->_db->getResourcePrefix(), $old['trackback_node_id']));
            }
        } elseif ($old['trackback_node_id'] != $new['trackback_node_id']) {
            $sql = sprintf('SELECT trackback_id, trackback_created FROM %strackback WHERE trackback_node_id = %d ORDER BY trackback_created DESC', $this->_db->getResourcePrefix(), $old['trackback_node_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %snode SET node_trackback_count = node_trackback_count - 1, node_trackback_last = %d, node_trackback_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $row['trackback_id'], $row['trackback_created'], $old['trackback_node_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %snode SET node_trackback_count = node_trackback_count - 1, node_trackback_last = 0, node_trackback_lasttime = node_created WHERE node_id = %d', $this->_db->getResourcePrefix(), $old['trackback_node_id']));
            }
            $this->_db->exec(sprintf('UPDATE %snode SET node_trackback_count = node_trackback_count + 1, node_trackback_last = %d, node_trackback_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $id, $new['trackback_created'], $new['trackback_node_id']));
        }
    }

    protected function _afterInsertTrigger($id, array $new)
    {
        $this->_afterInsertTrigger1($id, $new);
    }

    protected function _afterUpdateTrigger($id, array $new, array $old)
    {
        $this->_afterUpdateTrigger1($id, $new, $old);
    }

    protected function _afterDeleteTrigger($id, array $old)
    {
        $this->_afterDeleteTrigger1($id, $old);
    }
}