<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
plugins/Xigg/Model/Node.php
*/
abstract class Plugg_Xigg_Model_Base_Node extends Sabai_Model_Entity
{
    public function __construct(Sabai_Model $model)
    {
        parent::__construct('Node', $model);
        $this->_vars = array('node_id' => 0, 'node_created' => 0, 'node_updated' => 0, 'node_title' => null, 'node_source' => null, 'node_source_title' => null, 'node_body_filter_id' => 0, 'node_body' => null, 'node_body_html' => null, 'node_teaser_filter_id' => 0, 'node_teaser' => null, 'node_teaser_html' => null, 'node_published' => 0, 'node_allow_comments' => 1, 'node_allow_trackbacks' => 1, 'node_allow_edit' => 1, 'node_status' => 0, 'node_hidden' => 0, 'node_priority' => 0, 'node_views' => 0, 'node_category_id' => null, 'node_userid' => null, 'node_comment_count' => 0, 'node_comment_last' => 0, 'node_comment_lasttime' => 0, 'node_trackback_count' => 0, 'node_trackback_last' => 0, 'node_trackback_lasttime' => 0, 'node_vote_count' => 0, 'node_vote_last' => 0, 'node_vote_lasttime' => 0, 'node_view_count' => 0, 'node_view_last' => 0, 'node_view_lasttime' => 0);
    }

    public function getUserId()
    {
        return $this->getVar('userid');
    }

    public function assignUser($user)
    {
        $this->_setVar('userid', $user->getId());
    }

    protected function _fetchUser($withData = false)
    {
        if (!isset($this->_objects['User'])) {
            $user_id = $this->getUserId();
            $identities = $this->_model->fetchUserIdentities(array($user_id), $withData);
            $this->_objects['User'] = $identities[$user_id];
        }
        return $this->_objects['User'];
    }

    public function isOwnedBy($user)
    {
        return $this->getUserId() == $user->getId();
    }

    public function getId()
    {
        return $this->getVar('id');
    }

    public function setId($value)
    {
        $this->setVar('id', $value);
    }

    public function getTimeCreated()
    {
        return $this->getVar('created');
    }

    public function getTimeUpdated()
    {
        return $this->getVar('updated');
    }

    public function getLabel()
    {
        return $this->getVar('title');
    }


    public function getCommentCount()
    {
        return $this->getVar('comment_count');
    }

    public function hasLastComment()
    {
        $last_id = $this->getVar('comment_last');
        return !empty($last_id);
    }

    public function getTrackbackCount()
    {
        return $this->getVar('trackback_count');
    }

    public function hasLastTrackback()
    {
        $last_id = $this->getVar('trackback_last');
        return !empty($last_id);
    }

    public function getVoteCount()
    {
        return $this->getVar('vote_count');
    }

    public function hasLastVote()
    {
        $last_id = $this->getVar('vote_last');
        return !empty($last_id);
    }

    public function getViewCount()
    {
        return $this->getVar('view_count');
    }

    public function hasLastView()
    {
        $last_id = $this->getVar('view_last');
        return !empty($last_id);
    }

    public function assignCategory(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'Category') return false;

        return $this->_assignEntity($entity, 'category_id');
    }

    public function unassignCategory()
    {
        return $this->_unassignEntity('Category', 'category_id');
    }

    protected function _fetchCategory()
    {
        return $this->_fetchEntity('Category', 'category_id');
    }

    public function addComment(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'Comment') return false;

        return $this->_addEntity($entity);
    }

    public function removeComment(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'Comment') return;

        return $this->removeCommentById($entity->getId());
    }

    public function removeCommentById($id)
    {
        return $this->_removeEntityById('comment_id', 'Comment', $id);
    }

    public function createComment()
    {
        return $this->_createEntity('Comment');
    }

    protected function _fetchComments($limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchEntities('Comment', $limit, $offset, $sort, $order);
    }

    protected function _fetchLastComment()
    {
        if (!isset($this->_objects['LastComment']) && $this->hasLastComment()) {
            $this->_objects['LastComment'] = $this->_fetchEntities('Comment', 1, 0, 'comment_created', 'DESC')->getNext();
        }
        return $this->_objects['LastComment'];
    }

    public function paginateComments($perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateEntities('Comment', $perpage, $sort, $order);
    }

    public function removeComments()
    {
        return $this->_removeEntities('Comment');
    }

    public function countComments()
    {
        return $this->_countEntities('Comment');
    }

    public function addTrackback(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'Trackback') return false;

        return $this->_addEntity($entity);
    }

    public function removeTrackback(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'Trackback') return;

        return $this->removeTrackbackById($entity->getId());
    }

    public function removeTrackbackById($id)
    {
        return $this->_removeEntityById('trackback_id', 'Trackback', $id);
    }

    public function createTrackback()
    {
        return $this->_createEntity('Trackback');
    }

    protected function _fetchTrackbacks($limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchEntities('Trackback', $limit, $offset, $sort, $order);
    }

    protected function _fetchLastTrackback()
    {
        if (!isset($this->_objects['LastTrackback']) && $this->hasLastTrackback()) {
            $this->_objects['LastTrackback'] = $this->_fetchEntities('Trackback', 1, 0, 'trackback_created', 'DESC')->getNext();
        }
        return $this->_objects['LastTrackback'];
    }

    public function paginateTrackbacks($perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateEntities('Trackback', $perpage, $sort, $order);
    }

    public function removeTrackbacks()
    {
        return $this->_removeEntities('Trackback');
    }

    public function countTrackbacks()
    {
        return $this->_countEntities('Trackback');
    }

    public function addVote(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'Vote') return false;

        return $this->_addEntity($entity);
    }

    public function removeVote(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'Vote') return;

        return $this->removeVoteById($entity->getId());
    }

    public function removeVoteById($id)
    {
        return $this->_removeEntityById('vote_id', 'Vote', $id);
    }

    public function createVote()
    {
        return $this->_createEntity('Vote');
    }

    protected function _fetchVotes($limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchEntities('Vote', $limit, $offset, $sort, $order);
    }

    protected function _fetchLastVote()
    {
        if (!isset($this->_objects['LastVote']) && $this->hasLastVote()) {
            $this->_objects['LastVote'] = $this->_fetchEntities('Vote', 1, 0, 'vote_created', 'DESC')->getNext();
        }
        return $this->_objects['LastVote'];
    }

    public function paginateVotes($perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateEntities('Vote', $perpage, $sort, $order);
    }

    public function removeVotes()
    {
        return $this->_removeEntities('Vote');
    }

    public function countVotes()
    {
        return $this->_countEntities('Vote');
    }

    public function addView(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'View') return false;

        return $this->_addEntity($entity);
    }

    public function removeView(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'View') return;

        return $this->removeViewById($entity->getId());
    }

    public function removeViewById($id)
    {
        return $this->_removeEntityById('view_id', 'View', $id);
    }

    public function createView()
    {
        return $this->_createEntity('View');
    }

    protected function _fetchViews($limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchEntities('View', $limit, $offset, $sort, $order);
    }

    protected function _fetchLastView()
    {
        if (!isset($this->_objects['LastView']) && $this->hasLastView()) {
            $this->_objects['LastView'] = $this->_fetchEntities('View', 1, 0, 'view_created', 'DESC')->getNext();
        }
        return $this->_objects['LastView'];
    }

    public function paginateViews($perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateEntities('View', $perpage, $sort, $order);
    }

    public function removeViews()
    {
        return $this->_removeEntities('View');
    }

    public function countViews()
    {
        return $this->_countEntities('View');
    }

    public function linkTag(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() == 'Tag') return $this->linkTagById($entity->getId());

        return false;
    }

    public function linkTagById($id)
    {
        return $this->_linkEntityById('Node2tag', 'tag_id', $id);
    }

    public function unlinkTag(Sabai_Model_entity $entity)
    {
        if ($entity->getName() != 'Tag') return 0;

        return $this->unlinkTagById($entity->getId());
    }

    public function unlinkTagById($id)
    {
        return $this->_unlinkEntityById('Node2tag', 'node2tag_node_id', 'node2tag_tag_id', $id);
    }

    public function unlinkTags()
    {
        return $this->_unlinkEntities('Node2tag');
    }

    protected function _fetchTags($limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchEntities('Tag', $limit, $offset, $sort, $order);
    }

    public function paginateTags($perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateEntities('Tag', $perpage, $sort, $order);
    }

    public function countTags()
    {
        return $this->_countEntities('Tag');
    }

    protected function _getVar($name)
    {
        return $this->_vars['node_' . $name];
    }

    protected function _setVar($name, $value)
    {
        switch ($name) {
        case 'id':
            $this->_vars['node_id'] = $value;
            break;
        case 'title':
            $this->_vars['node_title'] = trim($value);
            break;
        case 'source':
            $this->_vars['node_source'] = trim($value);
            break;
        case 'source_title':
            $this->_vars['node_source_title'] = trim($value);
            break;
        case 'body_filter_id':
            $this->_vars['node_body_filter_id'] = $value;
            break;
        case 'body':
            $this->_vars['node_body'] = trim($value);
            break;
        case 'body_html':
            $this->_vars['node_body_html'] = trim($value);
            break;
        case 'teaser_filter_id':
            $this->_vars['node_teaser_filter_id'] = $value;
            break;
        case 'teaser':
            $this->_vars['node_teaser'] = trim($value);
            break;
        case 'teaser_html':
            $this->_vars['node_teaser_html'] = trim($value);
            break;
        case 'published':
            $this->_vars['node_published'] = $value;
            break;
        case 'allow_comments':
            $this->_vars['node_allow_comments'] = $value;
            break;
        case 'allow_trackbacks':
            $this->_vars['node_allow_trackbacks'] = $value;
            break;
        case 'allow_edit':
            $this->_vars['node_allow_edit'] = $value;
            break;
        case 'status':
            $this->_vars['node_status'] = $value;
            break;
        case 'hidden':
            $this->_vars['node_hidden'] = $value;
            break;
        case 'priority':
            $this->_vars['node_priority'] = $value;
            break;
        case 'views':
            $this->_vars['node_views'] = $value;
            break;
        case 'category_id':
            $this->_vars['node_category_id'] = $value;
            break;
        case 'userid':
            $this->_vars['node_userid'] = trim($value);
            break;
        case 'comment_lasttime':
            $this->_vars['node_comment_lasttime'] = $value;
            break;
        case 'trackback_lasttime':
            $this->_vars['node_trackback_lasttime'] = $value;
            break;
        case 'vote_lasttime':
            $this->_vars['node_vote_lasttime'] = $value;
            break;
        case 'view_lasttime':
            $this->_vars['node_view_lasttime'] = $value;
            break;
        default:
            trigger_error(sprintf('Error trying to set value for variable %s. This variable is either read-only or does not exist for this entity', $name), E_USER_WARNING);
            return false;
        }
        return true;
    }

    protected function _get($name, $sort, $order)
    {
        switch ($name) {
        case 'title':
            return $this->getVar('title');
        case 'source':
            return $this->getVar('source');
        case 'source_title':
            return $this->getVar('source_title');
        case 'body_filter_id':
            return $this->getVar('body_filter_id');
        case 'body':
            return $this->getVar('body');
        case 'body_html':
            return $this->getVar('body_html');
        case 'teaser_filter_id':
            return $this->getVar('teaser_filter_id');
        case 'teaser':
            return $this->getVar('teaser');
        case 'teaser_html':
            return $this->getVar('teaser_html');
        case 'published':
            return $this->getVar('published');
        case 'allow_comments':
            return $this->getVar('allow_comments');
        case 'allow_trackbacks':
            return $this->getVar('allow_trackbacks');
        case 'allow_edit':
            return $this->getVar('allow_edit');
        case 'status':
            return $this->getVar('status');
        case 'hidden':
            return $this->getVar('hidden');
        case 'priority':
            return $this->getVar('priority');
        case 'views':
            return $this->getVar('views');
        case 'Category':
            return $this->_fetchCategory();
        case 'Comments':
            return $this->_fetchComments(0, 0, $sort, $order);
        case 'LastComment':
            return $this->_fetchLastComment();
        case 'Trackbacks':
            return $this->_fetchTrackbacks(0, 0, $sort, $order);
        case 'LastTrackback':
            return $this->_fetchLastTrackback();
        case 'Votes':
            return $this->_fetchVotes(0, 0, $sort, $order);
        case 'LastVote':
            return $this->_fetchLastVote();
        case 'Views':
            return $this->_fetchViews(0, 0, $sort, $order);
        case 'LastView':
            return $this->_fetchLastView();
        case 'Tags':
            return $this->_fetchTags(0, 0, $sort, $order);
        case 'User':
            return $this->_fetchUser();
        case 'UserWithData':
            return $this->_fetchUser(true);
        }
    }

    public function __set($name, $value)
    {
        switch ($name) {
        case 'title':
            $this->setVar('title', $value);
            break;
        case 'source':
            $this->setVar('source', $value);
            break;
        case 'source_title':
            $this->setVar('source_title', $value);
            break;
        case 'body_filter_id':
            $this->setVar('body_filter_id', $value);
            break;
        case 'body':
            $this->setVar('body', $value);
            break;
        case 'body_html':
            $this->setVar('body_html', $value);
            break;
        case 'teaser_filter_id':
            $this->setVar('teaser_filter_id', $value);
            break;
        case 'teaser':
            $this->setVar('teaser', $value);
            break;
        case 'teaser_html':
            $this->setVar('teaser_html', $value);
            break;
        case 'published':
            $this->setVar('published', $value);
            break;
        case 'allow_comments':
            $this->setVar('allow_comments', $value);
            break;
        case 'allow_trackbacks':
            $this->setVar('allow_trackbacks', $value);
            break;
        case 'allow_edit':
            $this->setVar('allow_edit', $value);
            break;
        case 'status':
            $this->setVar('status', $value);
            break;
        case 'hidden':
            $this->setVar('hidden', $value);
            break;
        case 'priority':
            $this->setVar('priority', $value);
            break;
        case 'views':
            $this->setVar('views', $value);
            break;
        case 'Category':
            $entity = is_array($value) ? $value[0] : $value;
            $this->assignCategory($entity);
            break;
        case 'Comments':
            $this->removeComments();
            foreach (array_keys($value) as $i) {
                $this->addComment($value[$i]);
            }
            break;
        case 'Trackbacks':
            $this->removeTrackbacks();
            foreach (array_keys($value) as $i) {
                $this->addTrackback($value[$i]);
            }
            break;
        case 'Votes':
            $this->removeVotes();
            foreach (array_keys($value) as $i) {
                $this->addVote($value[$i]);
            }
            break;
        case 'Views':
            $this->removeViews();
            foreach (array_keys($value) as $i) {
                $this->addView($value[$i]);
            }
            break;
        case 'Tags':
            $this->unlinkTags();
            foreach (array_keys($value) as $i) {
                if (is_object($value[$i])) {
                    $this->linkTag($value[$i]);
                } else {
                    $this->linkTagById($value[$i]);
                }
            }
            break;
        }
    }

    public function initVar($name, $value)
    {
        switch ($name) {
        default:
            $this->_vars[$name] = $value;
            break;
        }
    }
}

abstract class Plugg_Xigg_Model_Base_NodeRepository extends Sabai_Model_EntityRepository
{
    public function __construct(Sabai_Model $model)
    {
        parent::__construct('Node', $model);
    }
    public function fetchByUser($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('node_userid', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByUser($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('User', $id, $perpage, $sort, $order);
    }

    public function countByUser($id)
    {
        return $this->_countByForeign('node_userid', $id);
    }

    public function fetchByUserAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('node_userid', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByUserAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('User', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByUserAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('node_userid', $id, $criteria);
    }

    public function fetchByCategory($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('node_category_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByCategory($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('Category', $id, $perpage, $sort, $order);
    }

    public function countByCategory($id)
    {
        return $this->_countByForeign('node_category_id', $id);
    }

    public function fetchByCategoryAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('node_category_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByCategoryAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('Category', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByCategoryAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('node_category_id', $id, $criteria);
    }

    public function fetchByTag($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByAssoc('node', 'Node2tag', 'node2tag_tag_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByTag($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('Tag', $id, $perpage, $sort, $order);
    }

    public function countByTag($id)
    {
        return $this->_countByAssoc('node_id', 'Node2tag', 'node2tag_tag_id', $id);
    }

    public function fetchByTagAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByAssocAndCriteria('node', 'Node2tag', 'node2tag_tag_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function countByTagAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByAssocAndCriteria('node_id', 'Node2tag', 'node2tag_tag_id', $id, $criteria);
    }

    public function paginateByTagAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('Tag', $id, $criteria, $perpage, $sort, $order);
    }

    protected function _getCollectionByRowset(Sabai_DB_Rowset $rs)
    {
        return new Plugg_Xigg_Model_Base_NodesByRowset($rs, $this->_model->create('Node'), $this->_model);
    }

    public function createCollection(array $entities = array())
    {
        return new Plugg_Xigg_Model_Base_Nodes($this->_model, $entities);
    }
}

class Plugg_Xigg_Model_Base_NodesByRowset extends Sabai_Model_EntityCollection_Rowset
{
    public function __construct(Sabai_DB_Rowset $rs, Sabai_Model_Entity $emptyEntity, Sabai_Model $model)
    {
        parent::__construct('Nodes', $rs, $emptyEntity, $model);
    }

    protected function _loadRow(Sabai_Model_Entity $entity, array $row)
    {
        $entity->initVars($row);
    }
}

class Plugg_Xigg_Model_Base_Nodes extends Sabai_Model_EntityCollection_Array
{
    public function __construct(Sabai_Model $model, array $entities = array())
    {
        parent::__construct($model, 'Nodes', $entities);
    }
}