<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_SubmitCommentReplyForm extends Plugg_FormController
{
    private $_comment;
    private $_node;
    private $_reply;

    protected function _init(Sabai_Application_Context $context)
    {
        if (!$comment_id = $context->request->getAsInt('comment_id', false)) {
            return false;
        }
        if (!$this->_comment = $context->plugin->getModel()->Comment->fetchById($comment_id)) {
            return false;
        }
        $this->_node = $this->_comment->Node;
        if (!$this->_node->allow_comments || !$this->_node->isReadable($context->user)) {
            $context->response->setError($context->plugin->_('Comments not allowed for this news article'), array(
                'path' => '/' . $this->_node->getId(),
                'params' => array('comment_id' => $this->_comment->getId()),
                'fragment' => 'comment' . $this->_comment->getId()
            ));
            return false;
        }
        $this->_reply = $this->_node->createComment();

        return true;
    }

    protected function _confirmForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_reply->applyForm($form);
        $this->_reply->setVar('parent', $this->_comment->getId());
        $this->_reply->assignUser($context->user);
    }

    protected function _submitForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggSubmitCommentForm', array($context, $form, /*$isReply*/ true));
        $this->_reply->applyForm($form);
        $this->_reply->setVar('parent', $this->_comment->getId());
        $this->_reply->assignUser($context->user);
        $this->_reply->markNew();
        $this->pluginManager->dispatch('XiggSubmitComment', array($context, $this->_reply, /*$isReply*/ true));
        if ($this->_reply->commit()) {
            $context->response->setSuccess(sprintf($context->plugin->_('Reply to comment #%d posted successfully'), $this->_comment->getId()), array(
                'path' => '/' . $this->_node->getId(),
                'params' => array('comment_id' => $this->_reply->getId()),
                'fragment' => 'comment' . $this->_reply->getId()
            ));
            $this->pluginManager->dispatch('XiggSubmitCommentSuccess', array($context, $this->_node, $this->_reply, /*$isEdit*/ false));
            return true;
        }

        return false;
    }

    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggShowCommentForm', array($context, $form, /*$isReply*/ true));
        $context->response->setPageInfo($this->_node->title, array('path' => '/' . $this->_node->getId()));
        $context->response->setPageInfo($context->plugin->_('Submit comment'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        $form = $this->_reply->toHTMLQuickForm();
        $form->removeElements(array('Node', 'body_html', 'allow_edit'));
        $comment_title = trim($this->_comment->title);
        $form->setDefaults(array(
            'title' => !preg_match('/^Re:/i', $comment_title) ? 'Re: ' . $comment_title : $comment_title,
            'body' => "\n\n" . strtr("\n" . $this->_comment->body, array("\n>" => "\n>>", "\n" => "\n> "))
            //'body' => sprintf('<blockquote cite="%s" title="%s">%s</blockquote>', $this->url->create(array('path' => '/comment/' . $this->_comment->getId())), h($comment_title), "\n" . $this->_comment->body . "\n"),
        ));
        return $form;
    }
}