<?php
class Plugg_Xigg_Main_Node_SubmitVote extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        if (!$context->request->isPost()) {
            $context->response->setError($context->plugin->_('Invalid request method'));
            return;
        }
        require_once 'Sabai/Token.php';
        if ((!$token_value = $context->request->getAsStr(SABAI_TOKEN_NAME, false)) ||
            (!$node_id = $context->request->getAsInt('node_id', false))
        ) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }
        if (!Sabai_Token::validate($token_value, 'Vote_submit_' . $node_id)) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }
        if (!$node = $this->_parent->getNodeById($context, 'node_id')) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }
        $model = $context->plugin->getModel();
        $user_ip = getip();
        if ($context->user->isAuthenticated()) {
            if ($user_ip) {
                $criteria = $model->createCriteria('Vote')
                    ->userid_is($context->user->getId())
                    ->ip_is($user_ip);
                $user_vote_count = $model->Vote->countByNodeAndCriteria($node_id, $criteria);
            } else {
                $user_vote_count = $model->Vote->countByNodeAndUser($node_id, $context->user);
            }
        } else {
            if (!$user_ip) {
                $context->response->setError($context->plugin->_('Invalid IP address. Guest votes require a valid IP address'), array(
                    'path' => '/' . $node->getId()
                ));
                return;
            }
            $criteria = $model->createCriteria('Vote')->ip_is($user_ip);
            $user_vote_count = $model->Vote->countByNodeAndCriteria($node_id, $criteria);
        }
        if (!empty($user_vote_count)) {
            $context->response->setError($context->plugin->_('Already voted'), array(
                'path' => '/' . $node->getId()
            ));
            return;
        }
        $vote = $node->createVote();
        $vote->assignUser($context->user);
        if ($user_ip) {
            $vote->set('ip', $user_ip);
        }
        $vote->set('score', 1);
        $vote->markNew();
        if (!$vote->commit()) {
            $context->response->setError($context->plugin->_('Failed operation'), array(
                'path' => '/' . $node->getId()
            ));
            return;
        }
        // reload node
        if (!$node = $this->_parent->getNodeById($context, 'node_id', true)) {
            $context->response->setError($context->plugin->_('An error occurred'));
            return;
        }
        $node_votes = $node->getVoteCount();
        $msg = $context->request->getAsBool('echo', false) ? $node_votes : $context->plugin->_('Voted successfully');
        if (!$node->isPublished()) {
            // make the article published if more than required votes
            if ($node_votes >= $context->plugin->getParam('numberOfVotesForPopular')) {
                $node->publish();
                $node->commit();
            }
        }
        $context->response->setSuccess($msg, array('path' => '/' . $node->getId()));
    }
}