<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_EditCommentForm extends Plugg_FormController
{
    private $_comment;
    
    protected function _init(Sabai_Application_Context $context)
    {
        if (!$comment_id = $context->request->getAsInt('comment_id')) {
            return false;
        }
        if (!$this->_comment = $context->plugin->getModel()->Comment->fetchById($comment_id)) {
            return false;
        }
        if (!$context->user->hasPermission('xigg comment edit any')) {
            if (!$this->_comment->allow_edit) {
                $context->response->setError($context->plugin->_('This comment has been frozen by the administration'), array('path' => '/comment/' . $comment_id));
                return false;
            }
            if (!$this->_comment->isOwnedBy($context->user) ||
                !$context->user->hasPermission('xigg comment edit own')
            ) {
                $context->response->setError($context->plugin->_('Permission denied'), array('path' => '/comment/' . $comment_id));
                return false;
            }
            if (time() > $this->_comment->getTimeCreated() + $context->plugin->getParam('userCommentEditTime')) {
                $context->response->setError($context->plugin->_('Time allowed to edit your comment has expired'), array(
                    'path' => '/' . $this->_comment->getVar('node_id'),
                    'params' => array('comment_id' => $comment_id),
                    'fragment' => 'comment' . $comment_id
                ));
                return false;
            }
        }
        
        return true;
    }
    
    protected function _confirmForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_comment->applyForm($form);
    }
    
    protected function _submitForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggSubmitCommentForm', array($context, $form, /*$isReply*/ false));
        $this->_comment->applyForm($form);
        $this->pluginManager->dispatch('XiggSubmitComment', array($context, $this->_comment, /*$isReply*/ false));
        if ($this->_comment->commit()) {
            $context->response->setSuccess($context->plugin->_('Comment updated successfully'), array(
                'path' => '/' . $this->_comment->Node->getId(),
                'params' => array('comment_id' => $this->_comment->getId()),
                'fragment' => 'comment' . $this->_comment->getId()
            ));
            $this->pluginManager->dispatch('XiggSubmitCommentSuccess', array($context, $this->_comment->Node, $this->_comment, /*$isEdit*/ true));
            return true;
        }
        
        return false;
    }
    
    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggShowCommentForm', array($context, $form, /*$isReply*/ true));
        $context->response->setPageInfo($this->_comment->Node->title, array('path' => '/' . $this->_comment->Node->getId()));
        $context->response->setPageInfo($context->plugin->_('Edit comment'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        $form = $this->_comment->toHTMLQuickForm();
        $form->removeElements(array('Node', 'body_html'));
        if (!$context->user->hasPermission('xigg comment allow edit')) {
            $form->removeElements(array('allow_edit'));
        }

        return $form;
    }
}