<?php
class Plugg_Xigg_Admin_Tag extends Plugg_RoutingController
{
    public function __construct()
    {
        parent::__construct('List', 'Plugg_Xigg_Admin_Tag_', dirname(__FILE__) . '/Tag');
        $this->addControllerFilter(array('Update', 'Delete', 'Details'), '_isValidTagRequested');
    }

    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        $context->response->setCurrentTab('tag');
        $context->response->setPageInfo($context->plugin->_('Tag administration'), array(
            'path' => '/tag'
        ));
        return array(
            'list' => array(
                'controller' => 'List'
            ),
            'submit' => array(
                'controller' => 'Submit'
            ),
            'delete_empty_tags' => array(
                'controller' => 'DeleteEmptyTags'
            ),
            'add' => array(
                'controller' => 'Create'
            ),
            ':tag_id/edit' => array(
                'controller' => 'Update',
                'requirements' => array(
                    ':tag_id' => '\d+'
                )
            ),
            ':tag_id/delete' => array(
                'controller' => 'Delete',
                'requirements' => array(
                    ':tag_id' => '\d+'
                )
            ),
            ':tag_id' => array(
                'controller' => 'Details',
                'requirements' => array(
                    ':tag_id' => '\d+'
                )
            )
        );
    }

    protected function _isValidTagRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        $tag = $this->_parent->isValidEntityRequested($context, 'Tag', 'tag_id');
        $context->response->setPageInfo($tag->name, array(
            'path' => '/tag/' . $tag->getId()
        ));
    }

    protected function _isValidTagRequestedAfterFilter(Sabai_Application_Context $context){}

    public function getRequestedTag(Sabai_Application_Context $context, $entityIdVar = null, $noCache = false)
    {
        return $this->_parent->getRequestedEntity($context, 'Tag', $entityIdVar, $noCache);
    }
}