<?php
require_once 'Plugg/PluginAdmin.php';

class Plugg_Xigg_Admin extends Plugg_PluginAdmin
{
    public function __construct()
    {
        parent::__construct(__CLASS__ . '_', dirname(__FILE__) . '/Admin', 'Node');
    }
    
    function _doGetRoutes(Sabai_Application_Context $context)
    {
        $context->response->addTabs(array(
            'node' => array(
                'title' => $context->plugin->_('Articles'),
            ),
            'category' => array(
                'title' => $context->plugin->_('Categories'),
                'url' => array('path' => '/category')
            ),
            'tag' => array(
                'title' => $context->plugin->_('Tags'),
                'url' => array('path' => '/tag')
            ),
        ));
        return array(
            'node' => array('controller' => 'Node'),
            'category' => array('controller' => 'Category'),
            'tag' => array('controller' => 'Tag')
        );
    }
}