<?php
class Plugg_User_Admin_Widget_Submit extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        $url = array('path' => '/widget');
        if (!$context->request->isPost()) {
            $context->response->setError($context->plugin->_('Invalid request'), $url);
            return;
        }
        if (!$widgets = $context->request->getAsArray('widgets')) {
            $context->response->setError($context->plugin->_('Invalid request'), $url);
            return;
        }
        if (!$token_value = $context->request->getAsStr('_TOKEN', false)) {
            $context->response->setError($context->plugin->_('Invalid request'), $url);
            return;
        }
        require_once 'Sabai/Token.php';
        if (!Sabai_Token::validate($token_value, 'user_admin_widget_submit')) {
            $context->response->setError($context->plugin->_('Invalid request'), $url);
            return;
        }

        $model = $context->plugin->getModel();
        $widgets_current = $model->Widget
            ->criteria()
            ->id_in(array_keys($widgets))
            ->fetch();
        foreach ($widgets_current as $widget) {
            $widget_id = $widget->getId();
            if ($widget->order != $widget_order = intval($widgets[$widget_id]['order'])) {
                $widget->order = $widget_order;
            }
            if ($widget->active) {
                if (empty($widgets[$widget_id]['active'])) $widget->active = 0;
            } else {
                if (!empty($widgets[$widget_id]['active'])) $widget->active = 1;
            }

            // Allow only the public type widget to change its private attribute
            if ($widget->isType(Plugg_User_Plugin::WIDGET_TYPE_PUBLIC)) {
                if ($widget->private) {
                    if (empty($widgets[$widget_id]['private'])) $widget->private = 0;
                } else {
                    if (!empty($widgets[$widget_id]['private'])) $widget->private = 1;
                }
            } else {
                // The widget should always be private so this should not happen..
                if (!$widget->private) $widget->private = 1;
            }

            if (!$widget->isType(Plugg_User_Plugin::WIDGET_TYPE_MINI)) {
                if ($widget->mini) {
                    if (empty($widgets[$widget_id]['mini'])) $widget->mini = 0;
                } else {
                    if (!empty($widgets[$widget_id]['mini'])) $widget->mini = 1;
                }
            } else {
                // The widget should always be mini so this should not happen..
                if (!$widget->mini) $widget->mini = 1;
            }
        }
        if (false === $model->commit()) {
            $context->response->setError($context->plugin->_('An error occurred while updating data.'), $url);
        } else {
            $context->response->setSuccess($context->plugin->_('Data updated successfully.'), $url);
        }
    }
}