<?php
class Plugg_User_Admin_Role extends Plugg_RoutingController
{
    function Plugg_User_Admin_Role()
    {
        parent::__construct('List', 'Plugg_User_Admin_Role_', dirname(__FILE__) . '/Role');
        $this->addControllerFilter(array('Update', 'Delete', 'Details', 'Member'), '_isValidRoleRequested');
        $this->addControllerFilter(array('Update', 'Delete'), '_isRoleEditable');
    }

    function _doGetRoutes(Sabai_Application_Context $context)
    {
        $context->response->setCurrentTab('role');
        $context->response->setPageInfo($context->plugin->_('Roles'), array('path' => '/role'));
        return array(
            'add' => array('controller' => 'Create'),
            ':role_id/edit' => array('controller' => 'Update', 'requirements' => array(':role_id' => '\d+')),
            ':role_id/delete' => array('controller' => 'Delete', 'requirements' => array(':role_id' => '\d+')),
            ':role_id/member' => array('controller' => 'Member', 'requirements' => array(':role_id' => '\d+')),
            ':role_id' => array('controller' => 'Details', 'requirements' => array(':role_id' => '\d+'))
        );
    }

    function _isValidRoleRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        $role = $this->_parent->isValidEntityRequested($context, 'Role', 'role_id');
        $context->response->setPageInfo($role->name, array('path' => '/role/' . $role->getId()));
        $context->response->setVars(array('role' => $role, 'role_id' => $role->getId()));
    }

    function _isValidRoleRequestedAfterFilter(Sabai_Application_Context $context){}

    function _isRoleEditableBeforeFilter(Sabai_Application_Context $context)
    {
        $role = $context->plugin->getModel()->Role->fetchById($context->request->getAsInt('role_id'));
        if ($role->system) {
            $context->response->setError(
                $context->plugin->_('System defined roles may not be edited nor deleted'),
                array('base' => '/system/role')
            );
            $context->response->send($this->_application);
        }
    }

    function _isRoleEditableAfterFilter(Sabai_Application_Context $context){}
}