<?php
require_once 'Sabai/Application/ModelEntityController/Paginate.php';

class Plugg_User_Admin_Autologin_List extends Sabai_Application_ModelEntityController_Paginate
{
    var $_select;
    var $_sortBy = array('expires', 'ASC');

    function __construct()
    {
        $options = array(
            'tplVarPages' => 'autologin_pages',
            'tplVarPageRequested' => 'autologin_page_requested',
            'tplVarEntities' => 'autologins',
            'perpage' => 30
        );
        parent::__construct('Autologin', $options);
    }

    function _getRequestedSort($request)
    {
        if ($sort_by = $request->getAsStr('sortby')) {
            $sort_by = explode(',', $sort_by);
            if (count($sort_by) == 2) {
                $this->_sortBy = $sort_by;
            }
        }
        if ($this->_sortBy[0] == 'expires') {
            return 'expires';
        }
        return array($this->_sortBy[0], 'expires');
    }

    function _getRequestedOrder($request)
    {
        if ($this->_sortBy[0] != 'expires') {
            return array($this->_sortBy[1], 'ASC');
        }
        return $this->_sortBy[1];
    }

    function _onPaginateEntities($entities, Sabai_Application_Context $context)
    {
        $context->response->setVars(array(
            'autologin_requested_select' => $this->_select,
            'autologin_requested_sortby' => implode(',', $this->_sortBy)
        ));
        return $entities->with('User');
    }

    protected function _getModel(Sabai_Application_Context $context)
    {
        return $context->plugin->getModel();
    }
}