<?php
class Plugg_User_Admin_Auth extends Plugg_RoutingController
{
    function Plugg_User_Admin_Auth()
    {
        parent::__construct('List', __CLASS__ . '_', dirname(__FILE__) . '/Auth');
        $this->addControllerFilter(array('Details', 'Authdata'), '_isValidAuthRequested');
    }

    function _doGetRoutes(Sabai_Application_Context $context)
    {
        $context->response->setCurrentTab('auth');
        $routes = array(
            ':auth_id/authdata' => array('controller' => 'Authdata', 'requirements' => array('auth_:id' => '\d+')),
            ':auth_id' => array('controller' => 'Details', 'requirements' => array('auth_:id' => '\d+')),
            'submit' => array('controller' => 'Submit'),
        );
        return $routes;
    }
    
    function _isValidAuthRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        $auth = $this->_parent->isValidEntityRequested($context, 'Auth', 'auth_id');
        $auth_plugin = $this->pluginManager->getPlugin($auth->get('plugin'), false);
        $context->response->setPageInfo($context->plugin->_('Authentications'), array('path' => '/auth'));
        $context->response->setPageInfo($auth->get('name'), array('path' => '/auth/' . $auth->getId()));
        $context->response->setVars(array(
            'auth' => $auth,
            'auth_id' => $auth->getId(),
            'auth_plugin' => $auth_plugin
        ));
    }

    function _isValidAuthRequestedAfterFilter(Sabai_Application_Context $context){}
}