<h3><?php $this->_e('Installed Plugins');?></h3>
<div class="nodesSort">
<?php foreach (array('all' => $this->_('List all'), 'active' => $this->_('List active')) as $select_key => $select_label):?>
<?php   if ($select_key == @$requested_select):?>
  <span class="nodesSortCurrent"><?php _h($select_label);?></span> |
<?php   else:?>
<?php     $this->HTML->linkToRemote($select_label, 'plugg-system-admin-listplugins', array('params' => array('select' => $select_key)));?>
  |
<?php   endif;?>
<?php endforeach;?>
<?php $this->_e('Sort by ');$this->HTML->selectToRemote('sortby', $requested_sortby, 'plugg-system-admin-listplugins', array('priority,DESC' => $this->_('Priority'), 'library,ASC' => $this->_('Plugin library, ascending'), 'library,DESC' => $this->_('Plugin library, descending'), 'name,ASC' => $this->_('Plugin name, ascending'), 'name,DESC' => $this->_('Plugin name, descending')), array('params' => array('select' => $requested_select)), $this->_('Go'), array(), 'plugg-system-admin-listplugins-select');?>
</div>
<table class="horizontal">
  <thead>
    <tr>
      <th>&nbsp;</th>
      <th><?php $this->_e('Name');?></th>
      <th><?php $this->_e('Library');?></th>
      <th><?php $this->_e('Version');?></th>
      <th width="40%"><?php $this->_e('Summary');?></th>
      <th><?php $this->_e('Action');?></th>
    </tr>
  </thead>
  <tfoot>
    <tr>
      <td colspan="6" class="right"><?php //$this->PageNavRemote->write('plugg-system-admin-listplugins', $entity_pages, $entity_page_requested, array('params' => array('sortby' => $requested_sortby, 'select' => $requested_select))));?></td>
    </tr>
  </tfoot>
  <tbody>
<?php if ($entity_objects->count() > 0):?>
<?php   foreach ($entity_objects as $e):?>
<?php     $local_data = @$local_plugins[$e->library];
          $version = $e->version;
          $local_version = @$local_data['version'];
          $has_main = in_array('pluggmainroutes', (array)$local_data['events']);
          $has_admin = in_array('pluggadminroutes', (array)$local_data['events']);
          $upgradeable = version_compare($version, $local_version, '<');
?>
<?php     if ($error = ($e->active && !empty($version) && empty($local_version))):?>
    <tr class="error">
      <td><img src="<?php echo $this->URL->getImageUrl($this->Plugin->getLibrary(), 'plugin_error.gif');?>" alt="<?php $this->_e('Error');?>" /></td>
<?php     elseif ($upgradeable):?>
    <tr class="exclamation">
      <td><img src="<?php echo $this->URL->getImageUrl($this->Plugin->getLibrary(), 'plugin_exclamation.gif');?>" alt="<?php $this->_e('Upgrade');?>" /></td>
<?php     else:?>
<?php       if ($e->active):?>
    <tr>
      <td><img src="<?php echo $this->URL->getImageUrl($this->Plugin->getLibrary(), 'plugin.gif');?>" alt="<?php $this->_e('Active');?>" /></td>
<?php       else:?>
    <tr class="hidden">
      <td><img src="<?php echo $this->URL->getImageUrl($this->Plugin->getLibrary(), 'plugin_disabled.gif');?>" alt="<?php $this->_e('Disabled');?>" /></td>
<?php       endif;?>
<?php     endif;?>
      <td><?php if ($has_main && $e->active):?><?php printf('%s <small>(%s)</small>', sprintf('<a href="%s">%s</a>', $this->URL->create(array('script_alias' => 'main', 'base' => '/' . $e->name)), h($e->name)), h($e->nicename));?><?php elseif ($has_main || $has_admin):?><?php printf('%s <small>(%s)</small>', h($e->name), h($e->nicename));?><?php else:?><?php _h($e->name);?><?php endif;?></td>
      <td><?php _h($e->get('library'));?></td>
      <td><?php _h($version);?></td>
      <td><?php _h(mb_strimlength($local_data['summary'], 0, 150));?><?php if(!$e->isClone() && !empty($plugins_dependency[$e->library])):?><br /><small><?php printf($this->_('required by %s'), implode(', ', array_keys($plugins_dependency[$e->library])));?></small><?php endif;?></td>
      <td>
<?php     if (!$error):?>
<?php       if ($e->active && $has_admin):?>
<?php         $this->HTML->linkTo($this->_('Administer'), array('base' => '/' . $e->name));?>&nbsp;
<?php       endif;?>
<?php       if ($upgradeable):?>
<?php         $this->HTML->linkTo($this->_('Upgrade'), array('path' => '/upgrade/' . $e->name));?>&nbsp;
<?php       elseif (!$error):?>
<?php         $this->HTML->linkTo($this->_('Configure'), array('path' => '/configure/' . $e->name));?>&nbsp;
<?php       endif;?>
<?php       if ($local_data['uninstallable']):?>
<?php         $this->HTML->linkTo($this->_('Uninstall'), array('path' => '/uninstall/' . $e->getId()));?>&nbsp;
<?php       endif;?>
<?php       if ($local_data['cloneable']):?>
<?php         $this->HTML->linkTo($this->_('Clone'), array('path' => '/clone/' . $e->library));?>
<?php       endif;?>
<?php     else:?>
<?php       if (!$e->locked && ($e->isClone() || empty($plugins_dependency[$e->library]))):?>
<?php         $this->HTML->linkTo($this->_('Uninstall'), array('path' => '/uninstall/' . $e->getId()));?>&nbsp;
<?php       endif;?>
<?php     endif;?>
      </td>
    </tr>
<?php   endforeach;
      else:?>
    <tr><td colspan="6"></td></tr>
<?php endif;?>
  </tbody>
</table>

<h3><?php $this->_e('Installable Plugins');?></h3>
<div class="nodesSort">
<?php $this->HTML->linkToRemote($this->_('Refresh'), 'plugg-system-admin-listplugins', array('params' => array('refresh' => 1)));?>
</div>
<table class="horizontal">
  <thead>
    <tr>
      <th>&nbsp;</th>
      <th><?php $this->_e('Name');?></th>
      <th><?php $this->_e('Version');?></th>
      <th width="40%"><?php $this->_e('Summary');?></th>
      <th><?php $this->_e('Action');?></th>
    </tr>
  </thead>
  <tfoot>
    <tr><td colspan="5"></td></tr>
  </tfoot>
    <tbody>
<?php foreach($installable_plugins as $local_name => $local_data):
        $plugins_required_str = '';
        if ($plugins_required = $local_data['dependencies']['plugins']):
          $plugins_required_arr = array();
          foreach ($plugins_required as $p_required):
            $plugins_required_arr[] = $p_required['version'] ? $p_required['library'] . ' ' . $p_required['version'] : $p_required['library'];
          endforeach;
          $plugins_required_str = implode(', ', $plugins_required_arr);
        endif;?>
    <tr>
      <td><img src="<?php echo $this->URL->getImageUrl($this->Plugin->getLibrary(), 'plugin_disabled.gif');?>" alt="<?php $this->_e('Disabled');?>" /></td>
      <td><?php _h($local_name);?></td>
      <td><?php _h($local_data['version']);?></td>
      <td><?php _h($local_data['summary']);?><?php if($plugins_required_str != ''):?><br /><small><?php printf($this->_('requires %s'), $plugins_required_str);?></small><?php endif;?></td>
      <td><?php $this->HTML->linkTo($this->_('Install'), array('path' => '/install/' . $local_name));?></td>
    </tr>
<?php endforeach;?>
  </tbody>
</table>