<?php
require_once 'Plugg/PluginFront.php';

class Plugg_PluginMain extends Plugg_PluginFront
{
    public function __construct($controller_prefix, $controller_dir, $defaultController = 'Index')
    {
        parent::__construct($defaultController, $controller_prefix, $controller_dir);
    }

    protected function _frontBeforeFilter(Sabai_Application_Context $context)
    {
        parent::_frontBeforeFilter($context);

        // Init page info
        $context->response
            ->clearPageInfo()
            ->setPageInfo($this->gettext->_('Home'), array('base' => '/'));

        if ($this->_setPageInfo) {
            $this->_setIndexPageInfo($context);
            $this->_setPageInfo = false;
        }
    }

    protected function _setIndexPageInfo($context)
    {
        $plugin_name = $context->plugin->getName();
        if (strtolower($this->config->get('defaultPlugin')) != $plugin_name) {
            $context->response->setPageInfo($context->plugin->getNicename(), array(
                'base' => '/' . $plugin_name
            ));
        }
    }
}