<?php
require_once 'Sabai/Application/ControllerFilter.php';

class Plugg_InitFilter extends Sabai_Application_ControllerFilter
{
    public function before(Sabai_Application_Context $context, Sabai_Application $application)
    {
        // Show debug messages?
        if ($application->config->get('showDebugMessages')) {
            Sabai_Log::level(Sabai_Log::ALL);
            require_once 'Sabai/Log/Writer/HTML.php';
            Sabai_Log::writer(new Sabai_Log_Writer_HTML());
        }

        // Is it an AJAX request?
        if ($context->request->isAjax()) {
            $context->response->setRedirect(false) // no redirection
                ->setLayoutFile('ajax.html')
                ->setContentStackLevel(1); // Set default content stack level to 1
        }

        // Define token name
        define('SABAI_TOKEN_NAME', Plugg::TOKEN);

        // Set some useful template helpers
        $context->response->getTemplate()->setPluggObjects($application)
            ->setObject('User', $context->user)
            ->setObject('Request', $context->request);
    }

    public function after(Sabai_Application_Context $context, Sabai_Application $application)
    {
        // Set some view related variables for the requested plugin
        if (isset($context->plugin)) {
            // Template
            $context->response->getTemplate()->setObject('Plugin', $context->plugin)
                ->addTemplateDir($context->plugin->getTemplatePath());

            // Add CSS file if any
            if ($context->plugin->hasCSS()) {
                $plugin_library = $context->plugin->getLibrary();
                $context->response->addCSSFile($application->url->getCssUrl($plugin_library), 'screen', $plugin_library);
            }

            // Check if the plugin is clone and has own template directory and css file
            if ($context->plugin->isClone()) {
                $plugin_name = $context->plugin->getName();
                $plugin_dir = $application->pluginManager->getPluginDir();
                if (is_dir($template_dir = $plugin_dir . '/' . $plugin_name . '/templates')) {
                    $context->response->getTemplate()->addTemplateDir($template_dir);
                }
                if (is_file(sprintf('%1$s/%2$s/%2$s.css', $plugin_dir, $plugin_name))) {
                    $context->response->addCSSFile($application->url->getCssUrl($plugin_name));
                }
            }
        }

        if ($context->request->isAjax()) $context->response->clearPageInfo();

        // Any specific content region or stack level requested?
        if ($content_region = $context->request->getContentRegion()) {
            $context->response->setContentRegion($content_region)
                ->setContentStackLevel(0); // Remove stack level limit if content region is set
        } elseif ($content_stacklevel = $context->request->getContentStackLavel()) {
            $context->response->setContentStackLevel($content_stacklevel);
        }

        // Set some website specific variables
        $context->response->setSiteName($application->config->get('siteName'))
            ->setSiteDescription($application->config->get('siteDescription'));
    }
}