<?php
$language = empty($GLOBALS['xoopsConfig']['language']) ? 'english' : $GLOBALS['xoopsConfig']['language'];
$lang_dir = dirname(__FILE__) . '/language/';
if (file_exists($lang_file = $lang_dir . $language . '/blocks.php')) {
    include_once $lang_file;
} else {
    include_once $lang_dir . 'english/blocks.php';
}

if (!function_exists('b_plugg_widget')) {

function b_plugg_get_requested_plugin($moduleDirname, $routeParam)
{
    static $plugin;
    if (!isset($plugin[$moduleDirname])) {
        if (!isset($_REQUEST[$routeParam]) ||
            !($route = trim($_REQUEST[$routeParam], '/')) ||
            !SabaiXOOPS::isInModule($moduleDirname)
        ) {
            $plugin[$moduleDirname] = '';
        } else {
            $route_arr = explode('/', $route);
            $plugin[$moduleDirname] = $route_arr[0];
        }
    }
    return $plugin[$moduleDirname];
}

function b_plugg_widget($options)
{
    $block = array();
    if (!empty($options[0]) && !empty($options[1]) && !empty($options[2])) {
        list($module_dirname, $plugin_name, $widget_name) = $options;
        $module_script = 'index.php';
        require dirname(__FILE__) . '/common.php';

        // Show on own plugin pages only?
        if (!empty($options[3])) {
            // Is it on the plugin page?
            if (($requested_plugin_name = SabaiXOOPS::getRequestedPlugin($module_dirname, $plugg->url->getRouteParam())) &&
                $requested_plugin_name != $plugin_name
            ) {
                return $block;
            }
        }

        // Render widget and assign result to block content
        if ($plugin = $plugg->pluginManager->getPlugin($plugin_name)) {
            $user = SabaiXOOPS::getCurrentUser($module_dirname);

            // Create template object
            require_once 'Plugg/Template.php';
            $template = new Plugg_Template();
            SabaiXOOPS::initTemplate($plugg, $template);
            $template->setObject('URL', $plugg->url);
            $template->setObject('Config', $plugg->config);
            $template->setObject('Locator', $plugg->locator);
            $template->setObject('Gettext', $plugg->gettext);
            $template->setObject('PluginManager', $plugg->pluginManager);
            $template->setObject('User', $user);
            $template->setObject('Plugin', $plugin);
            $template->addTemplateDir($plugin->getTemplatePath());

            // Get widget content
            if ($widget_content = $plugin->widgetGetContent($user, $template, $widget_name)) {
                $block['content'] = $widget_content;
            }
        }
    }
    return $block;
}

function b_plugg_widget_edit($options) {
    $form = sprintf('<input type="hidden" name="options[0]" value="%s" />
<input type="hidden" name="options[1]" value="%s" />
<input type="hidden" name="options[2]" value="%s" />%s<br />', htmlspecialchars($options[0]), htmlspecialchars($options[1]), htmlspecialchars($options[2]), _MB_PLUGG_BLOCKSHOW);
    if (!empty($options[3])) {
        $form .= sprintf('<input type="radio" name="options[3]" value="1" checked="checked" />%s&nbsp;<input type="radio" name="options[3]" value="0" />%s', _YES, _NO);
    } else {
        $form .= sprintf('<input type="radio" name="options[3]" value="1" />%s&nbsp;<input type="radio" name="options[3]" value="0" checked="checked" />%s', _YES, _NO);
    }
    return $form;
}

}