/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Activator;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.AggregatedBundleRepository;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointInstruction;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Util {
    private static final String REPOSITORY_TYPE = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";
    private static final String CACHE_EXTENSIONS = "org.eclipse.equinox.p2.cache.extensions";
    private static final String PIPE = "|";
    public static final int AGGREGATE_CACHE = 1;
    public static final int AGGREGATE_SHARED_CACHE = 2;
    public static final int AGGREGATE_CACHE_EXTENSIONS = 4;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static AgentLocation getAgentLocation() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    public static URI getBundlePoolLocation(IProfile profile) {
        String path = profile.getProperty("org.eclipse.equinox.p2.cache");
        if (path != null) {
            return new File(path).toURI();
        }
        AgentLocation location = Util.getAgentLocation();
        if (location == null) {
            return null;
        }
        try {
            return URIUtil.toURI((URL)location.getDataArea("org.eclipse.equinox.p2.touchpoint.eclipse"));
        }
        catch (URISyntaxException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public static synchronized IFileArtifactRepository getBundlePoolRepository(IProfile profile) {
        URI location = Util.getBundlePoolLocation(profile);
        if (location == null) {
            return null;
        }
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager();
        try {
            return (IFileArtifactRepository)manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            try {
                String repositoryName = Messages.BundlePool;
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("p2.system", Boolean.TRUE.toString());
                return (IFileArtifactRepository)manager.createRepository(location, repositoryName, REPOSITORY_TYPE, properties);
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                throw new IllegalArgumentException(NLS.bind((String)Messages.bundle_pool_not_writeable, (Object)location));
            }
        }
    }

    public static IFileArtifactRepository getAggregatedBundleRepository(IProfile profile) {
        return Util.getAggregatedBundleRepository(profile, 7);
    }

    public static IFileArtifactRepository getAggregatedBundleRepository(IProfile profile, int repoFilter) {
        IFileArtifactRepository bundlePool;
        String sharedCache;
        ArrayList<Object> bundleRepositories = new ArrayList<Object>();
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager();
        if ((repoFilter & 2) != 0 && (sharedCache = profile.getProperty("org.eclipse.equinox.p2.cache.shared")) != null) {
            try {
                URI repoLocation = new File(sharedCache).toURI();
                IArtifactRepository repository = manager.loadRepository(repoLocation, null);
                if (repository != null && repository instanceof IFileArtifactRepository && !bundleRepositories.contains(repository)) {
                    bundleRepositories.add(repository);
                }
            }
            catch (ProvisionException provisionException) {}
        }
        if ((repoFilter & 1) != 0 && (bundlePool = Util.getBundlePoolRepository(profile)) != null) {
            bundleRepositories.add(bundlePool);
        }
        if ((repoFilter & 4) != 0) {
            List repos = Util.getListProfileProperty(profile, CACHE_EXTENSIONS);
            Iterator iterator = repos.iterator();
            while (iterator.hasNext()) {
                try {
                    URI repoLocation;
                    String repo = (String)iterator.next();
                    try {
                        repoLocation = new URI(repo);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        repoLocation = URIUtil.fromString((String)repo);
                    }
                    IArtifactRepository repository = manager.loadRepository(repoLocation, null);
                    if (repository == null || !(repository instanceof IFileArtifactRepository) || bundleRepositories.contains(repository)) continue;
                    bundleRepositories.add(repository);
                }
                catch (ProvisionException provisionException) {
                }
                catch (URISyntaxException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
                }
            }
        }
        return new AggregatedBundleRepository(bundleRepositories);
    }

    private static List getListProfileProperty(IProfile profile, String key) {
        ArrayList<String> listProperty = new ArrayList<String>();
        String dropinRepositories = profile.getProperty(key);
        if (dropinRepositories != null) {
            StringTokenizer tokenizer = new StringTokenizer(dropinRepositories, PIPE);
            while (tokenizer.hasMoreTokens()) {
                listProperty.add(tokenizer.nextToken());
            }
        }
        return listProperty;
    }

    public static BundleInfo createBundleInfo(File bundleFile, String manifest) {
        String version;
        Map headers;
        BundleInfo bundleInfo;
        block8: {
            ManifestElement[] element;
            block7: {
                bundleInfo = new BundleInfo();
                if (bundleFile != null) {
                    bundleInfo.setLocation(bundleFile.toURI());
                }
                bundleInfo.setManifest(manifest);
                headers = ManifestElement.parseBundleManifest((InputStream)new ByteArrayInputStream(manifest.getBytes("UTF-8")), new HashMap());
                element = ManifestElement.parseHeader((String)"bsn", (String)((String)headers.get("Bundle-SymbolicName")));
                if (element != null && element.length != 0) break block7;
                return null;
            }
            bundleInfo.setSymbolicName(element[0].getValue());
            version = (String)headers.get("Bundle-Version");
            if (version != null) break block8;
            return null;
        }
        try {
            bundleInfo.setVersion(new Version(version).toString());
            String fragmentHost = (String)headers.get("Fragment-Host");
            if (fragmentHost != null) {
                bundleInfo.setFragmentHost(fragmentHost.trim());
            }
        }
        catch (BundleException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
            return null;
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
            return null;
        }
        return bundleInfo;
    }

    public static File getArtifactFile(IArtifactKey artifactKey, IProfile profile) {
        IFileArtifactRepository aggregatedView = Util.getAggregatedBundleRepository(profile);
        File bundleJar = aggregatedView.getArtifactFile(artifactKey);
        return bundleJar;
    }

    public static File getConfigurationFolder(IProfile profile) {
        String config = profile.getProperty("org.eclipse.equinox.p2.configurationFolder");
        if (config != null) {
            return new File(config);
        }
        return new File(Util.getInstallFolder(profile), "configuration");
    }

    public static URL getOSGiInstallArea() {
        Location location;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((location = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.INSTALL_FILTER)) == null) {
            return null;
        }
        if (!location.isSet()) {
            return null;
        }
        return location.getURL();
    }

    public static File getEclipseHome() {
        Location eclipseHome;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((eclipseHome = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.ECLIPSE_HOME_FILTER)) == null || !eclipseHome.isSet()) {
            return null;
        }
        URL url = eclipseHome.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    public static File getInstallFolder(IProfile profile) {
        String folder = profile.getProperty("org.eclipse.equinox.p2.installFolder");
        return folder == null ? null : new File(folder);
    }

    public static File getLauncherPath(IProfile profile) {
        String name = profile.getProperty("eclipse.touchpoint.launcherName");
        if (name == null || name.length() == 0) {
            name = "eclipse";
        }
        return new File(Util.getInstallFolder(profile), Util.getLauncherName(name, Util.getOSFromProfile(profile)));
    }

    private static String getLauncherName(String name, String os) {
        Path path;
        if (os == null) {
            EnvironmentInfo info;
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
                os = info.getOS();
            }
        }
        if (os.equals("win32")) {
            path = new Path(name);
            if ("exe".equals(path.getFileExtension())) {
                return name;
            }
            return String.valueOf(name) + ".exe";
        }
        if (os.equals("macosx")) {
            path = new Path(name);
            if ("app".equals(path.getFileExtension())) {
                return name;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(name.substring(0, 1).toUpperCase());
            buffer.append(name.substring(1));
            buffer.append(".app/Contents/MacOS/");
            buffer.append(name.toLowerCase());
            return buffer.toString();
        }
        return name;
    }

    private static String getOSFromProfile(IProfile profile) {
        String environments = profile.getProperty("org.eclipse.equinox.p2.environments");
        if (environments == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            int i;
            String entry = tokenizer.nextToken();
            String key = entry.substring(0, i = entry.indexOf(61)).trim();
            if (!key.equals("osgi.os")) continue;
            return entry.substring(i + 1).trim();
        }
        return null;
    }

    public static String getManifest(ITouchpointData[] data) {
        int i = 0;
        while (i < data.length) {
            ITouchpointInstruction manifestInstruction = data[i].getInstruction("manifest");
            if (manifestInstruction == null) {
                return null;
            }
            String manifest = manifestInstruction.getBody();
            if (manifest != null && manifest.length() > 0) {
                return manifest;
            }
            ++i;
        }
        return null;
    }

    public static IStatus createError(String message) {
        return Util.createError(message, null);
    }

    public static IStatus createError(String message, Exception e) {
        return new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", message, (Throwable)e);
    }

    public static File getLauncherConfigLocation(IProfile profile) {
        String launcherConfig = profile.getProperty("org.eclipse.equinox.p2.launcherConfiguration");
        return launcherConfig == null ? null : new File(launcherConfig);
    }
}

