/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;

public class RequiredCapability
implements IRequiredCapability {
    private static final String[] NO_SELECTORS = new String[0];
    private String filter;
    private final boolean multiple;
    private final String name;
    private final String namespace;
    private boolean optional;
    private boolean greedy = true;
    private final VersionRange range;
    private String[] selectors = NO_SELECTORS;

    public RequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple) {
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull((Object)name);
        this.namespace = namespace;
        this.name = name;
        this.range = range == null ? VersionRange.emptyRange : range;
        this.optional = optional;
        this.filter = filter;
        this.multiple = multiple;
    }

    public RequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple, boolean greedy) {
        this(namespace, name, range, filter, optional, multiple);
        this.greedy = greedy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IRequiredCapability)) {
            return false;
        }
        IRequiredCapability other = (IRequiredCapability)obj;
        if (this.filter == null ? other.getFilter() != null : !this.filter.equals(other.getFilter())) {
            return false;
        }
        if (this.multiple != other.isMultiple()) {
            return false;
        }
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (!this.namespace.equals(other.getNamespace())) {
            return false;
        }
        if (this.optional != other.isOptional()) {
            return false;
        }
        return this.range.equals((Object)other.getRange());
    }

    public String getFilter() {
        return this.filter;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public VersionRange getRange() {
        return this.range;
    }

    public String[] getSelectors() {
        return this.selectors;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.multiple ? 1231 : 1237);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.namespace.hashCode();
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + this.range.hashCode();
        return result;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectors(String[] selectors) {
        this.selectors = selectors;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if ("org.eclipse.equinox.p2.iu".equals(this.getNamespace())) {
            result.append("");
        } else if ("osgi.bundle".equals(this.getNamespace())) {
            result.append("bundle");
        } else if ("java.package".equals(this.getNamespace())) {
            result.append("package");
        } else {
            result.append(this.getNamespace());
        }
        if (result.length() > 0) {
            result.append(' ');
        }
        result.append(this.getName());
        result.append(' ');
        if (this.range.getMinimum().equals((Object)this.range.getMaximum())) {
            result.append('[').append(this.range.getMinimum()).append(']');
        } else {
            result.append(this.range);
        }
        return result.toString();
    }
}

