/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

final class BasicPermissionCollection
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 739301742472979399L;
    private transient Map perms = new HashMap(11);
    private boolean all_allowed = false;
    private Class permClass;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE), new ObjectStreamField("permClass", Class.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof BasicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (this.perms.size() == 0) {
            this.permClass = basicPermission.getClass();
        } else if (basicPermission.getClass() != this.permClass) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            this.perms.put(basicPermission.getCanonicalName(), permission);
        }
        if (!this.all_allowed && basicPermission.getCanonicalName().equals("*")) {
            this.all_allowed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        int n;
        Permission permission2;
        if (!(permission instanceof BasicPermission)) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (basicPermission.getClass() != this.permClass) {
            return false;
        }
        if (this.all_allowed) {
            return true;
        }
        String string = basicPermission.getCanonicalName();
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            permission2 = (Permission)this.perms.get(string);
        }
        if (permission2 != null) {
            return permission2.implies(permission);
        }
        int n2 = string.length() - 1;
        while ((n = string.lastIndexOf(".", n2)) != -1) {
            string = string.substring(0, n + 1) + "*";
            BasicPermissionCollection basicPermissionCollection2 = this;
            synchronized (basicPermissionCollection2) {
                permission2 = (Permission)this.perms.get(string);
            }
            if (permission2 != null) {
                return permission2.implies(permission);
            }
            n2 = n - 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            return Collections.enumeration(this.perms.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = new Hashtable(this.perms.size() * 2);
        Object object = this;
        synchronized (object) {
            hashtable.putAll(this.perms);
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("all_allowed", this.all_allowed);
        ((ObjectOutputStream.PutField)object).put("permissions", hashtable);
        ((ObjectOutputStream.PutField)object).put("permClass", this.permClass);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Enumeration enumeration;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.perms = new HashMap(hashtable.size() * 2);
        this.perms.putAll(hashtable);
        this.all_allowed = getField.get("all_allowed", false);
        this.permClass = (Class)getField.get("permClass", null);
        if (this.permClass == null && (enumeration = hashtable.elements()).hasMoreElements()) {
            Permission permission = (Permission)enumeration.nextElement();
            this.permClass = permission.getClass();
        }
    }
}

