/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository.io;

import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.repository.io.XMLConstants;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.ICopyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.ILicense;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointType;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.RepositoryReference;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public abstract class MetadataParser
extends XMLParser
implements XMLConstants {
    public MetadataParser(BundleContext context, String bundleId) {
        super(context, bundleId);
    }

    protected class ApplicabilityScopeHandler
    extends XMLParser.AbstractHandler {
        private RequiredCapabilitiesHandler children;
        private List scopes;

        public ApplicabilityScopeHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List scopes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "scope");
            this.scopes = scopes;
        }

        public void startElement(String name, Attributes attributes) {
            if ("requires".equals(name)) {
                this.children = new RequiredCapabilitiesHandler(this, attributes);
            } else {
                MetadataParser.this.duplicateElement(this, name, attributes);
            }
        }

        protected void finished() {
            if (this.children != null) {
                this.scopes.add(this.children.getRequiredCapabilities());
            }
        }
    }

    protected class ApplicabilityScopesHandler
    extends XMLParser.AbstractHandler {
        private List scopes;

        public ApplicabilityScopesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "patchScope");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.scopes = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public void startElement(String name, Attributes attributes) {
            if ("scope".equals(name)) {
                new ApplicabilityScopeHandler(this, attributes, this.scopes);
            } else {
                MetadataParser.this.duplicateElement(this, name, attributes);
            }
        }

        public IRequiredCapability[][] getScope() {
            return (IRequiredCapability[][])this.scopes.toArray((T[])new IRequiredCapability[this.scopes.size()][]);
        }
    }

    protected class ArtifactHandler
    extends XMLParser.AbstractHandler {
        private final String[] required = new String[]{"classifier", "id", "version"};

        public ArtifactHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List artifacts) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "artifact");
            String[] values = this.parseRequiredAttributes(attributes, this.required);
            Version version = MetadataParser.this.checkVersion("artifact", "version", values[2]);
            artifacts.add(new ArtifactKey(values[0], values[1], version));
        }

        public void startElement(String name, Attributes attributes) {
            this.invalidElement(name, attributes);
        }
    }

    protected class ArtifactsHandler
    extends XMLParser.AbstractHandler {
        private List artifacts;

        public ArtifactsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "artifacts");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.artifacts = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public IArtifactKey[] getArtifactKeys() {
            return this.artifacts.toArray(new IArtifactKey[this.artifacts.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("artifact")) {
                new ArtifactHandler(this, attributes, this.artifacts);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class CapabilitySelectorsHandler
    extends XMLParser.AbstractHandler {
        private List selectors;

        public CapabilitySelectorsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "selectors");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.selectors = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public String[] getSelectors() {
            return this.selectors.toArray(new String[this.selectors.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("selector")) {
                new XMLParser.TextHandler((XMLParser)MetadataParser.this, (XMLParser.AbstractHandler)this, "selector", attributes, this.selectors);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class CopyrightHandler
    extends XMLParser.TextHandler {
        URI location = null;
        private ICopyright copyright;

        public CopyrightHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, parentHandler, "copyright");
            this.location = this.parseURIAttribute(attributes, false);
        }

        protected void finished() {
            if (MetadataParser.this.isValidXML()) {
                this.copyright = MetadataFactory.createCopyright((URI)this.location, (String)this.getText());
            }
        }

        public ICopyright getCopyright() {
            return this.copyright;
        }
    }

    protected class HostRequiredCapabilitiesHandler
    extends XMLParser.AbstractHandler {
        private List requiredCapabilities;

        public HostRequiredCapabilitiesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "hostRequirements");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.requiredCapabilities = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public IRequiredCapability[] getHostRequiredCapabilities() {
            return this.requiredCapabilities.toArray(new IRequiredCapability[this.requiredCapabilities.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("required")) {
                new RequiredCapabilityHandler(this, attributes, this.requiredCapabilities);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class InstallableUnitHandler
    extends XMLParser.AbstractHandler {
        MetadataFactory.InstallableUnitDescription currentUnit = null;
        private XMLParser.PropertiesHandler propertiesHandler = null;
        private ProvidedCapabilitiesHandler providedCapabilitiesHandler = null;
        private RequiredCapabilitiesHandler requiredCapabilitiesHandler = null;
        private HostRequiredCapabilitiesHandler hostRequiredCapabilitiesHandler = null;
        private MetaRequiredCapabilitiesHandler metaRequiredCapabilitiesHandler = null;
        private XMLParser.TextHandler filterHandler = null;
        private ArtifactsHandler artifactsHandler = null;
        private TouchpointTypeHandler touchpointTypeHandler = null;
        private TouchpointDataHandler touchpointDataHandler = null;
        private UpdateDescriptorHandler updateDescriptorHandler = null;
        private LicensesHandler licensesHandler = null;
        private CopyrightHandler copyrightHandler = null;
        private RequirementsChangeHandler requirementChangesHandler = null;
        private ApplicabilityScopesHandler applicabilityScopeHandler = null;
        private LifeCycleHandler lifeCycleHandler;
        private String id;
        private Version version;
        private boolean singleton;
        private List units;

        public InstallableUnitHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List units) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "unit");
            String[] values = this.parseAttributes(attributes, REQUIRED_IU_ATTRIBUTES, OPTIONAL_IU_ATTRIBUTES);
            this.units = units;
            if (values[0] == null) {
                return;
            }
            this.id = values[0];
            this.version = MetadataParser.this.checkVersion("unit", "version", values[1]);
            this.singleton = MetadataParser.this.checkBoolean("unit", "singleton", values[2], true);
        }

        public IInstallableUnit getInstallableUnit() {
            return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)this.currentUnit);
        }

        public void startElement(String name, Attributes attributes) {
            MetadataParser.this.checkCancel();
            if ("properties".equals(name)) {
                if (this.propertiesHandler == null) {
                    this.propertiesHandler = new XMLParser.PropertiesHandler((XMLParser)MetadataParser.this, (ContentHandler)((Object)this), attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("provides".equals(name)) {
                if (this.providedCapabilitiesHandler == null) {
                    this.providedCapabilitiesHandler = new ProvidedCapabilitiesHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("requires".equals(name)) {
                if (this.requiredCapabilitiesHandler == null) {
                    this.requiredCapabilitiesHandler = new RequiredCapabilitiesHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("hostRequirements".equals(name)) {
                if (this.hostRequiredCapabilitiesHandler == null) {
                    this.hostRequiredCapabilitiesHandler = new HostRequiredCapabilitiesHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("metaRequirements".equals(name)) {
                if (this.metaRequiredCapabilitiesHandler == null) {
                    this.metaRequiredCapabilitiesHandler = new MetaRequiredCapabilitiesHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("filter".equals(name)) {
                if (this.filterHandler == null) {
                    this.filterHandler = new XMLParser.TextHandler((XMLParser)MetadataParser.this, (XMLParser.AbstractHandler)this, "filter", attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("artifacts".equals(name)) {
                if (this.artifactsHandler == null) {
                    this.artifactsHandler = new ArtifactsHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("touchpoint".equals(name)) {
                if (this.touchpointTypeHandler == null) {
                    this.touchpointTypeHandler = new TouchpointTypeHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("touchpointData".equals(name)) {
                if (this.touchpointDataHandler == null) {
                    this.touchpointDataHandler = new TouchpointDataHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("update".equals(name)) {
                if (this.updateDescriptorHandler == null) {
                    this.updateDescriptorHandler = new UpdateDescriptorHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("licenses".equals(name)) {
                if (this.licensesHandler == null) {
                    this.licensesHandler = new LicensesHandler((ContentHandler)((Object)this), attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("changes".equals(name)) {
                if (this.requirementChangesHandler == null) {
                    this.requirementChangesHandler = new RequirementsChangeHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("patchScope".equals(name)) {
                if (this.applicabilityScopeHandler == null) {
                    this.applicabilityScopeHandler = new ApplicabilityScopesHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("lifeCycle".equals(name)) {
                if (this.lifeCycleHandler == null) {
                    this.lifeCycleHandler = new LifeCycleHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("copyright".equals(name)) {
                if (this.copyrightHandler == null) {
                    this.copyrightHandler = new CopyrightHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else {
                this.invalidElement(name, attributes);
            }
        }

        protected void finished() {
            if (MetadataParser.this.isValidXML()) {
                if (this.requirementChangesHandler != null) {
                    this.currentUnit = new MetadataFactory.InstallableUnitPatchDescription();
                    ((MetadataFactory.InstallableUnitPatchDescription)this.currentUnit).setRequirementChanges(this.requirementChangesHandler.getRequirementChanges().toArray(new IRequirementChange[this.requirementChangesHandler.getRequirementChanges().size()]));
                    if (this.applicabilityScopeHandler != null) {
                        ((MetadataFactory.InstallableUnitPatchDescription)this.currentUnit).setApplicabilityScope(this.applicabilityScopeHandler.getScope());
                    }
                    if (this.lifeCycleHandler != null) {
                        ((MetadataFactory.InstallableUnitPatchDescription)this.currentUnit).setLifeCycle(this.lifeCycleHandler.getLifeCycleRequirement());
                    }
                } else if (this.hostRequiredCapabilitiesHandler == null || this.hostRequiredCapabilitiesHandler.getHostRequiredCapabilities().length == 0) {
                    this.currentUnit = new MetadataFactory.InstallableUnitDescription();
                } else {
                    this.currentUnit = new MetadataFactory.InstallableUnitFragmentDescription();
                    ((MetadataFactory.InstallableUnitFragmentDescription)this.currentUnit).setHost(this.hostRequiredCapabilitiesHandler.getHostRequiredCapabilities());
                }
                this.currentUnit.setId(this.id);
                this.currentUnit.setVersion(this.version);
                this.currentUnit.setSingleton(this.singleton);
                OrderedProperties properties = this.propertiesHandler == null ? new OrderedProperties(0) : this.propertiesHandler.getProperties();
                String updateFrom = null;
                VersionRange updateRange = null;
                Enumeration e = properties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = properties.getProperty(key);
                    if (key.equals("equinox.p2.update.from")) {
                        updateFrom = value;
                        continue;
                    }
                    if (key.equals("equinox.p2.update.range")) {
                        updateRange = new VersionRange(value);
                        continue;
                    }
                    this.currentUnit.setProperty(key, value);
                }
                if (updateFrom != null && updateRange != null) {
                    this.currentUnit.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor(updateFrom, updateRange, (int)0, null));
                }
                if (this.licensesHandler != null) {
                    ILicense license = this.licensesHandler.getLicense();
                    this.currentUnit.setLicense(license);
                }
                if (this.copyrightHandler != null) {
                    ICopyright copyright = this.copyrightHandler.getCopyright();
                    this.currentUnit.setCopyright(copyright);
                }
                IProvidedCapability[] providedCapabilities = this.providedCapabilitiesHandler == null ? new IProvidedCapability[]{} : this.providedCapabilitiesHandler.getProvidedCapabilities();
                this.currentUnit.setCapabilities(providedCapabilities);
                IRequiredCapability[] requiredCapabilities = this.requiredCapabilitiesHandler == null ? new IRequiredCapability[]{} : this.requiredCapabilitiesHandler.getRequiredCapabilities();
                this.currentUnit.setRequiredCapabilities(requiredCapabilities);
                IRequiredCapability[] metaRequiredCapabilities = this.metaRequiredCapabilitiesHandler == null ? new IRequiredCapability[]{} : this.metaRequiredCapabilitiesHandler.getMetaRequiredCapabilities();
                this.currentUnit.setMetaRequiredCapabilities(metaRequiredCapabilities);
                if (this.filterHandler != null) {
                    this.currentUnit.setFilter(this.filterHandler.getText());
                }
                IArtifactKey[] artifacts = this.artifactsHandler == null ? new IArtifactKey[]{} : this.artifactsHandler.getArtifactKeys();
                this.currentUnit.setArtifacts(artifacts);
                if (this.touchpointTypeHandler != null) {
                    this.currentUnit.setTouchpointType(this.touchpointTypeHandler.getTouchpointType());
                }
                ITouchpointData[] touchpointData = this.touchpointDataHandler == null ? new ITouchpointData[]{} : this.touchpointDataHandler.getTouchpointData();
                int i = 0;
                while (i < touchpointData.length) {
                    this.currentUnit.addTouchpointData(touchpointData[i]);
                    ++i;
                }
                if (this.updateDescriptorHandler != null) {
                    this.currentUnit.setUpdateDescriptor(this.updateDescriptorHandler.getUpdateDescriptor());
                }
                this.units.add(this.currentUnit);
            }
        }
    }

    protected class InstallableUnitsHandler
    extends XMLParser.AbstractHandler {
        private ArrayList units;

        public InstallableUnitsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "units");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.units = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public IInstallableUnit[] getUnits() {
            int size = this.units.size();
            IInstallableUnit[] result = new IInstallableUnit[size];
            int i = 0;
            Iterator it = this.units.iterator();
            while (it.hasNext()) {
                MetadataFactory.InstallableUnitDescription desc = (MetadataFactory.InstallableUnitDescription)it.next();
                result[i] = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc);
                ++i;
            }
            return result;
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("unit")) {
                new InstallableUnitHandler(this, attributes, this.units);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class LicenseHandler
    extends XMLParser.TextHandler {
        URI location = null;
        private final List licenses;

        public LicenseHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List licenses) {
            super((XMLParser)MetadataParser.this, parentHandler, "license");
            this.location = this.parseURIAttribute(attributes, false);
            this.licenses = licenses;
        }

        protected void finished() {
            if (MetadataParser.this.isValidXML()) {
                this.licenses.add(MetadataFactory.createLicense((URI)this.location, (String)this.getText()));
            }
        }
    }

    protected class LicensesHandler
    extends XMLParser.AbstractHandler {
        private List licenses;

        public LicensesHandler(ContentHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, parentHandler, "licenses");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.licenses = size != null ? new ArrayList(new Integer(size)) : new ArrayList(2);
        }

        public ILicense getLicense() {
            if (this.licenses.size() == 0) {
                return null;
            }
            return (ILicense)this.licenses.get(0);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("license")) {
                new LicenseHandler(this, attributes, this.licenses);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class LifeCycleHandler
    extends XMLParser.AbstractHandler {
        private List lifeCycleRequirement = new ArrayList(1);

        public LifeCycleHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "lifeCycle");
        }

        public IRequiredCapability getLifeCycleRequirement() {
            if (this.lifeCycleRequirement.size() == 0) {
                return null;
            }
            return (IRequiredCapability)this.lifeCycleRequirement.get(0);
        }

        public void startElement(String name, Attributes attributes) {
            if ("required".equals(name)) {
                new RequiredCapabilityHandler(this, attributes, this.lifeCycleRequirement);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class MetaRequiredCapabilitiesHandler
    extends XMLParser.AbstractHandler {
        private List requiredCapabilities;

        public MetaRequiredCapabilitiesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "metaRequirements");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.requiredCapabilities = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public IRequiredCapability[] getMetaRequiredCapabilities() {
            return this.requiredCapabilities.toArray(new IRequiredCapability[this.requiredCapabilities.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("required")) {
                new RequiredCapabilityHandler(this, attributes, this.requiredCapabilities);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class ProvidedCapabilitiesHandler
    extends XMLParser.AbstractHandler {
        private List providedCapabilities;

        public ProvidedCapabilitiesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "provides");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.providedCapabilities = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public IProvidedCapability[] getProvidedCapabilities() {
            return this.providedCapabilities.toArray(new IProvidedCapability[this.providedCapabilities.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("provided")) {
                new ProvidedCapabilityHandler(this, attributes, this.providedCapabilities);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class ProvidedCapabilityHandler
    extends XMLParser.AbstractHandler {
        public ProvidedCapabilityHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List capabilities) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "provided");
            String[] values = this.parseRequiredAttributes(attributes, REQUIRED_PROVIDED_CAPABILITY_ATTRIBUTES);
            Version version = MetadataParser.this.checkVersion("provided", "version", values[2]);
            capabilities.add(MetadataFactory.createProvidedCapability((String)values[0], (String)values[1], (Version)version));
        }

        public void startElement(String name, Attributes attributes) {
            this.invalidElement(name, attributes);
        }
    }

    protected class RepositoryReferenceHandler
    extends XMLParser.AbstractHandler {
        private final String[] required = new String[]{"type", "options"};

        public RepositoryReferenceHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, Set references) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "repository");
            String[] values = this.parseRequiredAttributes(attributes, this.required);
            String name = this.parseOptionalAttribute(attributes, "name");
            int type = MetadataParser.this.checkInteger(this.elementHandled, "type", values[0]);
            int options = MetadataParser.this.checkInteger(this.elementHandled, "options", values[1]);
            URI location = this.parseURIAttribute(attributes, true);
            if (location != null) {
                references.add(new RepositoryReference(location, name, type, options));
            }
        }

        public void startElement(String name, Attributes attributes) {
            this.invalidElement(name, attributes);
        }
    }

    protected class RepositoryReferencesHandler
    extends XMLParser.AbstractHandler {
        private HashSet references;

        public RepositoryReferencesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "references");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.references = size != null ? new HashSet(Integer.parseInt(size)) : new HashSet(4);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("repository")) {
                new RepositoryReferenceHandler(this, attributes, this.references);
            } else {
                this.invalidElement(name, attributes);
            }
        }

        public RepositoryReference[] getReferences() {
            return this.references.toArray(new RepositoryReference[this.references.size()]);
        }
    }

    protected class RequiredCapabilitiesHandler
    extends XMLParser.AbstractHandler {
        private List requiredCapabilities;

        public RequiredCapabilitiesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "requires");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.requiredCapabilities = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public IRequiredCapability[] getRequiredCapabilities() {
            return this.requiredCapabilities.toArray(new IRequiredCapability[this.requiredCapabilities.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("required")) {
                new RequiredCapabilityHandler(this, attributes, this.requiredCapabilities);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class RequiredCapabilityHandler
    extends XMLParser.AbstractHandler {
        private IRequiredCapability currentCapability = null;
        private XMLParser.TextHandler filterHandler = null;
        private CapabilitySelectorsHandler selectorsHandler = null;

        public RequiredCapabilityHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List capabilities) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "required");
            String[] values = this.parseAttributes(attributes, REQIURED_CAPABILITY_ATTRIBUTES, OPTIONAL_CAPABILITY_ATTRIBUTES);
            VersionRange range = MetadataParser.this.checkVersionRange("required", "range", values[2]);
            boolean isOptional = MetadataParser.this.checkBoolean("required", "optional", values[3], false);
            boolean isMultiple = MetadataParser.this.checkBoolean("required", "multiple", values[4], false);
            boolean isGreedy = MetadataParser.this.checkBoolean("required", "greedy", values[5], true);
            this.currentCapability = MetadataFactory.createRequiredCapability((String)values[0], (String)values[1], (VersionRange)range, null, (boolean)isOptional, (boolean)isMultiple, (boolean)isGreedy);
            capabilities.add(this.currentCapability);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("filter")) {
                this.filterHandler = new XMLParser.TextHandler((XMLParser)MetadataParser.this, (XMLParser.AbstractHandler)this, "filter", attributes);
            } else if (name.equals("selectors")) {
                this.selectorsHandler = new CapabilitySelectorsHandler(this, attributes);
            } else {
                this.invalidElement(name, attributes);
            }
        }

        protected void finished() {
            if (MetadataParser.this.isValidXML() && this.currentCapability != null) {
                if (this.filterHandler != null) {
                    this.currentCapability.setFilter(this.filterHandler.getText());
                }
                if (this.selectorsHandler != null) {
                    this.currentCapability.setSelectors(this.selectorsHandler.getSelectors());
                }
            }
        }
    }

    protected class RequirementChangeEltHandler
    extends XMLParser.AbstractHandler {
        private List requirement;

        public RequirementChangeEltHandler(XMLParser.AbstractHandler parentHandler, String parentId, Attributes attributes, List from) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, parentId);
            this.requirement = from;
        }

        public void startElement(String name, Attributes attributes) {
            if ("required".equals(name)) {
                new RequiredCapabilityHandler(this, attributes, this.requirement);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class RequirementChangeHandler
    extends XMLParser.AbstractHandler {
        private List from = new ArrayList(1);
        private List to = new ArrayList(1);
        private List requirementChanges;

        public RequirementChangeHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List requirementChanges) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "change");
            this.requirementChanges = requirementChanges;
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("from")) {
                new RequirementChangeEltHandler(this, "from", attributes, this.from);
                return;
            }
            if (name.equals("to")) {
                new RequirementChangeEltHandler(this, "to", attributes, this.to);
                return;
            }
            this.invalidElement(name, attributes);
        }

        protected void finished() {
            this.requirementChanges.add(MetadataFactory.createRequirementChange((IRequiredCapability)(this.from.size() == 0 ? null : (IRequiredCapability)this.from.get(0)), this.to.size() == 0 ? null : (IRequiredCapability)this.to.get(0)));
        }
    }

    protected class RequirementsChangeHandler
    extends XMLParser.AbstractHandler {
        private List requirementChanges;

        public RequirementsChangeHandler(InstallableUnitHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)((Object)parentHandler), "changes");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.requirementChanges = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("change")) {
                new RequirementChangeHandler(this, attributes, this.requirementChanges);
            } else {
                this.invalidElement(name, attributes);
            }
        }

        public List getRequirementChanges() {
            return this.requirementChanges;
        }
    }

    protected class TouchpointDataHandler
    extends XMLParser.AbstractHandler {
        ITouchpointData touchpointData = null;
        List data = null;

        public TouchpointDataHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "touchpointData");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.data = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
        }

        public ITouchpointData[] getTouchpointData() {
            ITouchpointData[] result = new ITouchpointData[this.data.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = ((TouchpointInstructionsHandler)((Object)this.data.get(i))).getTouchpointData();
                ++i;
            }
            return result;
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("instructions")) {
                this.data.add(new TouchpointInstructionsHandler(this, attributes, this.data));
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class TouchpointInstructionHandler
    extends XMLParser.TextHandler {
        private final String[] required = new String[]{"key"};
        private final String[] optional = new String[]{"import"};
        Map instructions = null;
        String key = null;
        String qualifier = null;

        public TouchpointInstructionHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, Map instructions) {
            super((XMLParser)MetadataParser.this, parentHandler, "instruction");
            String[] values = this.parseAttributes(attributes, this.required, this.optional);
            this.key = values[0];
            this.qualifier = values[1];
            this.instructions = instructions;
        }

        protected void finished() {
            if (MetadataParser.this.isValidXML() && this.key != null) {
                this.instructions.put(this.key, MetadataFactory.createTouchpointInstruction((String)this.getText(), (String)this.qualifier));
            }
        }
    }

    protected class TouchpointInstructionsHandler
    extends XMLParser.AbstractHandler {
        Map instructions = null;

        public TouchpointInstructionsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List data) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "instructions");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.instructions = size != null ? new LinkedHashMap(new Integer(size)) : new LinkedHashMap(4);
        }

        public ITouchpointData getTouchpointData() {
            return MetadataFactory.createTouchpointData((Map)this.instructions);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("instruction")) {
                new TouchpointInstructionHandler(this, attributes, this.instructions);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class TouchpointTypeHandler
    extends XMLParser.AbstractHandler {
        private final String[] required = new String[]{"id", "version"};
        ITouchpointType touchpointType = null;

        public TouchpointTypeHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "touchpoint");
            String[] values = this.parseRequiredAttributes(attributes, this.required);
            Version version = MetadataParser.this.checkVersion("touchpoint", "version", values[1]);
            this.touchpointType = MetadataFactory.createTouchpointType((String)values[0], (Version)version);
        }

        public ITouchpointType getTouchpointType() {
            return this.touchpointType;
        }

        public void startElement(String name, Attributes attributes) {
            this.invalidElement(name, attributes);
        }
    }

    protected class UpdateDescriptorHandler
    extends XMLParser.TextHandler {
        private final String[] required = new String[]{"id", "range"};
        private final String[] optional = new String[]{"severity", "description"};
        private IUpdateDescriptor descriptor;

        public UpdateDescriptorHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, parentHandler, "unit");
            String[] values = this.parseAttributes(attributes, this.required, this.optional);
            VersionRange range = MetadataParser.this.checkVersionRange("required", "range", values[1]);
            int severity = new Integer(values[2]);
            this.descriptor = MetadataFactory.createUpdateDescriptor((String)values[0], (VersionRange)range, (int)severity, (String)values[3]);
        }

        public IUpdateDescriptor getUpdateDescriptor() {
            return this.descriptor;
        }
    }
}

