/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.installer;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.installer.InstallDescriptionParser;
import org.eclipse.equinox.internal.p2.installer.InstallUpdateProductOperation;
import org.eclipse.equinox.internal.p2.installer.InstallerActivator;
import org.eclipse.equinox.internal.p2.installer.Messages;
import org.eclipse.equinox.internal.p2.installer.ui.SWTInstallAdvisor;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallAdvisor;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class InstallApplication
implements IApplication {
    private static final String SYS_PROP_INSTALL_DESCRIPTION = "org.eclipse.equinox.p2.installDescription";
    private InstallAdvisor advisor;
    static /* synthetic */ Class class$0;

    private static CoreException fail(String message, Throwable throwable) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", message, throwable));
    }

    public static Object getService(BundleContext context, String name) {
        if (context == null) {
            return null;
        }
        ServiceReference reference = context.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = context.getService(reference);
        context.ungetService(reference);
        return result;
    }

    private InstallDescription computeInstallDescription() throws CoreException {
        InstallDescription description = this.fetchInstallDescription(SubMonitor.convert(null));
        return this.advisor.prepareInstallDescription(description);
    }

    private InstallAdvisor createInstallContext() {
        SWTInstallAdvisor result = new SWTInstallAdvisor();
        ((InstallAdvisor)result).start();
        return result;
    }

    private InstallDescription fetchInstallDescription(SubMonitor monitor) throws CoreException {
        String site = System.getProperty(SYS_PROP_INSTALL_DESCRIPTION);
        try {
            return InstallDescriptionParser.createDescription(site, monitor);
        }
        catch (Exception e) {
            throw InstallApplication.fail(String.valueOf(Messages.App_InvalidSite) + site, e);
        }
    }

    private IStatus getStatus(Exception failure) {
        Throwable cause = failure;
        if (failure instanceof InvocationTargetException && (cause = ((InvocationTargetException)failure).getTargetException()) == null) {
            cause = failure;
        }
        if (cause instanceof CoreException) {
            return ((CoreException)cause).getStatus();
        }
        return new Status(4, "org.eclipse.equinox.p2.installer", Messages.App_Error, cause);
    }

    private void launchProduct(InstallDescription description) throws CoreException {
        IPath installLocation = description.getInstallLocation();
        IPath toRun = installLocation.append(description.getLauncherName());
        try {
            Runtime.getRuntime().exec(toRun.toString(), null, installLocation.toFile());
        }
        catch (IOException e) {
            throw InstallApplication.fail(String.valueOf(Messages.App_LaunchFailed) + toRun, e);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object start(IApplicationContext appContext) {
        IStatus result;
        InstallDescription description;
        block12: {
            appContext.applicationRunning();
            this.initializeProxySupport();
            this.advisor = this.createInstallContext();
            description = null;
            description = this.computeInstallDescription();
            this.startRequiredBundles(description);
            InstallUpdateProductOperation operation = new InstallUpdateProductOperation(InstallerActivator.getDefault().getContext(), description);
            result = this.advisor.performInstall(operation);
            if (!result.isOK()) {
                LogHelper.log((IStatus)result);
                this.advisor.setResult(result);
                Integer n = IApplication.EXIT_OK;
                if (this.advisor == null) return n;
                this.advisor.stop();
                return n;
            }
            if (operation.isFirstInstall()) break block12;
            Integer n = IApplication.EXIT_OK;
            if (this.advisor == null) return n;
            this.advisor.stop();
            return n;
        }
        try {
            if (this.canAutoStart(description)) {
                this.launchProduct(description);
                return IApplication.EXIT_OK;
            } else {
                this.advisor.setResult(result);
            }
            return IApplication.EXIT_OK;
        }
        catch (OperationCanceledException operationCanceledException) {
            this.advisor.setResult(Status.CANCEL_STATUS);
            return IApplication.EXIT_OK;
        }
        catch (Exception e) {
            IStatus error = this.getStatus(e);
            this.advisor.setResult(error);
            LogHelper.log((IStatus)error);
        }
        return IApplication.EXIT_OK;
    }

    private void initializeProxySupport() {
        IProxyService proxies;
        BundleContext bundleContext = InstallerActivator.getDefault().getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.net.proxy.IProxyService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((proxies = (IProxyService)InstallApplication.getService(bundleContext, clazz.getName())) == null) {
            return;
        }
        proxies.setProxiesEnabled(true);
        proxies.setSystemProxiesEnabled(true);
    }

    private boolean canAutoStart(InstallDescription description) {
        if (!description.isAutoStart()) {
            return false;
        }
        if (description.getLauncherName() == null || description.getInstallLocation() == null) {
            return false;
        }
        return this.advisor.promptForLaunch(description);
    }

    private void startRequiredBundles(InstallDescription description) throws CoreException {
        String agentArea;
        IPath installLocation = description.getInstallLocation();
        if (installLocation == null) {
            throw InstallApplication.fail(Messages.App_NoInstallLocation, null);
        }
        IPath agentLocation = description.getAgentLocation();
        if (agentLocation != null && ((agentArea = System.getProperty("eclipse.p2.data.area")) == null || agentArea.length() == 0 || agentArea.startsWith("@config"))) {
            System.setProperty("eclipse.p2.data.area", agentLocation.toOSString());
        }
        try {
            if (agentLocation != null) {
                InstallerActivator.getDefault().getBundle("org.eclipse.equinox.p2.core").stop(1);
                InstallerActivator.getDefault().getBundle("org.eclipse.equinox.p2.core").start(1);
            }
            InstallerActivator.getDefault().getBundle("org.eclipse.equinox.p2.exemplarysetup").start(1);
        }
        catch (BundleException e) {
            throw InstallApplication.fail(Messages.App_FailedStart, e);
        }
    }

    public void stop() {
        InstallAdvisor tempContext = this.advisor;
        if (tempContext != null) {
            tempContext.stop();
            this.advisor = null;
        }
    }
}

