/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.Activator;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryIO;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompoundQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.repository.ICompositeRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.AbstractMetadataRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class CompositeMetadataRepository
extends AbstractMetadataRepository
implements IMetadataRepository,
ICompositeRepository {
    public static final String REPOSITORY_TYPE;
    public static final String PI_REPOSITORY_TYPE = "compositeMetadataRepository";
    private static final Integer REPOSITORY_VERSION;
    public static final String XML_EXTENSION = ".xml";
    private static final String JAR_EXTENSION = ".jar";
    private List childrenURIs = new ArrayList();
    private List loadedRepos = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REPOSITORY_TYPE = clazz.getName();
        REPOSITORY_VERSION = new Integer(1);
    }

    public static CompositeMetadataRepository createMemoryComposite() {
        IMetadataRepositoryManager manager = CompositeMetadataRepository.getManager();
        if (manager == null) {
            return null;
        }
        try {
            long time = System.currentTimeMillis();
            URI repositoryURI = new URI("memory:" + String.valueOf(time));
            while (manager.contains(repositoryURI)) {
                repositoryURI = new URI("memory:" + String.valueOf(++time));
            }
            CompositeMetadataRepository result = (CompositeMetadataRepository)manager.createRepository(repositoryURI, repositoryURI.toString(), "org.eclipse.equinox.p2.metadata.repository.compositeRepository", null);
            manager.removeRepository(repositoryURI);
            return result;
        }
        catch (ProvisionException e) {
            LogHelper.log((ProvisionException)e);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    private static IMetadataRepositoryManager getManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    private boolean isLocal() {
        return "file".equalsIgnoreCase(this.location.getScheme());
    }

    public boolean isModifiable() {
        return this.isLocal();
    }

    public CompositeMetadataRepository(URI location, String name, Map properties) {
        super(name == null ? (location != null ? location.toString() : "") : name, REPOSITORY_TYPE, REPOSITORY_VERSION.toString(), location, null, null, properties);
        this.save();
    }

    public CompositeMetadataRepository(CompositeRepositoryState state) {
        super(state.getName(), state.getType(), state.getVersion(), state.getLocation(), state.getDescription(), state.getProvider(), state.getProperties());
        int i = 0;
        while (i < state.getChildren().length) {
            this.addChild(state.getChildren()[i], false);
            ++i;
        }
    }

    public CompositeRepositoryState toState() {
        CompositeRepositoryState result = new CompositeRepositoryState();
        result.setName(this.getName());
        result.setType(this.getType());
        result.setVersion(this.getVersion());
        result.setLocation(this.getLocation());
        result.setDescription(this.getDescription());
        result.setProvider(this.getProvider());
        result.setProperties(this.getProperties());
        result.setChildren(this.childrenURIs.toArray(new URI[this.childrenURIs.size()]));
        return result;
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CompoundQueryable queryable = new CompoundQueryable(this.loadedRepos.toArray(new IQueryable[this.loadedRepos.size()]));
            collector = queryable.query(query, collector, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return collector;
    }

    private void addChild(URI childURI, boolean save) {
        URI absolute = URIUtil.makeAbsolute((URI)childURI, (URI)this.location);
        if (this.childrenURIs.contains(childURI) || this.childrenURIs.contains(absolute)) {
            return;
        }
        this.childrenURIs.add(childURI);
        if (save) {
            this.save();
        }
        try {
            boolean currentLoaded = CompositeMetadataRepository.getManager().contains(absolute);
            IMetadataRepository currentRepo = CompositeMetadataRepository.getManager().loadRepository(absolute, null);
            if (!currentLoaded) {
                CompositeMetadataRepository.getManager().setEnabled(absolute, false);
                CompositeMetadataRepository.getManager().setRepositoryProperty(absolute, "p2.system", String.valueOf(true));
            }
            this.loadedRepos.add(currentRepo);
        }
        catch (ProvisionException e) {
            LogHelper.log((ProvisionException)e);
        }
    }

    public void addChild(URI childURI) {
        this.addChild(childURI, true);
    }

    public void removeChild(URI childURI) {
        URI other;
        boolean removed = this.childrenURIs.remove(childURI);
        URI uRI = other = childURI.isAbsolute() ? URIUtil.makeRelative((URI)childURI, (URI)this.location) : URIUtil.makeAbsolute((URI)childURI, (URI)this.location);
        if (!removed) {
            removed = this.childrenURIs.remove(other);
        }
        if (removed) {
            IMetadataRepository found = null;
            Iterator iter = this.loadedRepos.iterator();
            while (found == null && iter.hasNext()) {
                IMetadataRepository current = (IMetadataRepository)iter.next();
                URI repoLocation = current.getLocation();
                if (URIUtil.sameURI((URI)childURI, (URI)repoLocation)) {
                    found = current;
                    continue;
                }
                if (!URIUtil.sameURI((URI)other, (URI)repoLocation)) continue;
                found = current;
            }
            if (found != null) {
                this.loadedRepos.remove(found);
            }
            this.save();
        }
    }

    public void removeAllChildren() {
        this.childrenURIs.clear();
        this.loadedRepos.clear();
        this.save();
    }

    public synchronized void addInstallableUnits(IInstallableUnit[] installableUnits) {
        throw new UnsupportedOperationException("Cannot add IUs to a composite repository");
    }

    public synchronized void removeAll() {
        throw new UnsupportedOperationException("Cannot remove IUs to a composite repository");
    }

    public synchronized boolean removeInstallableUnits(Query query, IProgressMonitor monitor) {
        throw new UnsupportedOperationException("Cannot remove IUs to a composite repository");
    }

    private static File getActualLocation(URI location, String extension) {
        File spec = URIUtil.toFile((URI)location);
        String path = spec.getAbsolutePath();
        if (path.endsWith("compositeContent" + extension)) {
            return spec;
        }
        path = path.endsWith("/") ? String.valueOf(path) + "compositeContent" : String.valueOf(path) + "/compositeContent";
        return new File(String.valueOf(path) + extension);
    }

    public static File getActualLocation(URI location) {
        return CompositeMetadataRepository.getActualLocation(location, XML_EXTENSION);
    }

    public synchronized void addReference(URI repositoryLocation, int repositoryType, int options) {
        throw new UnsupportedOperationException("Cannot add References to a composite repository");
    }

    private void save() {
        if (!this.isModifiable()) {
            return;
        }
        File file = CompositeMetadataRepository.getActualLocation(this.location);
        File jarFile = CompositeMetadataRepository.getActualLocation(this.location, JAR_EXTENSION);
        boolean compress = "true".equalsIgnoreCase((String)this.properties.get("p2.compressed"));
        try {
            OutputStream output = null;
            if (!compress) {
                if (jarFile.exists()) {
                    jarFile.delete();
                }
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                output = new FileOutputStream(file);
            } else {
                if (file.exists()) {
                    file.delete();
                }
                if (!jarFile.exists()) {
                    if (!jarFile.getParentFile().exists()) {
                        jarFile.getParentFile().mkdirs();
                    }
                    jarFile.createNewFile();
                }
                JarEntry jarEntry = new JarEntry(file.getName());
                JarOutputStream jOutput = new JarOutputStream(new FileOutputStream(jarFile));
                jOutput.putNextEntry(jarEntry);
                output = jOutput;
            }
            super.setProperty("p2.timestamp", Long.toString(System.currentTimeMillis()));
            new CompositeRepositoryIO().write(this.toState(), output, PI_REPOSITORY_TYPE);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1003, NLS.bind((String)Messages.io_failedWrite, (Object)this.location), (Throwable)e));
        }
    }

    public List getChildren() {
        ArrayList<URI> result = new ArrayList<URI>();
        Iterator iter = this.childrenURIs.iterator();
        while (iter.hasNext()) {
            result.add(URIUtil.makeAbsolute((URI)((URI)iter.next()), (URI)this.location));
        }
        return result;
    }

    public static URI getActualLocationURI(URI base, String extension) {
        if (extension == null) {
            extension = XML_EXTENSION;
        }
        return URIUtil.append((URI)base, (String)("compositeContent" + extension));
    }

    public void initialize(AbstractMetadataRepository.RepositoryState state) {
        this.name = state.Name;
        this.type = state.Type;
        this.version = state.Version.toString();
        this.provider = state.Provider;
        this.description = state.Description;
        this.location = state.Location;
        this.properties = state.Properties;
    }
}

