/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.util;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.soap.SOAPException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class RejectDoctypeSaxFilter
extends XMLFilterImpl
implements XMLReader,
LexicalHandler {
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.util", "com.sun.xml.internal.messaging.saaj.util.LocalStrings");
    static final String LEXICAL_HANDLER_PROP = "http://xml.org/sax/properties/lexical-handler";
    static final String WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".intern();
    static final String SIGNATURE_LNAME = "Signature".intern();
    static final String ENCRYPTED_DATA_LNAME = "EncryptedData".intern();
    static final String DSIG_NS = "http://www.w3.org/2000/09/xmldsig#".intern();
    static final String XENC_NS = "http://www.w3.org/2001/04/xmlenc#".intern();
    static final String ID_NAME = "ID".intern();
    private LexicalHandler lexicalHandler;

    public RejectDoctypeSaxFilter(SAXParser sAXParser) throws SOAPException {
        XMLReader xMLReader;
        try {
            xMLReader = sAXParser.getXMLReader();
        }
        catch (Exception exception) {
            log.severe("SAAJ0602.util.getXMLReader.exception");
            throw new SOAPExceptionImpl("Couldn't get an XMLReader while constructing a RejectDoctypeSaxFilter", exception);
        }
        try {
            xMLReader.setProperty(LEXICAL_HANDLER_PROP, this);
        }
        catch (Exception exception) {
            log.severe("SAAJ0603.util.setProperty.exception");
            throw new SOAPExceptionImpl("Couldn't set the lexical handler property while constructing a RejectDoctypeSaxFilter", exception);
        }
        this.setParent(xMLReader);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROP.equals(string)) {
            this.lexicalHandler = (LexicalHandler)object;
        } else {
            super.setProperty(string, object);
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        throw new SAXException("Document Type Declaration is not allowed");
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(string);
        }
    }

    public void endEntity(String string) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(string);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(cArray, n, n2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (attributes != null) {
            boolean bl = false;
            if (string == DSIG_NS || XENC_NS == string) {
                bl = true;
            }
            int n = attributes.getLength();
            AttributesImpl attributesImpl = new AttributesImpl();
            for (int i = 0; i < n; ++i) {
                String string4 = attributes.getLocalName(i);
                if (string4 != null && string4.equals("Id")) {
                    if (bl || attributes.getURI(i) == WSU_NS) {
                        attributesImpl.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), ID_NAME, attributes.getValue(i));
                        continue;
                    }
                    attributesImpl.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                    continue;
                }
                attributesImpl.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
            }
            super.startElement(string, string2, string3, attributesImpl);
        } else {
            super.startElement(string, string2, string3, attributes);
        }
    }
}

