/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.director;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class ProvisioningPlan {
    IStatus status;
    Operand[] operands;
    Map actualChangeRequest;
    Map sideEffectChanges;
    ProvisioningPlan installerPlan;
    RequestStatus globalRequestStatus;
    ProfileChangeRequest originalChangeRequest;

    public ProvisioningPlan(IStatus status, ProfileChangeRequest originalRequest, ProvisioningPlan installerPlan) {
        this(status, new Operand[0], null, null, installerPlan, originalRequest);
    }

    public ProvisioningPlan(IStatus status, Operand[] operands, Map[] actualChangeRequest, RequestStatus globalStatus, ProvisioningPlan installerPlan, ProfileChangeRequest originalRequest) {
        this.status = status;
        this.operands = operands;
        if (actualChangeRequest != null) {
            this.actualChangeRequest = actualChangeRequest[0];
            this.sideEffectChanges = actualChangeRequest[1];
        }
        this.globalRequestStatus = globalStatus;
        this.installerPlan = installerPlan;
        this.originalChangeRequest = originalRequest;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public ProfileChangeRequest getProfileChangeRequest() {
        return this.originalChangeRequest;
    }

    public Operand[] getOperands() {
        return this.operands;
    }

    public IQueryable getRemovals() {
        return new QueryablePlan(false);
    }

    public IQueryable getAdditions() {
        return new QueryablePlan(true);
    }

    public RequestStatus getRequestStatus(IInstallableUnit iu) {
        if (this.actualChangeRequest == null) {
            return null;
        }
        return (RequestStatus)this.actualChangeRequest.get(iu);
    }

    public RequestStatus getRequestStatus() {
        return this.globalRequestStatus;
    }

    public Map getSideEffectChanges() {
        if (this.sideEffectChanges == null) {
            return Collections.EMPTY_MAP;
        }
        return this.sideEffectChanges;
    }

    public ProvisioningPlan getInstallerPlan() {
        return this.installerPlan;
    }

    public void setInstallerPlan(ProvisioningPlan p) {
        this.installerPlan = p;
    }

    private class QueryablePlan
    implements IQueryable {
        private boolean addition;

        public QueryablePlan(boolean add) {
            this.addition = add;
        }

        public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
            if (ProvisioningPlan.this.operands == null || ProvisioningPlan.this.status.getSeverity() == 4) {
                return collector;
            }
            ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>();
            int i = 0;
            while (i < ProvisioningPlan.this.operands.length) {
                if (ProvisioningPlan.this.operands[i] instanceof InstallableUnitOperand) {
                    IInstallableUnit iu;
                    InstallableUnitOperand op = (InstallableUnitOperand)ProvisioningPlan.this.operands[i];
                    IInstallableUnit iInstallableUnit = iu = this.addition ? op.second() : op.first();
                    if (iu != null) {
                        list.add(iu);
                    }
                }
                ++i;
            }
            return query.perform(list.iterator(), collector);
        }
    }
}

