package jp.oarts.pirka.core.kernel;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.analyzer.cls.ClassAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlFieldMapAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlIncludeAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlMockupAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlSplitAnalyzer;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;

/**
 * v[
 * 
 * @author ito
 * 
 */
public class PirkaInfoPool  implements Serializable{

	/** HTMLp[cXg}bv */
	private static final HashMap<String, List<HtmlParts>> htmlPool = new HashMap<String, List<HtmlParts>>();

	/** tB[h}bv */
	private static final HashMap<String, Map<String, FieldMap>> fieldPool = new HashMap<String, Map<String, FieldMap>>();

	/** \bh}bv */
	private static final HashMap<String, Map<String, Method>> methodMap = new HashMap<String, Map<String, Method>>();

	/**
	 * HTMLt@CɑΉHTMLp[cXgv[擾<BR>
	 * v[ɂȂꍇHTMLt@CŎHTMLt@CC[W͂v[֊i[
	 * 
	 * @param htmlFileName
	 *            HTMLt@C
	 * @return HTMLp[cXg
	 */
	public static synchronized List<HtmlParts> getHtmlPartsList(String htmlFileName) {

		List<HtmlParts> htmlPartsList = null;

		if (!htmlPool.containsKey(htmlFileName)) {
			// ͂ i[
			StringReader sr = null;
			try {
				String html = HtmlIncludeAnalyzer.include(htmlFileName);
				sr = new StringReader(html);
				htmlPartsList = HtmlSplitAnalyzer.getHtmlParts(sr);
				htmlPartsList = HtmlMockupAnalyzer.cutMockup(htmlPartsList);
			} catch (IOException e) {
				// Ȃ
			} finally {
				if (sr != null) {
					sr.close();
				}
			}

			htmlPool.put(htmlFileName, htmlPartsList);
		} else {

			htmlPartsList = htmlPool.get(htmlFileName);
		}
		return htmlPartsList;

	}


	/**
	 * HTMLt@CɑΉ鏉l̃tB[h}bvv[擾<BR>
	 * v[ɂȂꍇ͉͂v[֊i[
	 * 
	 * @param htmlFileName
	 *            HTMLt@C
	 * @return l̃tB[h}bv
	 */
	public static synchronized FieldMap getFieldMap(String htmlFileName) {

		EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
		String entryPointClassName = entryPoint.getClass().getName();

		// NX̃Rg[}bvo
		Map<String, FieldMap> entryPointClassMap = fieldPool.get(entryPointClassName);
		if (entryPointClassMap == null) { // ΐVKɍ쐬
			entryPointClassMap = new HashMap<String, FieldMap>();
			fieldPool.put(entryPointClassName, entryPointClassMap);
		}

		FieldMap fieldMap = null;
		if (!entryPointClassMap.containsKey(htmlFileName)) {
			// ͂ i[
			List<HtmlParts> htmlPartsList = getHtmlPartsList(htmlFileName);
			fieldMap = HtmlFieldMapAnalyzer.getFieldMap(htmlPartsList, entryPoint.getCtrlProcesserMap());
			entryPointClassMap.put(htmlFileName, fieldMap);
		} else {
			fieldMap = entryPointClassMap.get(htmlFileName);
		}
		return fieldMap;

	}
	
	
	/**
	 * p[^Ŏw肳ꂽIuWFNgƃANVANV\bhv[擾<BR>
	 * v[ɂȂꍇ͉͂v[֊i[
	 * 
	 * @param object
	 *            IuWFNg
	 * @param name
	 *            ANV
	 * @return ANV\bh
	 */
	public static synchronized Method getMethod(Object object, String name) {
		return getMethodMap(object).get(name);
	}

	/**
	 * p[^Ŏw肳ꂽIuWFNgANV\bh}bvv[擾<BR>
	 * v[ɂȂꍇ͉͂v[֊i[
	 * 
	 * @param object
	 *            IuWFNg
	 * @return ANV\bh
	 */
	private static Map<String, Method> getMethodMap(Object object) {

		Map<String, Method> rtnMap = null;
		String className = object.getClass().getName();

		if (!methodMap.containsKey(className)) {
			rtnMap = ClassAnalyzer.getMethodMap(object);
			methodMap.put(className, rtnMap);
		} else {
			rtnMap = methodMap.get(className);
		}

		return rtnMap;
	}

}
