/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.converter;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import jp.oarts.pirka.core.util.converter.DataConverter;
import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataConverterDefined implements DataConverter
{
    STRING(new DataConverter(){

        public Object win2Target(Object windowFieldData) {
            return windowFieldData == null ? "" : windowFieldData.toString();
        }

        public Object target2Win(Object targetData) {
            return targetData == null ? "" : targetData.toString();
        }
    }),
    INTEGER(new DataConverter(){

        public Object win2Target(Object windowFieldData) {
            if (windowFieldData instanceof String) {
                return PirkaFormatUtil.parseInteger((String)windowFieldData);
            }
            return null;
        }

        public Object target2Win(Object targetData) {
            if (targetData instanceof Integer) {
                return targetData.toString();
            }
            return "";
        }
    }),
    LONG(new DataConverter(){

        public Object win2Target(Object windowFieldData) {
            if (windowFieldData instanceof String) {
                return PirkaFormatUtil.parseLong((String)windowFieldData);
            }
            return null;
        }

        public Object target2Win(Object targetData) {
            if (targetData instanceof Long) {
                return targetData.toString();
            }
            return "";
        }
    }),
    DATE(new DataConverter(){

        public Object win2Target(Object windowFieldData) {
            if (windowFieldData instanceof String) {
                return PirkaFormatUtil.parseDate((String)windowFieldData);
            }
            return null;
        }

        public Object target2Win(Object targetData) {
            if (targetData instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                return sdf.format((String)targetData);
            }
            return "";
        }
    }),
    TIME(new DataConverter(){

        public Object win2Target(Object windowFieldData) {
            if (windowFieldData instanceof String) {
                return PirkaFormatUtil.parseTime((String)windowFieldData);
            }
            return null;
        }

        public Object target2Win(Object targetData) {
            if (targetData instanceof Time) {
                SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
                return sdf.format((String)targetData);
            }
            return "";
        }
    }),
    TIMESTAMP(new DataConverter(){

        public Object win2Target(Object windowFieldData) {
            if (windowFieldData instanceof String) {
                return PirkaFormatUtil.parseTimestamp((String)windowFieldData);
            }
            return null;
        }

        public Object target2Win(Object targetData) {
            if (targetData instanceof Timestamp) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HHmmss");
                return sdf.format((String)targetData);
            }
            return "";
        }
    }),
    BIGDECIMAL(new DataConverter(){

        public Object win2Target(Object windowFieldData) {
            if (windowFieldData instanceof String) {
                return PirkaFormatUtil.parseBigDecimal((String)windowFieldData);
            }
            return null;
        }

        public Object target2Win(Object targetData) {
            if (targetData instanceof BigDecimal) {
                return targetData.toString();
            }
            return "";
        }
    });

    private DataConverter dataConverter;

    private DataConverterDefined(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public Object win2Target(Object windowFieldData) {
        return this.dataConverter.win2Target(windowFieldData);
    }

    @Override
    public Object target2Win(Object targetData) {
        return this.dataConverter.target2Win(targetData);
    }
}

