/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.converter;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.converter.Converter;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.util.format.PirkaFormatUtil;
import jp.oarts.pirka.core.win.PirkaWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanConverter
implements Serializable {
    public static void getBean(Object beanObject, FieldMap fieldMap, Converter ... converters) {
        BeanConverter.getBean(beanObject, fieldMap, false, converters);
    }

    public static void getBean(Object beanObject, FieldMap fieldMap, boolean inputCtrlOnly, Converter ... converters) {
        Map<String, List<Method>> methodMap = BeanConverter.createMethodMap(beanObject.getClass());
        Map<String, Converter> converterMap = BeanConverter.createConverterMap(converters);
        BeanConverter.getBeanMain(beanObject, methodMap, fieldMap, converterMap, inputCtrlOnly);
    }

    public static List getBeanList(Class beanClass, FieldMap fieldMap, String loopFieldName, Converter ... converters) {
        return BeanConverter.getBeanList(beanClass, fieldMap, loopFieldName, false, converters);
    }

    public static List getBeanList(Class beanClass, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter ... converters) {
        Map<String, Converter> converterMap = BeanConverter.createConverterMap(converters);
        Map<String, List<Method>> methodMap = BeanConverter.createMethodMap(beanClass);
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < fieldMap.getFieldMapSize(loopFieldName)) {
            Object bean = null;
            try {
                bean = beanClass.newInstance();
                list.add(bean);
                BeanConverter.getBeanMain(bean, methodMap, fieldMap.getFieldMap(loopFieldName, i), converterMap, inputCtrlOnly);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++i;
        }
        return list;
    }

    public static void getBeanList(List list, FieldMap fieldMap, String loopFieldName, Converter ... converters) {
        BeanConverter.getBeanList(list, fieldMap, loopFieldName, false, converters);
    }

    public static void getBeanList(List list, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter ... converters) {
        if (list == null || list.size() <= 0) {
            return;
        }
        int loopCount = list.size();
        int loopMapSize = fieldMap.getFieldMapSize(loopFieldName);
        if (loopMapSize < loopCount) {
            loopCount = loopMapSize;
        }
        Map<String, Converter> converterMap = BeanConverter.createConverterMap(converters);
        Map<String, List<Method>> methodMap = BeanConverter.createMethodMap(list.get(0).getClass());
        int i = 0;
        while (i < loopCount) {
            Object bean = list.get(i);
            BeanConverter.getBeanMain(bean, methodMap, fieldMap.getFieldMap(loopFieldName, i), converterMap, inputCtrlOnly);
            ++i;
        }
    }

    private static void getBeanMain(Object bean, Map<String, List<Method>> methodMap, FieldMap fieldMap, Map<String, Converter> converterMap, boolean inputCtrlOnly) {
        String[] fieldNames;
        Map<String, String> groupMap = BeanConverter.createGroupMap(fieldMap);
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            BeanConverter.getBeanMain(bean, methodMap, fieldMap, fieldName, false, converterMap, inputCtrlOnly);
            ++n2;
        }
        for (String fieldName : groupMap.keySet()) {
            BeanConverter.getBeanMain(bean, methodMap, fieldMap, fieldName, true, converterMap, inputCtrlOnly);
        }
    }

    private static void getBeanMain(Object bean, Map<String, List<Method>> methodMap, FieldMap fieldMap, String fieldName, boolean groupe, Map<String, Converter> converterMap, boolean inputCtrlOnly) {
        List<Method> list;
        Object value = null;
        if (!groupe) {
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
            if (cp.isLoop() || cp.isGroupItem() || inputCtrlOnly && !cp.isInputCtrl()) {
                return;
            }
            value = fieldItem.getValue();
        } else {
            value = fieldMap.getGroupValue(fieldName);
        }
        Converter converter = converterMap.get(fieldName);
        String membertName = fieldName;
        if (converter != null) {
            membertName = converter.getTargetFieldName();
            if (converter.getDataConverter() != null) {
                value = converter.getDataConverter().win2Target(value);
            }
        }
        if ((list = methodMap.get(BeanConverter.createSetterName(membertName))) == null) {
            return;
        }
        boolean ok = false;
        for (Method method : list) {
            try {
                Class<?>[] params = method.getParameterTypes();
                if (params.length == 1) {
                    if (value == null) {
                        if (!params[0].isPrimitive()) {
                            method.invoke(bean, value);
                            ok = true;
                        }
                    } else if (params[0].isInstance(value)) {
                        method.invoke(bean, value);
                        ok = true;
                    } else if (params[0] == Boolean.TYPE && Boolean.class.isInstance(value)) {
                        method.invoke(bean, value);
                        ok = true;
                    } else if (params[0] == Timestamp.class && String.class.isInstance(value)) {
                        method.invoke(bean, PirkaFormatUtil.parseTimestamp((String)value));
                        ok = true;
                    } else if (params[0] == Time.class && String.class.isInstance(value)) {
                        method.invoke(bean, PirkaFormatUtil.parseTime((String)value));
                        ok = true;
                    } else if (params[0] == Date.class && String.class.isInstance(value)) {
                        method.invoke(bean, PirkaFormatUtil.parseDate((String)value));
                        ok = true;
                    } else if (params[0] == java.util.Date.class && String.class.isInstance(value)) {
                        method.invoke(bean, PirkaFormatUtil.parseDate((String)value));
                        ok = true;
                    } else if (params[0] == Integer.class && String.class.isInstance(value)) {
                        method.invoke(bean, PirkaFormatUtil.parseInteger((String)value));
                        ok = true;
                    } else if (params[0] == Integer.TYPE && String.class.isInstance(value)) {
                        Integer intValue = PirkaFormatUtil.parseInteger((String)value);
                        if (intValue == null) {
                            method.invoke(bean, 0);
                        } else {
                            method.invoke(bean, intValue);
                        }
                        ok = true;
                    } else if (params[0] == Long.class && String.class.isInstance(value)) {
                        method.invoke(bean, PirkaFormatUtil.parseLong((String)value));
                        ok = true;
                    } else if (params[0] == Long.TYPE && String.class.isInstance(value)) {
                        Long longValue = PirkaFormatUtil.parseLong((String)value);
                        if (longValue == null) {
                            method.invoke(bean, 0L);
                        } else {
                            method.invoke(bean, longValue);
                        }
                        ok = true;
                    } else if (params[0] == BigDecimal.class && String.class.isInstance(value)) {
                        method.invoke(bean, PirkaFormatUtil.parseBigDecimal((String)value));
                        ok = true;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            if (ok) break;
        }
    }

    public static void setBean(PirkaWindow window, Object beanObject, FieldMap fieldMap, Converter ... converters) {
        Map<String, Converter> converterMap = BeanConverter.createConverterMap(converters);
        Map<String, List<Method>> methodMap = BeanConverter.createMethodMap(beanObject.getClass());
        BeanConverter.setBeanMain(beanObject, methodMap, fieldMap, converterMap, false);
    }

    public static void setBean(PirkaWindow window, Object beanObject, FieldMap fieldMap, boolean inputCtrlOnly, Converter ... converters) {
        Map<String, Converter> converterMap = BeanConverter.createConverterMap(converters);
        Map<String, List<Method>> methodMap = BeanConverter.createMethodMap(beanObject.getClass());
        BeanConverter.setBeanMain(beanObject, methodMap, fieldMap, converterMap, inputCtrlOnly);
    }

    public static void setBeanList(PirkaWindow window, List list, FieldMap fieldMap, String loopFieldName, Converter ... converters) {
        BeanConverter.setBeanList(window, list, fieldMap, loopFieldName, false, converters);
    }

    public static void setBeanList(PirkaWindow window, List list, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter ... converters) {
        fieldMap.clearFieldMap(loopFieldName);
        if (list.size() <= 0) {
            return;
        }
        Map<String, Converter> converterMap = BeanConverter.createConverterMap(converters);
        Map<String, List<Method>> methodMap = BeanConverter.createMethodMap(list.get(0).getClass());
        for (Object bean : list) {
            FieldMap loopFieldMap = window.createLoopFieldMap(loopFieldName);
            BeanConverter.setBeanMain(bean, methodMap, loopFieldMap, converterMap, inputCtrlOnly);
            fieldMap.addFieldMap(loopFieldName, loopFieldMap);
        }
    }

    private static void setBeanMain(Object beanObject, Map<String, List<Method>> methodMap, FieldMap fieldMap, Map<String, Converter> converterMap, boolean inputCtrlOnly) {
        String[] fieldNames;
        Map<String, String> groupMap = BeanConverter.createGroupMap(fieldMap);
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            BeanConverter.setBeanMain(beanObject, methodMap, fieldMap, fieldName, false, converterMap, inputCtrlOnly);
            ++n2;
        }
        for (String fieldName : groupMap.keySet()) {
            BeanConverter.setBeanMain(beanObject, methodMap, fieldMap, fieldName, true, converterMap, inputCtrlOnly);
        }
    }

    private static void setBeanMain(Object bean, Map<String, List<Method>> methodMap, FieldMap fieldMap, String fieldName, boolean groupe, Map<String, Converter> converterMap, boolean inputCtrlOnly) {
        List<Method> listIs;
        FieldItem fieldItem;
        CtrlProcesser cp = null;
        if (!groupe && ((cp = (fieldItem = fieldMap.getFieldItem(fieldName)).getCtrl().getCtrlProcesser()).isLoop() || cp.isGroupItem() || inputCtrlOnly && !cp.isInputCtrl())) {
            return;
        }
        Converter converter = converterMap.get(fieldName);
        String membertName = fieldName;
        if (converter != null) {
            membertName = converter.getTargetFieldName();
        }
        ArrayList<Method> list = new ArrayList<Method>();
        List<Method> listSet = methodMap.get(BeanConverter.createGetterName(membertName));
        if (listSet != null) {
            list.addAll(listSet);
        }
        if ((listIs = methodMap.get(BeanConverter.createIsName(membertName))) != null) {
            list.addAll(listIs);
        }
        Object value = null;
        boolean ok = false;
        for (Method method : list) {
            try {
                Class<?>[] params = method.getParameterTypes();
                if (params.length != 0) continue;
                value = method.invoke(bean, new Object[0]);
                ok = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (!ok) {
            return;
        }
        if (converter != null && converter.getDataConverter() != null) {
            value = converter.getDataConverter().target2Win(value);
        }
        if (groupe) {
            if (value == null) {
                fieldMap.setGroupValue(fieldName, "");
            } else if (String.class.isInstance(value)) {
                fieldMap.setGroupValue(fieldName, (String)value);
            } else if (Timestamp.class.isInstance(value)) {
                fieldMap.setGroupValue(fieldName, (Timestamp)value);
            } else if (Time.class.isInstance(value)) {
                fieldMap.setGroupValue(fieldName, (Time)value);
            } else if (Date.class.isInstance(value)) {
                fieldMap.setGroupValue(fieldName, (Date)value);
            } else if (java.util.Date.class.isInstance(value)) {
                fieldMap.setGroupValue(fieldName, new Date(((java.util.Date)value).getTime()));
            } else if (Integer.class.isInstance(value)) {
                fieldMap.setGroupValue(fieldName, (Integer)value);
            } else if (Long.class.isInstance(value)) {
                fieldMap.setGroupValue(fieldName, (Long)value);
            } else if (BigDecimal.class.isInstance(value)) {
                fieldMap.setGroupValue(fieldName, (BigDecimal)value);
            }
        } else if (cp.isCheckCtrl()) {
            if (value == null) {
                fieldMap.setValue(fieldName, false);
            } else if (Boolean.class.isInstance(value)) {
                fieldMap.setValue(fieldName, (Boolean)value);
            } else {
                fieldMap.setValue(fieldName, false);
            }
        } else if (value == null) {
            fieldMap.setValue(fieldName, "");
        } else if (String.class.isInstance(value)) {
            fieldMap.setValue(fieldName, (String)value);
        } else if (Timestamp.class.isInstance(value)) {
            fieldMap.setValue(fieldName, (Timestamp)value);
        } else if (Time.class.isInstance(value)) {
            fieldMap.setValue(fieldName, (Time)value);
        } else if (Date.class.isInstance(value)) {
            fieldMap.setValue(fieldName, (Date)value);
        } else if (java.util.Date.class.isInstance(value)) {
            fieldMap.setValue(fieldName, new Date(((java.util.Date)value).getTime()));
        } else if (Integer.class.isInstance(value)) {
            fieldMap.setValue(fieldName, (Integer)value);
        } else if (Long.class.isInstance(value)) {
            fieldMap.setValue(fieldName, (Long)value);
        } else if (BigDecimal.class.isInstance(value)) {
            fieldMap.setValue(fieldName, (BigDecimal)value);
        }
    }

    private static Map<String, List<Method>> createMethodMap(Class beanClass) {
        Method[] methods;
        HashMap<String, List<Method>> map = new HashMap<String, List<Method>>();
        Method[] methodArray = methods = beanClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            List<Method> list = null;
            if (!map.containsKey(method.getName())) {
                list = new ArrayList();
                map.put(method.getName(), list);
            } else {
                list = (List)map.get(method.getName());
            }
            list.add(method);
            ++n2;
        }
        return map;
    }

    private static String createGetterName(String name) {
        if (name == null || name.length() <= 0) {
            return "get";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("get");
        sb.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    private static String createIsName(String name) {
        if (name == null || name.length() <= 0) {
            return "is";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("is");
        sb.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    private static String createSetterName(String name) {
        if (name == null || name.length() <= 0) {
            return "set";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("set");
        sb.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    private static Map<String, Converter> createConverterMap(Converter ... converters) {
        HashMap<String, Converter> map = new HashMap<String, Converter>();
        Converter[] converterArray = converters;
        int n = converters.length;
        int n2 = 0;
        while (n2 < n) {
            Converter converter = converterArray[n2];
            map.put(converter.getWindowFieldName(), converter);
            ++n2;
        }
        return map;
    }

    private static Map<String, String> createGroupMap(FieldMap fieldMap) {
        HashMap<String, String> groupMap = new HashMap<String, String>();
        BeanConverter.createGroupMapMain(groupMap, fieldMap, 0);
        return groupMap;
    }

    private static void createGroupMapMain(Map<String, String> groupMap, FieldMap fieldMap, int groupLevel) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
            if (cp.isGroupItem() && fieldItem.getCtrl().getGroupLevel() == groupLevel) {
                groupMap.put(fieldItem.getCtrl().getBaseName(), fieldItem.getCtrl().getBaseName());
            }
            if (cp.isLoop()) {
                List list = (List)fieldItem.getValue();
                for (FieldMap childFieldMap : list) {
                    BeanConverter.createGroupMapMain(groupMap, childFieldMap, groupLevel + 1);
                }
            }
            ++n2;
        }
    }
}

